/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.core.analysis;

import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.ptp.pldt.common.Artifact;
import org.eclipse.ptp.pldt.common.ArtifactAnalysisBase;
import org.eclipse.ptp.pldt.common.IArtifactAnalysis;
import org.eclipse.ptp.pldt.common.ScanReturn;
import org.eclipse.ptp.pldt.common.util.SourceInfo;
import org.eclipse.ptp.pldt.openmp.analysis.OpenMPAnalysisManager;
import org.eclipse.ptp.pldt.openmp.analysis.OpenMPErrorManager;
import org.eclipse.ptp.pldt.openmp.analysis.PAST.PASTNode;
import org.eclipse.ptp.pldt.openmp.analysis.PAST.PASTPragma;
import org.eclipse.ptp.pldt.openmp.core.OpenMPScanReturn;
import org.eclipse.ptp.pldt.openmp.core.analysis.OpenMPCASTVisitor;
import org.eclipse.ptp.pldt.openmp.core.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenMPCArtifactAnalysis
extends ArtifactAnalysisBase
implements IArtifactAnalysis {
    private static final String OPENMP_DIRECTIVE = Messages.RunAnalyseOpenMPcommandHandler_OpenMP_directive;

    public ScanReturn runArtifactAnalysis(String languageID, ITranslationUnit tu, List<String> includes, boolean allowPrefixOnlyMatch) {
        OpenMPScanReturn msr = new OpenMPScanReturn();
        String fileName = tu.getElementName();
        IASTTranslationUnit atu = this.getAST(tu);
        if (atu != null) {
            atu.accept((ASTVisitor)new OpenMPCASTVisitor(includes, fileName, allowPrefixOnlyMatch, msr));
            if (tu.getResource() instanceof IFile) {
                this.processOpenMPPragmas(msr, atu, (IFile)tu.getResource());
            }
        }
        return msr;
    }

    protected void processOpenMPPragmas(OpenMPScanReturn msr, IASTTranslationUnit astTransUnit, IFile iFile) {
        OpenMPAnalysisManager omgr = new OpenMPAnalysisManager(astTransUnit, iFile);
        PASTNode[] pList = omgr.getPAST();
        int i = 0;
        while (i < pList.length) {
            PASTNode temp = pList[i];
            String tempStr = temp.getRawSignature();
            if (pList[i] instanceof PASTPragma) {
                PASTPragma pop = (PASTPragma)pList[i];
                SourceInfo si = this.getSourceInfo((PASTNode)pop, 3);
                String shortName = pop.getContent();
                if (shortName.length() == 0) {
                    shortName = "#pragma";
                }
                Artifact a = new Artifact(pop.getFilename(), pop.getStartingLine(), pop.getStartLocation(), shortName, OPENMP_DIRECTIVE, si, (Object)pop);
                msr.addArtifact(a);
            }
            ++i;
        }
        msr.addProblems(OpenMPErrorManager.getCurrentErrorManager().getErrors());
    }

    private SourceInfo getSourceInfo(PASTNode pastNode, int constructType) {
        SourceInfo sourceInfo = null;
        IASTNodeLocation[] locations = pastNode.getNodeLocations();
        if (locations.length == 1) {
            IASTFileLocation astFileLocation = null;
            if (locations[0] instanceof IASTFileLocation) {
                astFileLocation = (IASTFileLocation)locations[0];
                sourceInfo = new SourceInfo();
                sourceInfo.setStartingLine(astFileLocation.getStartingLineNumber());
                sourceInfo.setStart(astFileLocation.getNodeOffset());
                sourceInfo.setEnd(astFileLocation.getNodeOffset() + astFileLocation.getNodeLength());
                sourceInfo.setConstructType(constructType);
            }
        }
        return sourceInfo;
    }
}

