/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.preference;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.php.phpunit.PHPUnitPlugin;

public class PHPUnitPreferenceKeys {
    public static final String CODE_COVERAGE = "PHPUnit_CodeCoverage";
    public static final String REPORTING = "PHPUnit_Reporting";
    public static final String FILTER = "PHPUnit_Filter";
    public static final String PORT = "PHPUnit_Port";
    public static final String REPORT_PATH = "PHPUnit_ReportPath";
    public static final String PHPUNITXML_PATH = "PHPUnitXML_Path";
    public static final String PHPUNIT_PATH = "PHPUnit_Path";
    public static final String PHPUNIT_PHAR_PATH = "PHPUnit_Phar_Path";
    public static final String SHOW_EXECUTION_TIME = "show_execution_time";

    public static boolean getCodeCoverage() {
        return PHPUnitPreferenceKeys.getPreferenceStore().getBoolean(CODE_COVERAGE);
    }

    public static boolean getReporting() {
        return PHPUnitPreferenceKeys.getPreferenceStore().getBoolean(REPORTING);
    }

    public static boolean getFilterStack() {
        return PHPUnitPreferenceKeys.getPreferenceStore().getBoolean(FILTER);
    }

    public static String getReportPath() {
        return PHPUnitPreferenceKeys.getPreferenceStore().getString(REPORT_PATH);
    }

    public static int getPort() {
        return PHPUnitPreferenceKeys.getPreferenceStore().getInt(PORT);
    }

    public static String getPHPUnitPharPath() {
        return PHPUnitPreferenceKeys.getPreferenceStore().getString(PHPUNIT_PHAR_PATH);
    }

    public static void setReportPath(String reportPath) {
        PHPUnitPreferenceKeys.getPreferenceStore().setValue(REPORT_PATH, reportPath);
    }

    private static IPreferenceStore getPreferenceStore() {
        return PHPUnitPlugin.getDefault().getPreferenceStore();
    }

    public static void initializeDefaultValues() {
        IPreferenceStore store = PHPUnitPreferenceKeys.getPreferenceStore();
        store.setDefault(PORT, "7478");
        store.setDefault(FILTER, true);
        store.setDefault(CODE_COVERAGE, false);
        store.setDefault(REPORTING, false);
        store.setDefault(REPORT_PATH, PHPUnitPreferenceKeys.getWritableDir());
        store.setDefault(SHOW_EXECUTION_TIME, true);
    }

    public static void setFilterStack(boolean filter) {
        PHPUnitPreferenceKeys.getPreferenceStore().setValue(FILTER, filter);
    }

    private PHPUnitPreferenceKeys() {
    }

    private static String getWritableDir() {
        String path = PHPUnitPreferenceKeys.getWritable(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        if (path == null) {
            path = PHPUnitPreferenceKeys.getWritable(null);
        }
        return path;
    }

    public static String getWritable(String path) {
        try {
            File tempFile = path != null ? File.createTempFile("___", "", new File(path)) : File.createTempFile("___", "");
            String parent = tempFile.getParent();
            tempFile.delete();
            return parent;
        }
        catch (IOException e) {
            PHPUnitPlugin.log(e);
            return null;
        }
    }
}

