/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.buffer.IBufferHandler;
import org.eclipse.net4j.signal.RemoteException;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.IOTimeoutException;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class BufferInputStream
extends InputStream
implements IBufferHandler {
    public static final long NO_TIMEOUT = -1L;
    public static final long DEFAULT_MILLIS_BEFORE_TIMEOUT = -1L;
    public static final long DEFAULT_MILLIS_INTERRUPT_CHECK = 100L;
    private static final boolean DISABLE_TIMEOUT = Boolean.getBoolean("org.eclipse.net4j.buffer.BufferInputStream.disableTimeout");
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_BUFFER_STREAM, BufferInputStream.class);
    private final boolean tracerEnabled;
    private BlockingQueue<IBuffer> buffers = new LinkedBlockingQueue<IBuffer>();
    private IBuffer currentBuffer;
    private boolean eos;
    private boolean ccam;
    private RemoteException exception;
    private long stopTimeMillis;

    public BufferInputStream() {
        this.tracerEnabled = TRACER.isEnabled();
    }

    public boolean isCCAM() {
        return this.ccam;
    }

    public long getMillisBeforeTimeout() {
        return -1L;
    }

    public long getMillisInterruptCheck() {
        return 100L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartTimeout() {
        BufferInputStream bufferInputStream = this;
        synchronized (bufferInputStream) {
            this.stopTimeMillis = System.currentTimeMillis() + this.getMillisBeforeTimeout();
        }
    }

    public RuntimeException getException() {
        return this.exception;
    }

    public void setException(RemoteException exception) {
        this.exception = exception;
    }

    public void handleBuffer(IBuffer buffer) {
        if (this.buffers != null) {
            this.buffers.add(buffer);
        }
    }

    public int read() throws IOException {
        ByteBuffer byteBuffer;
        if (this.currentBuffer == null) {
            if (this.eos) {
                return -1;
            }
            if (!this.ensureBuffer()) {
                return -1;
            }
        }
        if (!(byteBuffer = this.currentBuffer.getByteBuffer()).hasRemaining()) {
            return -1;
        }
        int result = byteBuffer.get() & 0xFF;
        if (this.tracerEnabled) {
            TRACER.trace("<-- " + HexUtil.formatByte((int)result) + (result >= 32 ? " " + Character.toString((char)result) : ""));
        }
        if (!byteBuffer.hasRemaining()) {
            this.currentBuffer.release();
            this.currentBuffer = null;
        }
        return result;
    }

    public void close() throws IOException {
        this.buffers = null;
        this.currentBuffer = null;
        super.close();
        if (this.ccam) {
            this.closeChannel();
        }
    }

    public String toString() {
        return "BufferInputStream";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean ensureBuffer() throws IOException {
        long check = this.getMillisInterruptCheck();
        try {
            boolean noTimeout;
            boolean bl = noTimeout = this.getMillisBeforeTimeout() == -1L;
            if (!noTimeout) {
                this.restartTimeout();
            }
            while (this.currentBuffer == null) {
                this.throwRemoteExceptionIfExists();
                if (this.buffers == null) {
                    return false;
                }
                long timeout = noTimeout || DISABLE_TIMEOUT ? check : this.computeTimeout(check);
                this.currentBuffer = this.buffers.poll(timeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
        this.eos = this.currentBuffer.isEOS();
        this.ccam = this.currentBuffer.isCCAM();
        return true;
    }

    protected void closeChannel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long computeTimeout(long check) throws IOTimeoutException {
        long remaining;
        if (DISABLE_TIMEOUT) {
            return Integer.MAX_VALUE;
        }
        BufferInputStream bufferInputStream = this;
        synchronized (bufferInputStream) {
            remaining = this.stopTimeMillis;
        }
        if ((remaining -= System.currentTimeMillis()) <= 0L) {
            throw new IOTimeoutException();
        }
        return Math.min(remaining, check);
    }

    private void throwRemoteExceptionIfExists() {
        if (this.exception != null) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            this.exception.setLocalStacktrace(stackTrace);
            throw this.exception;
        }
    }
}

