/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.CountDownLatch;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.WrappedException;

public abstract class AsyncOutputStream
extends PipedOutputStream {
    private CountDownLatch latch = new CountDownLatch(1);

    public AsyncOutputStream() throws IOException {
        final PipedInputStream in = new PipedInputStream(this);
        Thread thread = new Thread("AsyncOutputStream"){

            public void run() {
                try {
                    try {
                        AsyncOutputStream.this.asyncWrite(in);
                    }
                    catch (IOException ex) {
                        OM.LOG.error(ex);
                        throw WrappedException.wrap(ex);
                    }
                }
                finally {
                    AsyncOutputStream.this.latch.countDown();
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public void close() throws IOException {
        super.close();
        try {
            this.latch.await();
        }
        catch (InterruptedException ex) {
            throw WrappedException.wrap(ex);
        }
    }

    protected abstract void asyncWrite(InputStream var1) throws IOException;
}

