/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.net4j.util.ObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoundRobinBlockingQueue<E>
implements BlockingQueue<E> {
    private BlockingQueue<Entry<E>> list = new LinkedBlockingQueue<Entry<E>>();

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int size = 0;
        BlockingQueue<Entry<E>> blockingQueue = this.list;
        synchronized (blockingQueue) {
            for (Entry entry : this.list) {
                size += entry.getCount();
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        BlockingQueue<Entry<E>> blockingQueue = this.list;
        synchronized (blockingQueue) {
            return this.list.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean offer(E e) {
        BlockingQueue<Entry<E>> blockingQueue = this.list;
        synchronized (blockingQueue) {
            Entry entry;
            Iterator iterator = this.list.iterator();
            do {
                if (iterator.hasNext()) continue;
                return this.list.add(new Entry<E>(e));
            } while (!ObjectUtil.equals((entry = (Entry)iterator.next()).getElement(), e));
            entry.increaseCount();
            return true;
        }
    }

    @Override
    public boolean offer(E o, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offer(o);
    }

    @Override
    public void put(E o) throws InterruptedException {
        this.offer(o);
    }

    @Override
    public boolean add(E o) {
        return this.offer(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        BlockingQueue<Entry<E>> blockingQueue = this.list;
        synchronized (blockingQueue) {
            Entry<E> entry;
            block5: {
                entry = this.list.poll(timeout, unit);
                if (entry != null) break block5;
                return null;
            }
            if (entry.decreaseCount() > 0) {
                this.list.add(entry);
            }
            return entry.getElement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        BlockingQueue<Entry<E>> blockingQueue = this.list;
        synchronized (blockingQueue) {
            Entry entry;
            block5: {
                entry = (Entry)this.list.poll();
                if (entry != null) break block5;
                return null;
            }
            if (entry.decreaseCount() > 0) {
                this.list.add(entry);
            }
            return entry.getElement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        BlockingQueue<Entry<E>> blockingQueue = this.list;
        synchronized (blockingQueue) {
            Entry<E> entry = this.list.take();
            if (entry.decreaseCount() > 0) {
                this.list.add(entry);
            }
            return entry.getElement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        BlockingQueue<Entry<E>> blockingQueue = this.list;
        synchronized (blockingQueue) {
            Entry entry;
            block4: {
                entry = (Entry)this.list.peek();
                if (entry != null) break block4;
                return null;
            }
            return entry.getElement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E element() {
        BlockingQueue<Entry<E>> blockingQueue = this.list;
        synchronized (blockingQueue) {
            Entry entry;
            block4: {
                entry = (Entry)this.list.element();
                if (entry != null) break block4;
                return null;
            }
            return entry.getElement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove() {
        BlockingQueue<Entry<E>> blockingQueue = this.list;
        synchronized (blockingQueue) {
            Entry entry = (Entry)this.list.remove();
            if (entry.decreaseCount() > 0) {
                this.list.add(entry);
            }
            return entry.getElement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean remove(Object o) {
        BlockingQueue<Entry<E>> blockingQueue = this.list;
        synchronized (blockingQueue) {
            Entry entry;
            Iterator it = this.list.iterator();
            do {
                if (it.hasNext()) continue;
                return false;
            } while (!ObjectUtil.equals((entry = (Entry)it.next()).getElement(), o));
            if (entry.decreaseCount() <= 0) return true;
            it.remove();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        BlockingQueue<Entry<E>> blockingQueue = this.list;
        synchronized (blockingQueue) {
            this.list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        ArrayList copy = new ArrayList();
        BlockingQueue<Entry<E>> blockingQueue = this.list;
        synchronized (blockingQueue) {
            boolean again;
            int round = 0;
            do {
                again = false;
                for (Entry entry : this.list) {
                    int rest = entry.getCount() - round;
                    if (rest <= 0) continue;
                    copy.add(entry.getElement());
                    if (rest <= 1) continue;
                    again = true;
                }
                ++round;
            } while (again);
        }
        return copy.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean contains(Object o) {
        BlockingQueue<Entry<E>> blockingQueue = this.list;
        synchronized (blockingQueue) {
            Entry entry;
            Iterator iterator = this.list.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!ObjectUtil.equals((entry = (Entry)iterator.next()).getElement(), o));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        BlockingQueue<Entry<E>> blockingQueue = this.list;
        synchronized (blockingQueue) {
            return this.list.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] array) {
        BlockingQueue<Entry<E>> blockingQueue = this.list;
        synchronized (blockingQueue) {
            return this.list.toArray(array);
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        BlockingQueue<Entry<E>> blockingQueue = this.list;
        synchronized (blockingQueue) {
            return this.list.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Entry<E> {
        private E element;
        private int count;

        public Entry(E element) {
            this.element = element;
            this.count = 1;
        }

        public E getElement() {
            return this.element;
        }

        public int getCount() {
            return this.count;
        }

        public int increaseCount() {
            return ++this.count;
        }

        public int decreaseCount() {
            return --this.count;
        }

        public String toString() {
            return String.valueOf(this.element.toString()) + "(" + this.count + ")";
        }
    }
}

