/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.symbols;

import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.outline.SymbolsLabelProvider;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSPSymbolInFileDialog
extends PopupDialog {
    private ITextEditor fTextEditor;
    private List<? extends SymbolInformation> fSymbols;
    private FilteredTree fFilteredTree;

    public LSPSymbolInFileDialog(Shell parentShell, ITextEditor textEditor, List<? extends SymbolInformation> symbols) {
        super(parentShell, 4, true, true, true, false, false, null, null);
        this.fTextEditor = textEditor;
        this.fSymbols = symbols;
        this.create();
    }

    protected Control createDialogArea(Composite parent) {
        this.fFilteredTree = new FilteredTree(parent, 2048, new PatternFilter(), true);
        TreeViewer viewer = this.fFilteredTree.getViewer();
        viewer.setContentProvider((IContentProvider)new SymbolsContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new SymbolsLabelProvider());
        viewer.setUseHashlookup(true);
        viewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            SymbolInformation symbolInformation = (SymbolInformation)selection.getFirstElement();
            Location location = symbolInformation.getLocation();
            IResource targetResource = LSPEclipseUtils.findResourceFor(location.getUri());
            if (targetResource == null) {
                return;
            }
            IDocument targetDocument = FileBuffers.getTextFileBufferManager().getTextFileBuffer(targetResource.getFullPath(), LocationKind.IFILE).getDocument();
            if (targetDocument != null) {
                try {
                    int offset = LSPEclipseUtils.toOffset(location.getRange().getStart(), targetDocument);
                    int endOffset = LSPEclipseUtils.toOffset(location.getRange().getEnd(), targetDocument);
                    this.fTextEditor.selectAndReveal(offset, endOffset - offset);
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logError(e);
                }
            }
        });
        viewer.setInput(this.fSymbols);
        return this.fFilteredTree;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setSize(280, 300);
        Control control = (Control)this.fTextEditor.getAdapter(Control.class);
        if (control != null) {
            shell.setLocation(control.toDisplay(control.getBounds().width - shell.getSize().x, control.getLocation().y));
        }
    }

    private static class SymbolsContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        private SymbolsContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }
}

