/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpmstubby.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.internal.rpmstubby.StubbyLog;
import org.eclipse.linuxtools.internal.rpmstubby.parser.PerlMakefileParser;

public class PerlModel {
    private static final String FIX_ME = "#FIXME";
    private static final String LICENSE_REQ = "GPL+ or Artistic";
    private static final String CPAN_URL = "http://search.cpan.org/dist/";
    private static final String ABSTRACT = "abstract";
    private static final String REQUIRES = "prereq_pm";
    private PerlMakefileParser perlMakefileParser;

    public PerlModel(IFile file) {
        try {
            this.perlMakefileParser = new PerlMakefileParser(file);
        }
        catch (IOException e) {
            StubbyLog.logError(e);
        }
        catch (CoreException e) {
            StubbyLog.logError(e);
        }
    }

    private String getValue(String key) {
        String rc = this.perlMakefileParser.getValue(key);
        if (rc.isEmpty()) {
            rc = FIX_ME;
        }
        return rc;
    }

    public List<String> getInstallRequires() {
        ArrayList<String> rc = new ArrayList<String>();
        List<String> temp = this.perlMakefileParser.getValueList(REQUIRES);
        String ver = "";
        if (!temp.isEmpty()) {
            for (String str : temp) {
                ver = str.substring(str.indexOf("=>") + 2, str.length());
                str = str.substring(0, str.indexOf("=>"));
                str = str.replaceAll("(\\S+)", "perl($1)");
                if (!ver.isEmpty() && this.hasDigits(ver)) {
                    str = str.concat(">= " + ver);
                }
                rc.add(str);
                ver = "";
            }
        }
        return rc;
    }

    public String getSimplePackageName() {
        String rc = "";
        rc = this.getValue("name");
        if (!rc.equals(FIX_ME)) {
            rc = rc.replaceAll("::", "-");
        }
        return rc;
    }

    public String getPackageName() {
        String simpleName = this.getSimplePackageName();
        if (simpleName.startsWith("perl-")) {
            return simpleName;
        }
        return "perl-" + simpleName;
    }

    public String getVersion() {
        String version = this.getValue("version");
        if (!this.hasDigits(version)) {
            version = "1 #FIXME";
        }
        return version;
    }

    public boolean hasDigits(String str) {
        return str.matches(".*\\d.*");
    }

    public String getSummary() {
        return this.getValue(ABSTRACT);
    }

    public String getLicense() {
        return LICENSE_REQ;
    }

    public String getURL() {
        return CPAN_URL + this.getSimplePackageName();
    }

    public String getDescription() {
        return this.getValue(ABSTRACT);
    }
}

