/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.componentcore.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jst.common.internal.modulecore.IClasspathDependencyComponent;
import org.eclipse.jst.common.internal.modulecore.IClasspathDependencyReceiver;
import org.eclipse.jst.common.jdt.internal.javalite.JavaCoreLite;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.classpathdep.IClasspathDependencyConstants;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualArchiveComponent;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.internal.common.J2EEDependencyListener;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathInitializer;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.builder.IDependencyGraph;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualComponent;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualFolder;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualReference;
import org.eclipse.wst.common.componentcore.internal.util.IComponentImplFactory;
import org.eclipse.wst.common.componentcore.internal.util.VirtualReferenceUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public class EARVirtualComponent
extends VirtualComponent
implements IComponentImplFactory,
IClasspathDependencyReceiver {
    public static String[] EXTENSIONS_TO_IGNORE = new String[]{".jar", ".zip", ".rar", ".war"};
    private IVirtualReference[] cachedReferences;
    private long depGraphModStamp;
    private long jeeModStamp;

    public EARVirtualComponent() {
    }

    public EARVirtualComponent(IProject aProject, IPath aRuntimePath) {
        super(aProject, aRuntimePath);
    }

    public IVirtualComponent createArchiveComponent(IProject aProject, String archiveLocation, IPath aRuntimePath) {
        return new J2EEModuleVirtualArchiveComponent(aProject, archiveLocation, aRuntimePath);
    }

    public IVirtualComponent createComponent(IProject aProject) {
        return new EARVirtualComponent(aProject, (IPath)new Path("/"));
    }

    public IVirtualFolder createFolder(IProject aProject, IPath aRuntimePath) {
        return new VirtualFolder(aProject, aRuntimePath);
    }

    protected boolean shouldCacheReferences() {
        return true;
    }

    private List<IVirtualReference> getHardReferences(IVirtualComponent earComponent) {
        IVirtualReference[] comparison = super.getReferences(new HashMap());
        ArrayList<IVirtualReference> refs2 = new ArrayList<IVirtualReference>();
        refs2.addAll(Arrays.asList(comparison));
        return refs2;
    }

    protected void customizeCreatedReference(IVirtualReference reference, Object referenceComponent) {
        if (referenceComponent instanceof ReferencedComponent) {
            if (((ReferencedComponent)referenceComponent).getArchiveName() != null) {
                reference.setArchiveName(((ReferencedComponent)referenceComponent).getArchiveName());
            } else {
                reference.setArchiveName(VirtualReferenceUtilities.INSTANCE.getDefaultArchiveName(reference));
            }
        } else {
            VirtualReferenceUtilities.INSTANCE.ensureReferencesHaveNames(new IVirtualReference[]{reference});
        }
    }

    private static List getLooseArchiveReferences(EARVirtualComponent earComponent, List hardReferences) {
        return EARVirtualComponent.getLooseArchiveReferences(earComponent, hardReferences, null, earComponent.getRootFolder());
    }

    private static List getLooseArchiveReferences(EARVirtualComponent earComponent, List hardReferences, List dynamicReferences, IVirtualFolder folder) {
        List list;
        Map<EARVirtualComponent, List> cache = J2EEComponentClasspathInitializer.getLooseConfigCache();
        if (cache != null && (list = cache.get((Object)earComponent)) != null) {
            return list;
        }
        list = EARVirtualComponent.getLooseArchiveReferences2(earComponent, hardReferences, null, folder);
        if (cache != null) {
            cache.put(earComponent, list);
        }
        return list;
    }

    private static List getLooseArchiveReferences2(EARVirtualComponent earComponent, List hardReferences, List dynamicReferences, IVirtualFolder folder) {
        ArrayList<IVirtualReference> innerDynamicReferences = dynamicReferences;
        try {
            IVirtualResource[] members = folder.members();
            int i = 0;
            while (i < members.length) {
                if (16 == members[i].getType()) {
                    if (EARVirtualComponent.isDynamicComponent((IVirtualFile)members[i])) {
                        Path archiveFullPath = new Path(members[i].getRuntimePath().toString());
                        boolean shouldInclude = true;
                        int j = 0;
                        while (j < hardReferences.size() && shouldInclude) {
                            IVirtualReference tmpRef = (IVirtualReference)hardReferences.get(j);
                            IPath tmpFullPath = tmpRef.getRuntimePath().append(tmpRef.getArchiveName());
                            if (tmpFullPath.equals((Object)archiveFullPath)) {
                                shouldInclude = false;
                            }
                            ++j;
                        }
                        if (shouldInclude) {
                            IResource iResource = members[i].getUnderlyingResource();
                            IVirtualComponent dynamicComponent = ComponentCore.createArchiveComponent((IProject)earComponent.getProject(), (String)("lib" + iResource.getFullPath().toString()));
                            IVirtualReference dynamicRef = ComponentCore.createReference((IVirtualComponent)earComponent, (IVirtualComponent)dynamicComponent);
                            ((VirtualReference)dynamicRef).setDerived(true);
                            dynamicRef.setArchiveName(archiveFullPath.lastSegment());
                            dynamicRef.setRuntimePath(archiveFullPath.removeLastSegments(1));
                            if (innerDynamicReferences == null) {
                                innerDynamicReferences = new ArrayList<IVirtualReference>();
                            }
                            innerDynamicReferences.add(dynamicRef);
                        }
                    }
                } else if (32 == members[i].getType()) {
                    innerDynamicReferences = EARVirtualComponent.getLooseArchiveReferences2(earComponent, hardReferences, innerDynamicReferences, (IVirtualFolder)members[i]);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            J2EEPlugin.logError(e);
        }
        return innerDynamicReferences;
    }

    public static boolean isDynamicComponent(IVirtualFile vFile) {
        String archiveName = vFile.getName();
        int j = 0;
        while (j < EXTENSIONS_TO_IGNORE.length) {
            if (J2EEComponentClasspathUpdater.endsWithIgnoreCase(archiveName, EXTENSIONS_TO_IGNORE[j])) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public IVirtualReference[] getReferences() {
        IVirtualReference[] cached = this.getCachedReferences();
        if (cached != null) {
            return cached;
        }
        List<IVirtualReference> hardReferences = this.getHardReferences((IVirtualComponent)this);
        List dynamicReferences = EARVirtualComponent.getLooseArchiveReferences(this, hardReferences);
        if (dynamicReferences != null) {
            hardReferences.addAll(dynamicReferences);
        }
        this.cachedReferences = hardReferences.toArray(new IVirtualReference[hardReferences.size()]);
        return this.cachedReferences;
    }

    public IVirtualReference[] getReferences(Map<String, Object> options) {
        boolean getExpandRefs;
        Object refType = options.get("REQUESTED_REFERENCE_TYPE");
        if (refType != null && ("NON_DERIVED_REFERENCES".equals(refType) || "HARD_REFERENCES".equals(refType) || "DISPLAYABLE_REFERENCES".equals(refType))) {
            List<IVirtualReference> hardReferences = this.getHardReferences((IVirtualComponent)this);
            return hardReferences.toArray(new IVirtualReference[hardReferences.size()]);
        }
        if (refType != null && "DISPLAYABLE_REFERENCES_ALL".equals(refType)) {
            this.checkIfStillValid();
            return this.getAllReferences();
        }
        IVirtualReference[] refs = this.getReferences();
        Boolean objGetExpandRefs = (Boolean)options.get(J2EEModuleVirtualComponent.GET_EXPANDED_LIB_REFS);
        boolean bl = getExpandRefs = objGetExpandRefs != null ? objGetExpandRefs : false;
        if (getExpandRefs) {
            return JavaEEProjectUtilities.getExpandedReferences((IVirtualComponent)this, refs);
        }
        return refs;
    }

    protected boolean shouldAddClasspathDependencyDerivedReference() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            try {
                Map<IClasspathEntry, IClasspathAttribute> results;
                if (projects[i].hasNature(JavaCoreLite.NATURE_ID) && ModuleCoreNature.isFlexibleProject((IProject)projects[i]) && !(results = ClasspathDependencyUtil.getRawComponentClasspathDependencies(JavaCoreLite.create((IProject)projects[i]), IClasspathDependencyConstants.DependencyAttributeType.CLASSPATH_COMPONENT_DEPENDENCY)).isEmpty()) {
                    return true;
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return false;
    }

    public IVirtualReference[] getCachedReferences() {
        if (this.cachedReferences != null && this.checkIfStillValid()) {
            return this.cachedReferences;
        }
        return null;
    }

    private boolean checkIfStillValid() {
        boolean valid = IDependencyGraph.INSTANCE.getModStamp() == this.depGraphModStamp;
        boolean bl = valid = valid && J2EEDependencyListener.INSTANCE.getModStamp() == this.jeeModStamp;
        if (!valid) {
            this.clearCache();
        }
        return valid;
    }

    protected void clearCache() {
        super.clearCache();
        this.depGraphModStamp = IDependencyGraph.INSTANCE.getModStamp();
        this.jeeModStamp = J2EEDependencyListener.INSTANCE.getModStamp();
        this.cachedReferences = null;
    }

    public boolean canReceiveClasspathDependencies() {
        return true;
    }

    public IPath getClasspathFolderPath(IClasspathDependencyComponent component) {
        return Path.EMPTY;
    }
}

