/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.internal.utility.JavaProjectTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementListIterable;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.AttributeOverride;
import org.eclipse.jpt.jpa.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.BaseColumn;
import org.eclipse.jpt.jpa.core.context.CollectionMapping;
import org.eclipse.jpt.jpa.core.context.Converter;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.NamedColumn;
import org.eclipse.jpt.jpa.core.context.Orderable;
import org.eclipse.jpt.jpa.core.context.OverrideContainer;
import org.eclipse.jpt.jpa.core.context.Override_;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.SpecifiedColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.SpecifiedRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.TableColumn;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.orm.OrmBaseEnumeratedConverter;
import org.eclipse.jpt.jpa.core.context.orm.OrmBaseTemporalConverter;
import org.eclipse.jpt.jpa.core.context.orm.OrmConverter;
import org.eclipse.jpt.jpa.core.context.orm.OrmMultiRelationshipMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmXmlContextModelFactory;
import org.eclipse.jpt.jpa.core.internal.context.AbstractJpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmRelationshipMapping;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AbstractNamedColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.EmbeddableOverrideDescriptionProvider;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.MapKeyAttributeOverrideColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.MapKeyAttributeOverrideValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.MapKeyColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.OverrideValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.RelationshipStrategyTableDescriptionProvider;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.orm.NullOrmConverter;
import org.eclipse.jpt.jpa.core.internal.jpa2.context.MapKeyJoinColumnValidator;
import org.eclipse.jpt.jpa.core.jpa2.context.MultiRelationshipMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.SpecifiedPersistentAttribute2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmOrderable2_0;
import org.eclipse.jpt.jpa.core.resource.orm.AbstractXmlMultiRelationshipMapping;
import org.eclipse.jpt.jpa.core.resource.orm.MapKey;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlAttributeOverride;
import org.eclipse.jpt.jpa.core.resource.orm.XmlClassReference;
import org.eclipse.jpt.jpa.core.resource.orm.XmlColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public abstract class AbstractOrmMultiRelationshipMapping<X extends AbstractXmlMultiRelationshipMapping>
extends AbstractOrmRelationshipMapping<X>
implements OrmMultiRelationshipMapping,
OrmCollectionMapping2_0,
MultiRelationshipMapping2_0 {
    protected final Orderable orderable;
    protected String specifiedMapKey;
    protected boolean noMapKey = false;
    protected boolean pkMapKey = false;
    protected boolean customMapKey = false;
    protected String specifiedMapKeyClass;
    protected String defaultMapKeyClass;
    protected String fullyQualifiedMapKeyClass;
    protected CollectionMapping.Type valueType;
    protected CollectionMapping.Type keyType;
    protected final OrmSpecifiedColumn mapKeyColumn;
    protected OrmConverter mapKeyConverter;
    protected final OrmAttributeOverrideContainer mapKeyAttributeOverrideContainer;
    protected final AbstractJpaContextModel.ContextListContainer<OrmSpecifiedJoinColumn, XmlJoinColumn> specifiedMapKeyJoinColumnContainer;
    protected final JoinColumn.ParentAdapter mapKeyJoinColumnParentAdapter;
    protected OrmSpecifiedJoinColumn defaultMapKeyJoinColumn;
    protected final OrmConverter nullConverter = new NullOrmConverter(this);
    protected static final OrmConverter.Adapter[] MAP_KEY_CONVERTER_ADAPTER_ARRAY = new OrmConverter.Adapter[]{OrmBaseEnumeratedConverter.MapKeyAdapter.instance(), OrmBaseTemporalConverter.MapKeyAdapter.instance()};
    protected static final Iterable<OrmConverter.Adapter> MAP_KEY_CONVERTER_ADAPTERS = IterableTools.iterable((Object[])MAP_KEY_CONVERTER_ADAPTER_ARRAY);

    protected AbstractOrmMultiRelationshipMapping(OrmSpecifiedPersistentAttribute parent, X xmlMapping) {
        super(parent, xmlMapping);
        this.orderable = this.buildOrderable();
        this.specifiedMapKey = this.buildSpecifiedMapKey();
        this.noMapKey = this.buildNoMapKey();
        this.pkMapKey = this.buildPkMapKey();
        this.customMapKey = this.buildCustomMapKey();
        this.specifiedMapKeyClass = this.buildSpecifiedMapKeyClass();
        this.mapKeyColumn = this.buildMapKeyColumn();
        this.mapKeyConverter = this.buildMapKeyConverter();
        this.mapKeyAttributeOverrideContainer = this.buildMapKeyAttributeOverrideContainer();
        this.mapKeyJoinColumnParentAdapter = this.buildMapKeyJoinColumnParentAdapter();
        this.specifiedMapKeyJoinColumnContainer = this.buildSpecifiedMapKeyJoinColumnContainer();
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.orderable.synchronizeWithResourceModel(monitor);
        this.setSpecifiedMapKey_(this.buildSpecifiedMapKey());
        this.setNoMapKey_(this.buildNoMapKey());
        this.setPkMapKey_(this.buildPkMapKey());
        this.setCustomMapKey_(this.buildCustomMapKey());
        this.setSpecifiedMapKeyClass_(this.buildSpecifiedMapKeyClass());
        this.mapKeyColumn.synchronizeWithResourceModel(monitor);
        this.syncMapKeyConverter(monitor);
        this.mapKeyAttributeOverrideContainer.synchronizeWithResourceModel(monitor);
        this.syncSpecifiedMapKeyJoinColumns(monitor);
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.orderable.update(monitor);
        this.setDefaultMapKeyClass(this.buildDefaultMapKeyClass());
        this.setFullyQualifiedMapKeyClass(this.buildFullyQualifiedMapKeyClass());
        this.setValueType(this.buildValueType());
        this.setKeyType(this.buildKeyType());
        this.mapKeyColumn.update(monitor);
        this.mapKeyConverter.update(monitor);
        this.mapKeyAttributeOverrideContainer.update(monitor);
        this.updateModels((Iterable<? extends JpaContextModel>)this.getSpecifiedMapKeyJoinColumns(), monitor);
        this.updateDefaultMapKeyJoinColumn(monitor);
    }

    @Override
    public Orderable getOrderable() {
        return this.orderable;
    }

    protected Orderable buildOrderable() {
        return this.isOrmXml2_0Compatible() ? this.getContextModelFactory2_0().buildOrmOrderable(this.buildOrderableParentAdapter()) : this.getContextModelFactory().buildOrmOrderable(this);
    }

    protected OrmOrderable2_0.ParentAdapter buildOrderableParentAdapter() {
        return new OrderableParentAdapter();
    }

    @Override
    public String getMapKey() {
        if (this.noMapKey) {
            return null;
        }
        if (this.pkMapKey) {
            return this.getTargetEntityIdAttributeName();
        }
        if (this.customMapKey) {
            return this.specifiedMapKey;
        }
        throw new IllegalStateException("unknown map key");
    }

    @Override
    public String getSpecifiedMapKey() {
        return this.specifiedMapKey;
    }

    @Override
    public void setSpecifiedMapKey(String mapKey) {
        if (mapKey != null) {
            this.setSpecifiedMapKey_(mapKey);
            this.setNoMapKey_(false);
            this.setPkMapKey_(false);
            this.setCustomMapKey_(true);
            MapKey xmlMapKey = this.getXmlMapKey();
            if (xmlMapKey == null) {
                xmlMapKey = this.buildXmlMapKey();
            }
            xmlMapKey.setName(mapKey);
        } else {
            this.setPkMapKey(true);
        }
    }

    protected void setSpecifiedMapKey_(String mapKey) {
        String old = this.specifiedMapKey;
        this.specifiedMapKey = mapKey;
        this.firePropertyChanged("specifiedMapKey", old, mapKey);
    }

    protected String buildSpecifiedMapKey() {
        MapKey xmlMapKey = this.getXmlMapKey();
        return xmlMapKey == null ? null : xmlMapKey.getName();
    }

    @Override
    public boolean isNoMapKey() {
        return this.noMapKey;
    }

    @Override
    public void setNoMapKey(boolean noMapKey) {
        if (noMapKey) {
            this.setSpecifiedMapKey_(null);
            this.setNoMapKey_(true);
            this.setPkMapKey_(false);
            this.setCustomMapKey_(false);
            if (this.getXmlMapKey() != null) {
                this.removeXmlMapKey();
            }
        } else {
            this.setPkMapKey(true);
        }
    }

    protected void setNoMapKey_(boolean noMapKey) {
        boolean old = this.noMapKey;
        this.noMapKey = noMapKey;
        this.firePropertyChanged("noMapKey", old, noMapKey);
    }

    protected boolean buildNoMapKey() {
        return this.getXmlMapKey() == null;
    }

    @Override
    public boolean isPkMapKey() {
        return this.pkMapKey;
    }

    @Override
    public void setPkMapKey(boolean pkMapKey) {
        if (pkMapKey) {
            this.setSpecifiedMapKey_(null);
            this.setNoMapKey_(false);
            this.setPkMapKey_(true);
            this.setCustomMapKey_(false);
            MapKey xmlMapKey = this.getXmlMapKey();
            if (xmlMapKey == null) {
                this.buildXmlMapKey();
            } else {
                xmlMapKey.setName(null);
            }
        } else {
            this.setNoMapKey(true);
        }
    }

    protected void setPkMapKey_(boolean pkMapKey) {
        boolean old = this.pkMapKey;
        this.pkMapKey = pkMapKey;
        this.firePropertyChanged("pkMapKey", old, pkMapKey);
    }

    protected boolean buildPkMapKey() {
        MapKey xmlMapKey = this.getXmlMapKey();
        return xmlMapKey != null && xmlMapKey.getName() == null;
    }

    @Override
    public boolean isCustomMapKey() {
        return this.customMapKey;
    }

    @Override
    public void setCustomMapKey(boolean customMapKey) {
        if (customMapKey) {
            this.setSpecifiedMapKey("");
        } else {
            this.setNoMapKey(true);
        }
    }

    protected void setCustomMapKey_(boolean customMapKey) {
        boolean old = this.customMapKey;
        this.customMapKey = customMapKey;
        this.firePropertyChanged("customMapKey", old, customMapKey);
    }

    protected boolean buildCustomMapKey() {
        MapKey xmlMapKey = this.getXmlMapKey();
        return xmlMapKey != null && xmlMapKey.getName() != null;
    }

    protected MapKey getXmlMapKey() {
        return ((AbstractXmlMultiRelationshipMapping)this.xmlAttributeMapping).getMapKey();
    }

    protected MapKey buildXmlMapKey() {
        MapKey mapKey = OrmFactory.eINSTANCE.createMapKey();
        ((AbstractXmlMultiRelationshipMapping)this.xmlAttributeMapping).setMapKey(mapKey);
        return mapKey;
    }

    protected void removeXmlMapKey() {
        ((AbstractXmlMultiRelationshipMapping)this.xmlAttributeMapping).setMapKey(null);
    }

    @Override
    public String getFullyQualifiedMapKeyClass() {
        return this.fullyQualifiedMapKeyClass;
    }

    protected void setFullyQualifiedMapKeyClass(String mapKeyClass) {
        String old = this.fullyQualifiedMapKeyClass;
        this.fullyQualifiedMapKeyClass = mapKeyClass;
        this.firePropertyChanged("fullyQualifiedMapKeyClass", old, mapKeyClass);
    }

    protected String buildFullyQualifiedMapKeyClass() {
        return this.specifiedMapKeyClass == null ? this.defaultMapKeyClass : this.getEntityMappings().qualify(this.specifiedMapKeyClass);
    }

    @Override
    public String getMapKeyClass() {
        return this.specifiedMapKeyClass != null ? this.specifiedMapKeyClass : this.defaultMapKeyClass;
    }

    @Override
    public String getSpecifiedMapKeyClass() {
        return this.specifiedMapKeyClass;
    }

    @Override
    public void setSpecifiedMapKeyClass(String mapKeyClass) {
        if (this.setSpecifiedMapKeyClass_(mapKeyClass)) {
            XmlClassReference xmlClassRef = ((AbstractXmlMultiRelationshipMapping)this.xmlAttributeMapping).getMapKeyClass();
            if (mapKeyClass == null) {
                if (xmlClassRef != null) {
                    ((AbstractXmlMultiRelationshipMapping)this.xmlAttributeMapping).setMapKeyClass(null);
                }
            } else {
                if (xmlClassRef == null) {
                    xmlClassRef = this.buildXmlMapKeyClassReference();
                }
                xmlClassRef.setClassName(mapKeyClass);
            }
        }
    }

    protected boolean setSpecifiedMapKeyClass_(String mapKeyClass) {
        String old = this.specifiedMapKeyClass;
        this.specifiedMapKeyClass = mapKeyClass;
        return this.firePropertyChanged("specifiedMapKeyClass", old, mapKeyClass);
    }

    protected XmlClassReference buildXmlMapKeyClassReference() {
        XmlClassReference mapKeyClass = OrmFactory.eINSTANCE.createXmlClassReference();
        ((AbstractXmlMultiRelationshipMapping)this.xmlAttributeMapping).setMapKeyClass(mapKeyClass);
        return mapKeyClass;
    }

    protected String buildSpecifiedMapKeyClass() {
        XmlClassReference xmlClassRef = ((AbstractXmlMultiRelationshipMapping)this.xmlAttributeMapping).getMapKeyClass();
        return xmlClassRef == null ? null : xmlClassRef.getClassName();
    }

    @Override
    public String getDefaultMapKeyClass() {
        return this.defaultMapKeyClass;
    }

    protected void setDefaultMapKeyClass(String mapKeyClass) {
        String old = this.defaultMapKeyClass;
        this.defaultMapKeyClass = mapKeyClass;
        this.firePropertyChanged("defaultMapKeyClass", old, mapKeyClass);
    }

    protected String buildDefaultMapKeyClass() {
        JavaSpecifiedPersistentAttribute javaAttribute = this.getJavaPersistentAttribute();
        return javaAttribute == null ? null : javaAttribute.getMultiReferenceMapKeyTypeName();
    }

    @Override
    public char getMapKeyClassEnclosingTypeSeparator() {
        return '$';
    }

    protected Embeddable getResolvedMapKeyEmbeddable() {
        TypeMapping typeMapping = this.getResolvedMapKeyTypeMapping();
        return typeMapping instanceof Embeddable ? (Embeddable)typeMapping : null;
    }

    protected Entity getResolvedMapKeyEntity() {
        TypeMapping typeMapping = this.getResolvedMapKeyTypeMapping();
        return typeMapping instanceof Entity ? (Entity)typeMapping : null;
    }

    protected TypeMapping getResolvedMapKeyTypeMapping() {
        PersistentType resolvedMapKeyType = this.getResolvedMapKeyType();
        return resolvedMapKeyType == null ? null : resolvedMapKeyType.getMapping();
    }

    protected PersistentType getResolvedMapKeyType() {
        if (this.fullyQualifiedMapKeyClass == null) {
            return null;
        }
        return this.getPersistenceUnit().getPersistentType(this.fullyQualifiedMapKeyClass);
    }

    @Override
    public CollectionMapping.Type getValueType() {
        return this.valueType;
    }

    protected void setValueType(CollectionMapping.Type valueType) {
        CollectionMapping.Type old = this.valueType;
        this.valueType = valueType;
        this.firePropertyChanged("valueType", (Object)old, (Object)valueType);
    }

    protected CollectionMapping.Type buildValueType() {
        if (this.getResolvedTargetEntity() != null) {
            return CollectionMapping.Type.ENTITY_TYPE;
        }
        if (this.getResolvedTargetEmbeddable() != null) {
            return CollectionMapping.Type.EMBEDDABLE_TYPE;
        }
        if (this.getTargetEntity() == null) {
            return CollectionMapping.Type.NO_TYPE;
        }
        return CollectionMapping.Type.BASIC_TYPE;
    }

    protected Embeddable getResolvedTargetEmbeddable() {
        TypeMapping typeMapping = this.getResolvedTargetTypeMapping();
        return typeMapping instanceof Embeddable ? (Embeddable)typeMapping : null;
    }

    @Override
    public CollectionMapping.Type getKeyType() {
        return this.keyType;
    }

    protected void setKeyType(CollectionMapping.Type keyType) {
        CollectionMapping.Type old = this.keyType;
        this.keyType = keyType;
        this.firePropertyChanged("keyType", (Object)old, (Object)keyType);
    }

    protected CollectionMapping.Type buildKeyType() {
        if (this.getResolvedMapKeyEmbeddable() != null) {
            return CollectionMapping.Type.EMBEDDABLE_TYPE;
        }
        if (this.getResolvedMapKeyEntity() != null) {
            return CollectionMapping.Type.ENTITY_TYPE;
        }
        if (this.getMapKeyClass() == null) {
            return CollectionMapping.Type.NO_TYPE;
        }
        return CollectionMapping.Type.BASIC_TYPE;
    }

    @Override
    public OrmSpecifiedColumn getMapKeyColumn() {
        return this.mapKeyColumn;
    }

    protected OrmSpecifiedColumn buildMapKeyColumn() {
        return this.getContextModelFactory().buildOrmColumn(this.buildMapKeyColumnParentAdapter());
    }

    protected OrmSpecifiedColumn.ParentAdapter buildMapKeyColumnParentAdapter() {
        return new MapKeyColumnParentAdapter();
    }

    protected XmlColumn getXmlMapKeyColumn() {
        return ((AbstractXmlMultiRelationshipMapping)this.xmlAttributeMapping).getMapKeyColumn();
    }

    protected XmlColumn buildXmlMapKeyColumn() {
        XmlColumn xmlColumn = OrmFactory.eINSTANCE.createXmlColumn();
        ((AbstractXmlMultiRelationshipMapping)this.xmlAttributeMapping).setMapKeyColumn(xmlColumn);
        return xmlColumn;
    }

    protected void removeXmlMapKeyColumn() {
        ((AbstractXmlMultiRelationshipMapping)this.xmlAttributeMapping).setMapKeyColumn(null);
    }

    @Override
    public OrmConverter getMapKeyConverter() {
        return this.mapKeyConverter;
    }

    @Override
    public void setMapKeyConverter(Class<? extends Converter> converterType) {
        if (this.mapKeyConverter.getConverterType() != converterType) {
            OrmConverter old = this.mapKeyConverter;
            this.mapKeyConverter = this.nullConverter;
            this.clearXmlMapKeyConverterValues();
            OrmConverter.Adapter converterAdapter = this.getMapKeyConverterAdapter(converterType);
            this.mapKeyConverter = this.buildMapKeyConverter(converterAdapter);
            this.mapKeyConverter.initialize();
            this.firePropertyChanged("mapKeyConverter", old, this.mapKeyConverter);
        }
    }

    protected OrmConverter buildMapKeyConverter(OrmConverter.Adapter converterAdapter) {
        return converterAdapter != null ? converterAdapter.buildNewConverter(this, this.getContextModelFactory()) : this.nullConverter;
    }

    protected void setMapKeyConverter_(OrmConverter converter) {
        OrmConverter old = this.mapKeyConverter;
        this.mapKeyConverter = converter;
        this.firePropertyChanged("mapKeyConverter", old, converter);
    }

    protected void clearXmlMapKeyConverterValues() {
        for (OrmConverter.Adapter adapter : this.getMapKeyConverterAdapters()) {
            adapter.clearXmlValue(this.xmlAttributeMapping);
        }
    }

    protected OrmConverter buildMapKeyConverter() {
        OrmXmlContextModelFactory factory = this.getContextModelFactory();
        for (OrmConverter.Adapter adapter : this.getMapKeyConverterAdapters()) {
            OrmConverter ormConverter = adapter.buildConverter(this, factory);
            if (ormConverter == null) continue;
            return ormConverter;
        }
        return this.nullConverter;
    }

    protected void syncMapKeyConverter(IProgressMonitor monitor) {
        OrmConverter.Adapter adapter = this.getXmlMapKeyConverterAdapter();
        if (adapter == null) {
            if (this.mapKeyConverter.getConverterType() != null) {
                this.setMapKeyConverter_(this.nullConverter);
            }
        } else if (this.mapKeyConverter.getConverterType() == adapter.getConverterType()) {
            this.mapKeyConverter.synchronizeWithResourceModel(monitor);
        } else {
            this.setMapKeyConverter_(adapter.buildNewConverter(this, this.getContextModelFactory()));
        }
    }

    protected OrmConverter.Adapter getXmlMapKeyConverterAdapter() {
        for (OrmConverter.Adapter adapter : this.getMapKeyConverterAdapters()) {
            if (!adapter.isActive(this.xmlAttributeMapping)) continue;
            return adapter;
        }
        return null;
    }

    protected OrmConverter.Adapter getMapKeyConverterAdapter(Class<? extends Converter> converterType) {
        for (OrmConverter.Adapter adapter : this.getMapKeyConverterAdapters()) {
            if (adapter.getConverterType() != converterType) continue;
            return adapter;
        }
        return null;
    }

    protected Iterable<OrmConverter.Adapter> getMapKeyConverterAdapters() {
        return MAP_KEY_CONVERTER_ADAPTERS;
    }

    @Override
    public OrmAttributeOverrideContainer getMapKeyAttributeOverrideContainer() {
        return this.mapKeyAttributeOverrideContainer;
    }

    protected OrmAttributeOverrideContainer buildMapKeyAttributeOverrideContainer() {
        return this.getContextModelFactory().buildOrmAttributeOverrideContainer(this.buildMapKeyAttributeOverrideContainerParentAdapter());
    }

    protected OrmAttributeOverrideContainer.ParentAdapter buildMapKeyAttributeOverrideContainerParentAdapter() {
        return new MapKeyAttributeOverrideContainerParentAdapter();
    }

    protected JavaSpecifiedAttributeOverride getSpecifiedJavaMapKeyAttributeOverrideNamed(String attributeName) {
        JavaCollectionMapping2_0 javaCollectionMapping = this.getJavaCollectionMapping();
        return javaCollectionMapping == null ? null : javaCollectionMapping.getMapKeyAttributeOverrideContainer().getSpecifiedOverrideNamed(attributeName);
    }

    protected JavaCollectionMapping2_0 getJavaCollectionMapping() {
        AttributeMapping javaAttributeMapping = this.getJavaAttributeMapping();
        return javaAttributeMapping.getKey() == this.getKey() ? (JavaCollectionMapping2_0)javaAttributeMapping : null;
    }

    protected AttributeMapping getJavaAttributeMapping() {
        JavaSpecifiedPersistentAttribute javaAttribute = this.getJavaPersistentAttribute();
        return javaAttribute == null ? null : javaAttribute.getMapping();
    }

    public ListIterable<OrmSpecifiedJoinColumn> getMapKeyJoinColumns() {
        return this.hasSpecifiedMapKeyJoinColumns() ? this.getSpecifiedMapKeyJoinColumns() : this.getDefaultMapKeyJoinColumns();
    }

    @Override
    public int getMapKeyJoinColumnsSize() {
        return this.hasSpecifiedMapKeyJoinColumns() ? this.getSpecifiedMapKeyJoinColumnsSize() : this.getDefaultMapKeyJoinColumnsSize();
    }

    public ListIterable<OrmSpecifiedJoinColumn> getSpecifiedMapKeyJoinColumns() {
        return this.specifiedMapKeyJoinColumnContainer;
    }

    @Override
    public int getSpecifiedMapKeyJoinColumnsSize() {
        return this.specifiedMapKeyJoinColumnContainer.size();
    }

    @Override
    public boolean hasSpecifiedMapKeyJoinColumns() {
        return this.getSpecifiedMapKeyJoinColumnsSize() != 0;
    }

    @Override
    public OrmSpecifiedJoinColumn getSpecifiedMapKeyJoinColumn(int index) {
        return (OrmSpecifiedJoinColumn)this.specifiedMapKeyJoinColumnContainer.get(index);
    }

    @Override
    public OrmSpecifiedJoinColumn addSpecifiedMapKeyJoinColumn() {
        return this.addSpecifiedMapKeyJoinColumn(this.getSpecifiedMapKeyJoinColumnsSize());
    }

    @Override
    public OrmSpecifiedJoinColumn addSpecifiedMapKeyJoinColumn(int index) {
        XmlJoinColumn xmlJoinColumn = this.buildXmlJoinColumn();
        OrmSpecifiedJoinColumn joinColumn = (OrmSpecifiedJoinColumn)this.specifiedMapKeyJoinColumnContainer.addContextElement(index, xmlJoinColumn);
        ((AbstractXmlMultiRelationshipMapping)this.getXmlAttributeMapping()).getMapKeyJoinColumns().add(index, (Object)xmlJoinColumn);
        return joinColumn;
    }

    protected XmlJoinColumn buildXmlJoinColumn() {
        return OrmFactory.eINSTANCE.createXmlJoinColumn();
    }

    @Override
    public void removeSpecifiedMapKeyJoinColumn(SpecifiedJoinColumn joinColumn) {
        this.removeSpecifiedMapKeyJoinColumn(this.specifiedMapKeyJoinColumnContainer.indexOf((OrmSpecifiedJoinColumn)joinColumn));
    }

    @Override
    public void removeSpecifiedMapKeyJoinColumn(int index) {
        this.specifiedMapKeyJoinColumnContainer.remove(index);
        ((AbstractXmlMultiRelationshipMapping)this.getXmlAttributeMapping()).getMapKeyJoinColumns().remove(index);
    }

    @Override
    public void moveSpecifiedMapKeyJoinColumn(int targetIndex, int sourceIndex) {
        this.specifiedMapKeyJoinColumnContainer.move(targetIndex, sourceIndex);
        ((AbstractXmlMultiRelationshipMapping)this.getXmlAttributeMapping()).getMapKeyJoinColumns().move(targetIndex, sourceIndex);
    }

    protected void syncSpecifiedMapKeyJoinColumns(IProgressMonitor monitor) {
        this.specifiedMapKeyJoinColumnContainer.synchronizeWithResourceModel(monitor);
    }

    protected ListIterable<XmlJoinColumn> getXmlMapKeyJoinColumns() {
        return IterableTools.cloneLive(((AbstractXmlMultiRelationshipMapping)this.getXmlAttributeMapping()).getMapKeyJoinColumns());
    }

    protected AbstractJpaContextModel.ContextListContainer<OrmSpecifiedJoinColumn, XmlJoinColumn> buildSpecifiedMapKeyJoinColumnContainer() {
        return this.buildSpecifiedContextListContainer("specifiedMapKeyJoinColumns", new SpecifiedMapKeyJoinColumnContainerAdapter());
    }

    protected OrmSpecifiedJoinColumn buildMapKeyJoinColumn(XmlJoinColumn xmlJoinColumn) {
        return this.getContextModelFactory().buildOrmJoinColumn(this.mapKeyJoinColumnParentAdapter, xmlJoinColumn);
    }

    protected JoinColumn.ParentAdapter buildMapKeyJoinColumnParentAdapter() {
        return new MapKeyJoinColumnParentAdapter();
    }

    @Override
    public OrmSpecifiedJoinColumn getDefaultMapKeyJoinColumn() {
        return this.defaultMapKeyJoinColumn;
    }

    protected void setDefaultMapKeyJoinColumn(OrmSpecifiedJoinColumn mapKeyJoinColumn) {
        OrmSpecifiedJoinColumn old = this.defaultMapKeyJoinColumn;
        this.defaultMapKeyJoinColumn = mapKeyJoinColumn;
        this.firePropertyChanged("defaultMapKeyJoinColumn", old, mapKeyJoinColumn);
    }

    protected ListIterable<OrmSpecifiedJoinColumn> getDefaultMapKeyJoinColumns() {
        return this.defaultMapKeyJoinColumn != null ? new SingleElementListIterable((Object)this.defaultMapKeyJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultMapKeyJoinColumnsSize() {
        return this.defaultMapKeyJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultMapKeyJoinColumn(IProgressMonitor monitor) {
        if (this.buildsDefaultMapKeyJoinColumn()) {
            if (this.defaultMapKeyJoinColumn == null) {
                this.setDefaultMapKeyJoinColumn(this.buildMapKeyJoinColumn(null));
            } else {
                this.defaultMapKeyJoinColumn.update(monitor);
            }
        } else {
            this.setDefaultMapKeyJoinColumn(null);
        }
    }

    protected boolean buildsDefaultMapKeyJoinColumn() {
        return !this.hasSpecifiedMapKeyJoinColumns() && this.getKeyType() == CollectionMapping.Type.ENTITY_TYPE;
    }

    @Override
    protected String getJavaTargetType() {
        return this.getJavaPersistentAttribute().getMultiReferenceTargetTypeName();
    }

    @Override
    protected FetchType buildDefaultFetch() {
        return DEFAULT_FETCH_TYPE;
    }

    @Override
    public Iterable<String> getCandidateMapKeyNames() {
        return this.getTargetEntityNonTransientAttributeNames();
    }

    protected Iterable<String> getCandidateMapKeyClassNames() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{JavaProjectTools.getJavaClassNames((IJavaProject)this.getJavaProject()), MappingTools.getPrimaryBasicTypeNames()});
    }

    @Override
    protected String getMetamodelFieldTypeName() {
        return ((SpecifiedPersistentAttribute2_0)((Object)this.getPersistentAttribute())).getMetamodelContainerFieldTypeName();
    }

    @Override
    protected void addMetamodelFieldTypeArgumentNamesTo(ArrayList<String> typeArgumentNames) {
        this.addMetamodelFieldMapKeyTypeArgumentNameTo(typeArgumentNames);
        super.addMetamodelFieldTypeArgumentNamesTo(typeArgumentNames);
    }

    protected void addMetamodelFieldMapKeyTypeArgumentNameTo(ArrayList<String> typeArgumentNames) {
        String keyTypeName = ((SpecifiedPersistentAttribute2_0)((Object)this.getPersistentAttribute())).getMetamodelContainerFieldMapKeyTypeName();
        if (keyTypeName != null) {
            typeArgumentNames.add(keyTypeName);
        }
    }

    @Override
    public String getMetamodelFieldMapKeyTypeName() {
        return MappingTools.getMetamodelFieldMapKeyTypeName(this);
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{super.createRenameTypeEdits(originalType, newName), this.createMapKeyClassRenameTypeEdits(originalType, newName)});
    }

    protected Iterable<ReplaceEdit> createMapKeyClassRenameTypeEdits(IType originalType, String newName) {
        PersistentType mapKeyType;
        if (this.specifiedMapKeyClass != null && (mapKeyType = this.getResolvedMapKeyType()) != null && mapKeyType.isFor(originalType.getFullyQualifiedName('.'))) {
            return new SingleElementIterable((Object)this.createMapKeyClassRenameTypeEdit(originalType, newName));
        }
        return EmptyIterable.instance();
    }

    protected ReplaceEdit createMapKeyClassRenameTypeEdit(IType originalType, String newName) {
        return ((AbstractXmlMultiRelationshipMapping)this.xmlAttributeMapping).createRenameMapKeyClassEdit(originalType, newName);
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{super.createMoveTypeEdits(originalType, newPackage), this.createMapKeyClassMoveTypeEdits(originalType, newPackage)});
    }

    protected Iterable<ReplaceEdit> createMapKeyClassMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        PersistentType mapKeyType;
        if (this.specifiedMapKeyClass != null && (mapKeyType = this.getResolvedMapKeyType()) != null && mapKeyType.isFor(originalType.getFullyQualifiedName('.'))) {
            return new SingleElementIterable((Object)this.createMapKeyClassRenamePackageEdit(newPackage.getElementName()));
        }
        return EmptyIterable.instance();
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{super.createRenamePackageEdits(originalPackage, newName), this.createMapKeyClassRenamePackageEdits(originalPackage, newName)});
    }

    protected Iterable<ReplaceEdit> createMapKeyClassRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        PersistentType mapKeyType;
        if (this.specifiedMapKeyClass != null && (mapKeyType = this.getResolvedMapKeyType()) != null && mapKeyType.isIn(originalPackage)) {
            return new SingleElementIterable((Object)this.createMapKeyClassRenamePackageEdit(newName));
        }
        return EmptyIterable.instance();
    }

    protected ReplaceEdit createMapKeyClassRenamePackageEdit(String newName) {
        return ((AbstractXmlMultiRelationshipMapping)this.xmlAttributeMapping).createRenameMapKeyClassPackageEdit(newName);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateAttributeType(messages, reporter);
        this.orderable.validate(messages, reporter);
        this.validateMapKeyClass(messages);
        this.validateMapKey(messages, reporter);
    }

    protected void validateAttributeType(List<IMessage> messages, IReporter reporter) {
        JavaSpecifiedPersistentAttribute javaAttribute = this.getJavaPersistentAttribute();
        if (javaAttribute != null && !javaAttribute.getJpaContainerDefinition().isContainer()) {
            messages.add(this.buildValidationMessage(this.getAttributeTypeTextRange(), JptJpaCoreValidationMessages.ATTRIBUTE_TYPE_IS_NOT_SUPPORTED_COLLECTION_TYPE, this.getFullyQualifiedAttributeType()));
        }
    }

    protected TextRange getAttributeTypeTextRange() {
        return this.getValidationTextRange();
    }

    public void validateMapKey(List<IMessage> messages, IReporter reporter) {
        if (this.getMapKey() != null) {
            return;
        }
        if (this.keyType == CollectionMapping.Type.BASIC_TYPE) {
            this.mapKeyColumn.validate(messages, reporter);
            this.mapKeyConverter.validate(messages, reporter);
        } else if (this.keyType == CollectionMapping.Type.ENTITY_TYPE) {
            for (OrmSpecifiedJoinColumn joinColumn : this.getMapKeyJoinColumns()) {
                joinColumn.validate(messages, reporter);
            }
        } else if (this.keyType == CollectionMapping.Type.EMBEDDABLE_TYPE) {
            this.mapKeyAttributeOverrideContainer.validate(messages, reporter);
        }
    }

    protected void validateMapKeyClass(List<IMessage> messages) {
        JavaSpecifiedPersistentAttribute javaAttribute;
        if (this.isJpa2_0Compatible() && (javaAttribute = this.getJavaPersistentAttribute()) != null && javaAttribute.getJpaContainerDefinition().isMap()) {
            this.validateMapKeyClass_(messages);
        }
    }

    protected void validateMapKeyClass_(List<IMessage> messages) {
        if (StringTools.isBlank((String)this.getMapKeyClass())) {
            messages.add(this.buildValidationMessage(this.getMapKeyClassTextRange(), JptJpaCoreValidationMessages.MAP_KEY_CLASS_NOT_DEFINED));
            return;
        }
        if (MappingTools.typeIsBasic(this.getJavaProject(), this.getFullyQualifiedMapKeyClass())) {
            return;
        }
        if (this.getResolvedMapKeyType() == null) {
            IType mapKeyJdtType = JavaProjectTools.findType((IJavaProject)this.getJavaProject(), (String)this.getFullyQualifiedMapKeyClass());
            if (mapKeyJdtType == null) {
                messages.add(this.buildValidationMessage(this.getMapKeyClassTextRange(), JptJpaCoreValidationMessages.MAP_KEY_CLASS_NOT_EXIST, this.getFullyQualifiedMapKeyClass()));
            }
            return;
        }
        if (this.getResolvedMapKeyEmbeddable() == null && this.getResolvedMapKeyEntity() == null) {
            messages.add(this.buildValidationMessage(this.getMapKeyClassTextRange(), JptJpaCoreValidationMessages.MAP_KEY_CLASS_MUST_BE_ENTITY_EMBEDDABLE_OR_BASIC_TYPE, this.getFullyQualifiedMapKeyClass()));
        }
    }

    protected TextRange getMapKeyClassTextRange() {
        return this.getValidationTextRange(((AbstractXmlMultiRelationshipMapping)this.xmlAttributeMapping).getMapKeyClassTextRange());
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.orderable.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.mapKeyNameTouches(pos)) {
            return this.getCandidateMapKeyNames();
        }
        if (this.mapKeyClassTouches(pos)) {
            return this.getCandidateMapKeyClassNames();
        }
        result = this.mapKeyColumn.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.mapKeyConverter.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.mapKeyAttributeOverrideContainer.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        for (OrmSpecifiedJoinColumn joinColumn : this.getMapKeyJoinColumns()) {
            result = joinColumn.getCompletionProposals(pos);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected boolean mapKeyNameTouches(int pos) {
        return this.getXmlMapKey() == null ? false : this.getXmlMapKey().mapKeyNameTouches(pos);
    }

    protected boolean mapKeyClassTouches(int pos) {
        return ((AbstractXmlMultiRelationshipMapping)this.xmlAttributeMapping).getMapKeyClass() == null ? false : ((AbstractXmlMultiRelationshipMapping)this.xmlAttributeMapping).getMapKeyClass().classNameTouches(pos);
    }

    public class AbstractParentAdapter {
        public OrmTypeMapping getTypeMapping() {
            return AbstractOrmMultiRelationshipMapping.this.getTypeMapping();
        }

        public String getDefaultTableName() {
            return this.getRelationshipStrategy().getTableName();
        }

        public Table resolveDbTable(String tableName) {
            return this.getRelationshipStrategy().resolveDbTable(tableName);
        }

        public Iterable<String> getCandidateTableNames() {
            return EmptyIterable.instance();
        }

        public TextRange getValidationTextRange() {
            return AbstractOrmMultiRelationshipMapping.this.getValidationTextRange();
        }

        protected SpecifiedRelationshipStrategy getRelationshipStrategy() {
            return AbstractOrmMultiRelationshipMapping.this.getRelationship().getStrategy();
        }

        protected OrmSpecifiedPersistentAttribute getPersistentAttribute() {
            return AbstractOrmMultiRelationshipMapping.this.getPersistentAttribute();
        }
    }

    public class MapKeyAttributeOverrideContainerParentAdapter
    extends AbstractParentAdapter
    implements OrmAttributeOverrideContainer.ParentAdapter {
        @Override
        public JpaContextModel getOverrideContainerParent() {
            return AbstractOrmMultiRelationshipMapping.this;
        }

        @Override
        public TypeMapping getOverridableTypeMapping() {
            return AbstractOrmMultiRelationshipMapping.this.getResolvedMapKeyEmbeddable();
        }

        @Override
        public Iterable<String> getAllOverridableNames() {
            TypeMapping overriddenTypeMapping = this.getOverridableTypeMapping();
            return overriddenTypeMapping != null ? overriddenTypeMapping.getAllOverridableAttributeNames() : EmptyIterable.instance();
        }

        protected JavaSpecifiedAttributeOverride getSpecifiedJavaAttributeOverrideNamed(String attributeName) {
            return AbstractOrmMultiRelationshipMapping.this.getSpecifiedJavaMapKeyAttributeOverrideNamed(attributeName);
        }

        @Override
        public Iterable<String> getJavaOverrideNames() {
            return null;
        }

        @Override
        public EList<XmlAttributeOverride> getXmlOverrides() {
            return ((AbstractXmlMultiRelationshipMapping)AbstractOrmMultiRelationshipMapping.this.xmlAttributeMapping).getMapKeyAttributeOverrides();
        }

        @Override
        public SpecifiedColumn resolveOverriddenColumn(String attributeName) {
            return MappingTools.resolveOverriddenColumn(this.getOverridableTypeMapping(), attributeName);
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return ObjectTools.notEquals((Object)this.getDefaultTableName(), (Object)tableName);
        }

        @Override
        public JpaValidator buildOverrideValidator(Override_ override, OverrideContainer container) {
            return new MapKeyAttributeOverrideValidator((PersistentAttribute)this.getPersistentAttribute(), (AttributeOverride)override, (AttributeOverrideContainer)container, (OverrideValidator.OverrideDescriptionProvider)new EmbeddableOverrideDescriptionProvider());
        }

        @Override
        public JpaValidator buildColumnValidator(Override_ override, BaseColumn column, TableColumn.ParentAdapter parentAdapter) {
            return new MapKeyAttributeOverrideColumnValidator(this.getPersistentAttribute(), (AttributeOverride)override, column, new RelationshipStrategyTableDescriptionProvider(this.getRelationshipStrategy()));
        }
    }

    public class MapKeyColumnParentAdapter
    extends AbstractParentAdapter
    implements OrmSpecifiedColumn.ParentAdapter {
        @Override
        public JpaContextModel getColumnParent() {
            return AbstractOrmMultiRelationshipMapping.this;
        }

        @Override
        public String getDefaultColumnName(NamedColumn column) {
            return String.valueOf(AbstractOrmMultiRelationshipMapping.this.getName()) + "_KEY";
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return this.getRelationshipStrategy().tableNameIsInvalid(tableName);
        }

        @Override
        public XmlColumn getXmlColumn() {
            return AbstractOrmMultiRelationshipMapping.this.getXmlMapKeyColumn();
        }

        @Override
        public XmlColumn buildXmlColumn() {
            return AbstractOrmMultiRelationshipMapping.this.buildXmlMapKeyColumn();
        }

        @Override
        public void removeXmlColumn() {
            AbstractOrmMultiRelationshipMapping.this.removeXmlMapKeyColumn();
        }

        @Override
        public JpaValidator buildColumnValidator(NamedColumn column) {
            return new MapKeyColumnValidator((PersistentAttribute)this.getPersistentAttribute(), (BaseColumn)column, (AbstractNamedColumnValidator.TableDescriptionProvider)new RelationshipStrategyTableDescriptionProvider(this.getRelationshipStrategy()));
        }
    }

    public class MapKeyJoinColumnParentAdapter
    implements JoinColumn.ParentAdapter {
        @Override
        public JpaContextModel getColumnParent() {
            return AbstractOrmMultiRelationshipMapping.this;
        }

        @Override
        public String getDefaultTableName() {
            return AbstractOrmMultiRelationshipMapping.this.getRelationship().getStrategy().getTableName();
        }

        @Override
        public String getDefaultColumnName(NamedColumn column) {
            return String.valueOf(AbstractOrmMultiRelationshipMapping.this.getName()) + "_KEY";
        }

        @Override
        public String getAttributeName() {
            return AbstractOrmMultiRelationshipMapping.this.getName();
        }

        protected SpecifiedPersistentAttribute getPersistentAttribute() {
            return AbstractOrmMultiRelationshipMapping.this.getPersistentAttribute();
        }

        @Override
        public Entity getRelationshipTarget() {
            return AbstractOrmMultiRelationshipMapping.this.getResolvedMapKeyEntity();
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return AbstractOrmMultiRelationshipMapping.this.getRelationship().getStrategy().tableNameIsInvalid(tableName);
        }

        @Override
        public Iterable<String> getCandidateTableNames() {
            return AbstractOrmMultiRelationshipMapping.this.getTypeMapping().getAllAssociatedTableNames();
        }

        @Override
        public Table resolveDbTable(String tableName) {
            return AbstractOrmMultiRelationshipMapping.this.getRelationship().getStrategy().resolveDbTable(tableName);
        }

        @Override
        public Table getReferencedColumnDbTable() {
            Entity entity = AbstractOrmMultiRelationshipMapping.this.getResolvedMapKeyEntity();
            return entity != null ? entity.getPrimaryDbTable() : null;
        }

        @Override
        public int getJoinColumnsSize() {
            return AbstractOrmMultiRelationshipMapping.this.getMapKeyJoinColumnsSize();
        }

        @Override
        public TextRange getValidationTextRange() {
            return AbstractOrmMultiRelationshipMapping.this.getValidationTextRange();
        }

        @Override
        public JpaValidator buildColumnValidator(NamedColumn column) {
            return new MapKeyJoinColumnValidator((PersistentAttribute)this.getPersistentAttribute(), (JoinColumn)column, this, (AbstractNamedColumnValidator.TableDescriptionProvider)new RelationshipStrategyTableDescriptionProvider(AbstractOrmMultiRelationshipMapping.this.getRelationship().getStrategy()));
        }
    }

    public class OrderableParentAdapter
    implements OrmOrderable2_0.ParentAdapter {
        @Override
        public OrmAttributeMapping getOrderableParent() {
            return AbstractOrmMultiRelationshipMapping.this;
        }

        @Override
        public String getTableName() {
            return this.getRelationshipStrategy().getTableName();
        }

        @Override
        public Table resolveDbTable(String tableName) {
            return this.getRelationshipStrategy().resolveDbTable(tableName);
        }

        protected SpecifiedRelationshipStrategy getRelationshipStrategy() {
            return AbstractOrmMultiRelationshipMapping.this.getRelationship().getStrategy();
        }
    }

    public class SpecifiedMapKeyJoinColumnContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<OrmSpecifiedJoinColumn, XmlJoinColumn> {
        @Override
        public OrmSpecifiedJoinColumn buildContextElement(XmlJoinColumn resourceElement) {
            return AbstractOrmMultiRelationshipMapping.this.buildMapKeyJoinColumn(resourceElement);
        }

        @Override
        public ListIterable<XmlJoinColumn> getResourceElements() {
            return AbstractOrmMultiRelationshipMapping.this.getXmlMapKeyJoinColumns();
        }

        @Override
        public XmlJoinColumn extractResourceElement(OrmSpecifiedJoinColumn contextElement) {
            return contextElement.getXmlColumn();
        }
    }
}

