/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EXmlAccessOrder implements Enumerator
{
    ALPHABETICAL(0, "ALPHABETICAL", "ALPHABETICAL"),
    UNDEFINED(1, "UNDEFINED", "UNDEFINED");

    public static final int ALPHABETICAL_VALUE = 0;
    public static final int UNDEFINED_VALUE = 1;
    private static final EXmlAccessOrder[] VALUES_ARRAY;
    public static final List<EXmlAccessOrder> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EXmlAccessOrder[]{ALPHABETICAL, UNDEFINED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EXmlAccessOrder get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EXmlAccessOrder result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EXmlAccessOrder getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EXmlAccessOrder result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EXmlAccessOrder get(int value) {
        switch (value) {
            case 0: {
                return ALPHABETICAL;
            }
            case 1: {
                return UNDEFINED;
            }
        }
        return null;
    }

    private EXmlAccessOrder(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

