/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.jaxb.core.JaxbNode;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.jpt.jaxb.eclipselink.core.context.ELClassMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.context.ELXmlJoinNode;
import org.eclipse.jpt.jaxb.eclipselink.core.context.ELXmlJoinNodesMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.xpath.java.XPath;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.xpath.java.XPathFactory;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlJoinNodeAnnotation;
import org.eclipse.jpt.jaxb.eclipselink.core.validation.JptJaxbEclipseLinkCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class ELJavaXmlJoinNode
extends AbstractJavaContextNode
implements ELXmlJoinNode {
    protected String xmlPath;
    protected String referencedXmlPath;
    protected Context context;

    public ELJavaXmlJoinNode(JaxbContextNode parent, Context context) {
        super((JaxbNode)parent);
        this.context = context;
        this.initXmlPath();
        this.initReferencedXmlPath();
    }

    protected JaxbPackage getJaxbPackage() {
        return this.getClassMapping().getJaxbPackage();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncXmlPath();
        this.syncReferencedXmlPath();
    }

    @Override
    public String getXmlPath() {
        return this.xmlPath;
    }

    @Override
    public void setXmlPath(String xmlPath) {
        this.getAnnotation().setXmlPath(xmlPath);
        this.setXmlPath_(xmlPath);
    }

    protected void setXmlPath_(String xmlPath) {
        String old = this.xmlPath;
        this.xmlPath = xmlPath;
        this.firePropertyChanged("xmlPath", old, this.xmlPath);
    }

    protected void initXmlPath() {
        this.xmlPath = this.getAnnotation().getXmlPath();
    }

    protected void syncXmlPath() {
        this.setXmlPath_(this.getAnnotation().getXmlPath());
    }

    @Override
    public String getReferencedXmlPath() {
        return this.referencedXmlPath;
    }

    @Override
    public void setReferencedXmlPath(String referencedXmlPath) {
        this.getAnnotation().setReferencedXmlPath(referencedXmlPath);
        this.setReferencedXmlPath_(referencedXmlPath);
    }

    protected void setReferencedXmlPath_(String referencedXmlPath) {
        String old = this.referencedXmlPath;
        this.referencedXmlPath = referencedXmlPath;
        this.firePropertyChanged("referencedXmlPath", old, this.referencedXmlPath);
    }

    protected void initReferencedXmlPath() {
        this.referencedXmlPath = this.getAnnotation().getReferencedXmlPath();
    }

    protected void syncReferencedXmlPath() {
        this.setReferencedXmlPath_(this.getAnnotation().getReferencedXmlPath());
    }

    protected XmlJoinNodeAnnotation getAnnotation() {
        return this.context.getAnnotation();
    }

    protected ELXmlJoinNodesMapping getAttributeMapping() {
        return this.context.getAttributeMapping();
    }

    protected JaxbClassMapping getClassMapping() {
        return this.getAttributeMapping().getClassMapping();
    }

    public Iterable<String> getCompletionProposals(int pos) {
        if (this.getAnnotation().xmlPathTouches(pos) && this.xmlPath != null) {
            XsdTypeDefinition xsdType = this.getClassMapping().getXsdTypeDefinition();
            XPath xpath = XPathFactory.instance().getXpath(this.xmlPath);
            return xpath.getCompletionProposals(new XmlPathContext(), xsdType, pos);
        }
        if (this.getAnnotation().referencedXmlPathTouches(pos) && this.referencedXmlPath != null) {
            XsdTypeDefinition xsdType = this.getAttributeMapping().getReferencedXsdTypeDefinition();
            XPath xpath = XPathFactory.instance().getXpath(this.referencedXmlPath);
            Iterable result = xpath.getCompletionProposals(new ReferencedXmlPathContext(), xsdType, pos);
            ELClassMapping referencedClassMapping = this.context.getAttributeMapping().getReferencedClassMapping();
            if (referencedClassMapping != null) {
                result = IterableTools.concatenate((Iterable[])new Iterable[]{result, new TransformationIterable(referencedClassMapping.getKeyXPaths(), StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER)});
            }
            return CollectionTools.treeSet(result);
        }
        return EmptyIterable.instance();
    }

    public TextRange getValidationTextRange() {
        return this.getAnnotation().getTextRange();
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateXmlPath(messages);
        this.validateReferencedXmlPath(messages);
    }

    protected void validateXmlPath(List<IMessage> messages) {
        if (StringTools.isBlank((String)this.xmlPath)) {
            messages.add(this.buildValidationMessage((JaxbNode)this, this.getXmlPathTextRange(), JptJaxbEclipseLinkCoreValidationMessages.XML_JOIN_NODE__XML_PATH_NOT_SPECIFIED));
            return;
        }
        if (this.xmlPath.startsWith(XPath.DELIM)) {
            messages.add(this.buildValidationMessage((JaxbNode)this, this.getXmlPathTextRange(), JptJaxbEclipseLinkCoreValidationMessages.XPATH__ROOT_NOT_SUPPORTED));
            return;
        }
        XsdTypeDefinition xsdType = this.getClassMapping().getXsdTypeDefinition();
        XPath xpath = XPathFactory.instance().getXpath(this.xmlPath);
        xpath.validate(new XmlPathContext(), xsdType, messages);
    }

    protected void validateReferencedXmlPath(List<IMessage> messages) {
        if (StringTools.isBlank((String)this.referencedXmlPath)) {
            messages.add(this.buildValidationMessage((JaxbNode)this, this.getReferencedXmlPathTextRange(), JptJaxbEclipseLinkCoreValidationMessages.XML_JOIN_NODE__REFERENCED_XML_PATH_NOT_SPECIFIED));
            return;
        }
        if (this.referencedXmlPath.startsWith(XPath.DELIM)) {
            messages.add(this.buildValidationMessage((JaxbNode)this, this.getReferencedXmlPathTextRange(), JptJaxbEclipseLinkCoreValidationMessages.XPATH__ROOT_NOT_SUPPORTED));
            return;
        }
        ELClassMapping referencedClassMapping = this.context.getAttributeMapping().getReferencedClassMapping();
        if (referencedClassMapping != null && !IterableTools.contains(referencedClassMapping.getKeyXPaths(), (Object)this.referencedXmlPath)) {
            messages.add(this.buildValidationMessage((JaxbNode)this, this.getReferencedXmlPathTextRange(), JptJaxbEclipseLinkCoreValidationMessages.XML_JOIN_NODE__REFERENCED_XML_PATH_NOT_IN_REFERENCED_CLASS_KEYS, new Object[]{referencedClassMapping.getTypeName().getFullyQualifiedName(), this.referencedXmlPath}));
        }
        XsdTypeDefinition xsdType = this.getAttributeMapping().getReferencedXsdTypeDefinition();
        XPath xpath = XPathFactory.instance().getXpath(this.referencedXmlPath);
        xpath.validate(new ReferencedXmlPathContext(), xsdType, messages);
    }

    protected TextRange getXmlPathTextRange() {
        return this.getAnnotation().getXmlPathTextRange();
    }

    protected TextRange getReferencedXmlPathTextRange() {
        return this.getAnnotation().getReferencedXmlPathTextRange();
    }

    public static interface Context {
        public XmlJoinNodeAnnotation getAnnotation();

        public ELXmlJoinNodesMapping getAttributeMapping();
    }

    protected class ReferencedXmlPathContext
    extends XPathContext {
        protected ReferencedXmlPathContext() {
        }

        @Override
        public TextRange getTextRange() {
            return ELJavaXmlJoinNode.this.getReferencedXmlPathTextRange();
        }
    }

    protected abstract class XPathContext
    extends XPath.AbstractContext {
        protected XPathContext() {
        }

        @Override
        public JaxbNode getContextObject() {
            return ELJavaXmlJoinNode.this;
        }

        @Override
        public JaxbPackage getJaxbPackage() {
            return ELJavaXmlJoinNode.this.getJaxbPackage();
        }
    }

    protected class XmlPathContext
    extends XPathContext {
        protected XmlPathContext() {
        }

        @Override
        public TextRange getTextRange() {
            return ELJavaXmlJoinNode.this.getXmlPathTextRange();
        }
    }
}

