/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.CommandFailedException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.ProcessResult;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FS_POSIX
extends FS {
    private static final Logger LOG = LoggerFactory.getLogger(FS_POSIX.class);
    private static final int DEFAULT_UMASK = 18;
    private volatile int umask = -1;
    private volatile boolean supportsUnixNLink = true;
    private volatile Boolean supportsAtomicCreateNewFile;

    protected FS_POSIX() {
    }

    protected FS_POSIX(FS src) {
        super(src);
        if (src instanceof FS_POSIX) {
            this.umask = ((FS_POSIX)src).umask;
        }
    }

    private void determineAtomicFileCreationSupport() {
        Boolean ret = this.getAtomicFileCreationSupportOption(SystemReader.getInstance().openUserConfig(null, this));
        if (ret == null && StringUtils.isEmptyOrNull(SystemReader.getInstance().getenv("GIT_CONFIG_NOSYSTEM"))) {
            ret = this.getAtomicFileCreationSupportOption(SystemReader.getInstance().openSystemConfig(null, this));
        }
        this.supportsAtomicCreateNewFile = ret == null || ret != false;
    }

    private Boolean getAtomicFileCreationSupportOption(FileBasedConfig config) {
        try {
            config.load();
            String value = config.getString("core", null, "supportsatomicfilecreation");
            if (value == null) {
                return null;
            }
            return StringUtils.toBoolean(value);
        }
        catch (IOException | ConfigInvalidException e) {
            return Boolean.TRUE;
        }
    }

    @Override
    public FS newInstance() {
        return new FS_POSIX(this);
    }

    public void setUmask(int umask) {
        this.umask = umask;
    }

    private int umask() {
        int u = this.umask;
        if (u == -1) {
            this.umask = u = FS_POSIX.readUmask();
        }
        return u;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int readUmask() {
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"sh", "-c", "umask"}, null, null);
            try (BufferedReader lineRead = new BufferedReader(new InputStreamReader(p.getInputStream(), Charset.defaultCharset().name()));){
                String s;
                if (p.waitFor() == 0 && (s = lineRead.readLine()) != null && s.matches("0?\\d{3}")) {
                    int n2 = Integer.parseInt(s, 8);
                    return n2;
                }
                int n = 18;
                return n;
            }
        }
        catch (Exception e) {
            return 18;
        }
    }

    @Override
    protected File discoverGitExe() {
        String path = SystemReader.getInstance().getenv("PATH");
        File gitExe = FS_POSIX.searchPath(path, "git");
        if (gitExe == null && SystemReader.getInstance().isMacOS() && FS_POSIX.searchPath(path, "bash") != null) {
            String w;
            try {
                w = FS_POSIX.readPipe(this.userHome(), new String[]{"bash", "--login", "-c", "which git"}, Charset.defaultCharset().name());
            }
            catch (CommandFailedException e) {
                LOG.warn(e.getMessage());
                return null;
            }
            if (!StringUtils.isEmptyOrNull(w)) {
                gitExe = new File(w);
            }
        }
        return gitExe;
    }

    @Override
    public boolean isCaseSensitive() {
        return !SystemReader.getInstance().isMacOS();
    }

    @Override
    public boolean supportsExecute() {
        return true;
    }

    @Override
    public boolean canExecute(File f) {
        return FileUtils.canExecute(f);
    }

    @Override
    public boolean setExecute(File f, boolean canExecute) {
        if (!this.isFile(f)) {
            return false;
        }
        if (!canExecute) {
            return f.setExecutable(false, false);
        }
        try {
            Path path = f.toPath();
            Set<PosixFilePermission> pset = Files.getPosixFilePermissions(path, new LinkOption[0]);
            pset.add(PosixFilePermission.OWNER_EXECUTE);
            int mask = this.umask();
            FS_POSIX.apply(pset, mask, PosixFilePermission.GROUP_EXECUTE, 8);
            FS_POSIX.apply(pset, mask, PosixFilePermission.OTHERS_EXECUTE, 1);
            Files.setPosixFilePermissions(path, pset);
            return true;
        }
        catch (IOException e) {
            boolean debug = Boolean.parseBoolean(SystemReader.getInstance().getProperty("jgit.fs.debug"));
            if (debug) {
                System.err.println(e);
            }
            return false;
        }
    }

    private static void apply(Set<PosixFilePermission> set, int umask, PosixFilePermission perm, int test) {
        if ((umask & test) == 0) {
            set.add(perm);
        } else {
            set.remove((Object)perm);
        }
    }

    @Override
    public ProcessBuilder runInShell(String cmd, String[] args) {
        ArrayList<String> argv = new ArrayList<String>(4 + args.length);
        argv.add("sh");
        argv.add("-c");
        argv.add(cmd + " \"$@\"");
        argv.add(cmd);
        argv.addAll(Arrays.asList(args));
        ProcessBuilder proc = new ProcessBuilder(new String[0]);
        proc.command(argv);
        return proc;
    }

    @Override
    public ProcessResult runHookIfPresent(Repository repository, String hookName, String[] args, PrintStream outRedirect, PrintStream errRedirect, String stdinArgs) throws JGitInternalException {
        return this.internalRunHookIfPresent(repository, hookName, args, outRedirect, errRedirect, stdinArgs);
    }

    @Override
    public boolean retryFailedLockFileCommit() {
        return false;
    }

    @Override
    public boolean supportsSymlinks() {
        return true;
    }

    @Override
    public void setHidden(File path, boolean hidden) throws IOException {
    }

    @Override
    public FS.Attributes getAttributes(File path) {
        return FileUtils.getFileAttributesPosix(this, path);
    }

    @Override
    public File normalize(File file) {
        return FileUtils.normalize(file);
    }

    @Override
    public String normalize(String name) {
        return FileUtils.normalize(name);
    }

    @Override
    public File findHook(Repository repository, String hookName) {
        File gitdir = repository.getDirectory();
        if (gitdir == null) {
            return null;
        }
        Path hookPath = gitdir.toPath().resolve("hooks").resolve(hookName);
        if (Files.isExecutable(hookPath)) {
            return hookPath.toFile();
        }
        return null;
    }

    @Override
    public boolean supportsAtomicCreateNewFile() {
        if (this.supportsAtomicCreateNewFile == null) {
            this.determineAtomicFileCreationSupport();
        }
        return this.supportsAtomicCreateNewFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createNewFile(File lock) throws IOException {
        if (!lock.createNewFile()) {
            return false;
        }
        if (this.supportsAtomicCreateNewFile() || !this.supportsUnixNLink) {
            return true;
        }
        Path lockPath = lock.toPath();
        Path link = Files.createLink(Paths.get(lock.getAbsolutePath() + ".lnk", new String[0]), lockPath);
        try {
            Integer nlink = (Integer)Files.getAttribute(lockPath, "unix:nlink", new LinkOption[0]);
            if (nlink != 2) {
                LOG.warn("nlink of link to lock file {0} was not 2 but {1}", (Object)lock.getPath(), (Object)nlink);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IllegalArgumentException | UnsupportedOperationException e) {
            this.supportsUnixNLink = false;
            boolean bl = true;
            return bl;
        }
        finally {
            Files.delete(link);
        }
    }
}

