/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.di;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEventsQueue;
import org.eclipse.epp.internal.logging.aeri.ide.filters.ActiveShellStatusFilter;
import org.eclipse.epp.internal.logging.aeri.ide.filters.ActiveWorkbenchStatusFilter;
import org.eclipse.epp.internal.logging.aeri.ide.filters.QueueSizeLimitFilter;
import org.eclipse.epp.logging.aeri.core.SystemControl;
import org.eclipse.epp.logging.aeri.core.filters.DecoratingDebugFilter;
import org.eclipse.epp.logging.aeri.core.filters.EclipseBuildIdFilter;
import org.eclipse.epp.logging.aeri.core.filters.NoErrorStatusFilter;
import org.eclipse.epp.logging.aeri.core.filters.RecentlySeenFilter;
import org.eclipse.epp.logging.aeri.core.filters.SystemEnabledFilter;
import org.eclipse.epp.logging.aeri.core.util.LogListener;
import org.eclipse.ui.PlatformUI;

public class LogListenerCreationFunction
extends ContextFunction {
    public Object compute(IEclipseContext context, String contextKey) {
        contextKey = (String)Preconditions.checkNotNull((Object)contextKey);
        IEventBroker broker = (IEventBroker)context.get(IEventBroker.class);
        ILogEventsQueue queue = (ILogEventsQueue)context.get(ILogEventsQueue.class);
        QueueSizeLimitFilter queueSizeLimitFilter = new QueueSizeLimitFilter(queue, 20);
        IEclipseContext systemContext = SystemControl.getSystemContext();
        ContextInjectionFactory.inject((Object)queueSizeLimitFilter, (IEclipseContext)systemContext);
        Predicate[] statusPredicates = DecoratingDebugFilter.decorate((Predicate[])new Predicate[]{new EclipseBuildIdFilter(), new NoErrorStatusFilter(), new ActiveShellStatusFilter(), new SystemEnabledFilter(), new RecentlySeenFilter(), new ActiveWorkbenchStatusFilter(PlatformUI.getWorkbench()), queueSizeLimitFilter});
        Predicate statusFilters = Predicates.and((Predicate[])statusPredicates);
        LogListener listener = new LogListener(statusFilters, broker);
        systemContext.set(contextKey, (Object)listener);
        systemContext.set(QueueSizeLimitFilter.class, (Object)queueSizeLimitFilter);
        return listener;
    }
}

