/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.logging.aeri.core.filters;

import java.util.List;

import org.eclipse.core.runtime.IStatus;

import com.google.common.base.Predicate;

public class StatusIgnorePatternsFilter implements Predicate<IStatus> {

    private List<StatusIgnorePattern> patterns;

    public StatusIgnorePatternsFilter(List<StatusIgnorePattern> patterns) {
        this.patterns = patterns;
    }

    @Override
    public boolean apply(IStatus input) {
        for (StatusIgnorePattern pattern : patterns) {
            if (pattern.matches(input)) {
                return false;
            }
        }
        return true;
    }
}
