/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.editors;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.presentation.EcoreEditorPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emf.parsley.editors.EmfAbstractEditor;
import org.eclipse.emf.parsley.resource.LoadResourceResponse;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;

public class EmfTreeEditor
extends EmfAbstractEditor {
    public void createPages() {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        LoadResourceResponse response = this.resourceLoader.getResource((EditingDomain)this.editingDomain, resourceURI);
        this.handleProblems(response);
        Tree tree = new Tree(this.getContainer(), 2);
        TreeViewer emfTreeViewer = new TreeViewer(tree);
        this.viewerFactory.initialize((StructuredViewer)emfTreeViewer, (EditingDomain)this.editingDomain);
        this.selectionViewer = emfTreeViewer;
        this.setSelectionOnRoot(this.selectionViewer);
        this.createAdapterFactoryTreeEditor(emfTreeViewer);
        this.createContextMenuFor(this.selectionViewer);
        this.selectionViewer.addSelectionChangedListener(this.createSelectionChangedListener());
        int pageIndex = this.addPage((Control)tree);
        this.setPageText(pageIndex, EmfTreeEditor.getString("_UI_SelectionPage_label"));
        this.setActivePage(0);
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    EmfTreeEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.updateProblemIndication();
    }

    protected AdapterFactoryTreeEditor createAdapterFactoryTreeEditor(TreeViewer emfTreeViewer) {
        return new AdapterFactoryTreeEditor(emfTreeViewer.getTree(), (AdapterFactory)this.adapterFactory);
    }

    protected void handleProblems(LoadResourceResponse response) {
        Exception exception;
        Resource resource = response.getResource();
        Diagnostic diagnostic = this.analyzeResourceProblems(resource, exception = response.getException());
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
    }

    private static String getString(String key) {
        return EcoreEditorPlugin.INSTANCE.getString(key);
    }

    @Override
    protected boolean showOutlineView() {
        return true;
    }
}

