/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.widget.facetcustom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.custom.core.ICustomizationManagerFactory;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.FacetCustomization;
import org.eclipse.emf.facet.custom.ui.IContentPropertiesHandler;
import org.eclipse.emf.facet.custom.ui.IContentPropertiesHandlerFactory;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.ui.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.exception.TableWidgetRuntimeException;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.facetcustom.FacetsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CustomizationUtils {
    private CustomizationUtils() {
    }

    public static Set<FacetSet> findFacetsCustomizedBy(List<Customization> customizations) {
        HashSet<FacetSet> referencedFS = new HashSet<FacetSet>();
        for (Customization customization : customizations) {
            for (EClassifier eClassifier : customization.getEClassifiers()) {
                if (!(eClassifier instanceof FacetCustomization)) continue;
                FacetCustomization facetCustom = (FacetCustomization)eClassifier;
                for (Facet extFacet : facetCustom.getExtendedFacets()) {
                    referencedFS.add((FacetSet)extFacet.getEPackage());
                }
            }
        }
        return referencedFS;
    }

    public static Customization findCustomizationExtendingEPackage(List<Customization> customizations, EPackage ePackage) {
        if (ePackage == null) {
            throw new IllegalArgumentException("ePackage must not be null");
        }
        Customization result = null;
        for (Customization customization : customizations) {
            if (customization == null || !ePackage.equals(FacetUtils.getExtendedEPackage((FacetSet)customization))) continue;
            result = customization;
            break;
        }
        return result;
    }

    public static boolean isOneOfTheLocalCustomizationsNotOnTheTop(Table table) {
        boolean result = false;
        EList view = table.getCustomizations();
        EList locals = table.getLocalCustomizations();
        if (view.size() < locals.size()) {
            throw new TableWidgetRuntimeException("Some local customization files are not loaded");
        }
        int i = 0;
        while (i < locals.size()) {
            if (!locals.contains(view.get(i))) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    public static void loadCustomizationsInTable(Table table) {
        EList customsToLoad = table.getCustomizations();
        EList locals = table.getLocalCustomizations();
        ICustomizationManager customManager = CustomizationUtils.getCustomManager((EObject)table);
        if (table.getRows().size() != 0 && locals.isEmpty()) {
            String msg = String.format("The local customs should always be contained by customizationsToLoad, please update the model: %s", table.eResource().getURI());
            Logger.logError((String)msg, (Plugin)Activator.getDefault());
        }
        if (!locals.isEmpty() && !customsToLoad.containsAll((Collection<?>)locals)) {
            Logger.logError((String)"The local customs should always be contained by customizationsToLoad", (Plugin)Activator.getDefault());
        }
        customManager.getManagedCustomizations().removeAll((Collection<?>)customsToLoad);
        for (Customization customizationToLoad : customsToLoad) {
            customManager.getManagedCustomizations().add(0, customizationToLoad);
        }
    }

    public static ICustomizationManager getCustomManager(EObject eObject) {
        ResourceSet resourceSet = eObject.eResource().getResourceSet();
        return ICustomizationManagerFactory.DEFAULT.getOrCreateICustomizationManager(resourceSet);
    }

    public static List<FacetSet> getKnownFacetSetsWithoutCustom(Table table) {
        ArrayList<FacetSet> result = new ArrayList<FacetSet>();
        List<FacetSet> knownFacetSets = FacetsUtils.getKnownFacetSets(table);
        for (FacetSet facetSet : knownFacetSets) {
            if (facetSet instanceof Customization) continue;
            result.add(facetSet);
        }
        return result;
    }

    public static IContentPropertiesHandler getContentPropertiesHandler(Table table) {
        ICustomizationManager customManager = CustomizationUtils.getCustomManager((EObject)table);
        return IContentPropertiesHandlerFactory.DEFAULT.createIContentPropertiesHandler(customManager);
    }
}

