/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.extended.ui.initializer;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.eef.codegen.EEFCodegenPlugin;
import org.eclipse.emf.eef.codegen.core.util.EMFHelper;
import org.eclipse.emf.eef.codegen.extended.initializer.EEFEditorInitializer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

public class InitializeEEFEditorAction
implements IObjectActionDelegate,
IEditorActionDelegate {
    private URI modelURI;
    private IFile selectedFile = null;
    private IWorkbenchPartSite activeSite;

    public void run(IAction action) {
        if (this.selectedFile != null) {
            try {
                this.modelURI = URI.createURI((String)("platform:/resource" + this.selectedFile.getFullPath()));
                IContainer container = this.selectedFile.getParent();
                EEFEditorInitializer initializer = new EEFEditorInitializer(this.selectedFile, this.activeSite);
                initializer.initialize(this.modelURI, container);
                container.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                EEFCodegenPlugin.getDefault().logError(e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof StructuredSelection) {
            IFile associatedFile;
            EObject eObject;
            StructuredSelection sSelection = (StructuredSelection)selection;
            Object selectedElement = sSelection.getFirstElement();
            if (selectedElement instanceof IFile) {
                this.selectedFile = (IFile)selectedElement;
            } else if (selectedElement instanceof IAdaptable && (eObject = (EObject)((IAdaptable)selectedElement).getAdapter(EObject.class)) != null && eObject.eResource().getURI().fileExtension().equals("ecore") && (associatedFile = EMFHelper.associatedFile((EObject)eObject)).isAccessible()) {
                this.selectedFile = associatedFile;
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.activeSite = targetPart.getSite();
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor != null) {
            this.activeSite = targetEditor.getSite();
        }
    }
}

