/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.extended.flow;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.eef.codegen.flow.StepWithInput;
import org.eclipse.emf.eef.codegen.flow.util.GenmodelHelper;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanEEFEditorSources
extends StepWithInput {
    private static final String PLUGIN_XML = "plugin.xml";
    private static final String PLUGIN_PROPERTIES = "plugin.properties";
    private static final String BUILD_PROPERTIES = "build.properties";
    private GenmodelHelper helper;
    private IFile ecoreModel;
    private IContainer targetFolder;
    private boolean genmodel;
    private boolean emfModelCode;
    private boolean emfEditCode;
    private boolean emfEditorCode;
    private boolean eefPropertiesModels;
    private boolean eefEditorModels;

    public CleanEEFEditorSources(String name, IFile ecoreModel, IContainer targetFolder) {
        super(name);
        this.ecoreModel = ecoreModel;
        this.targetFolder = targetFolder;
        this.genmodel = true;
        this.emfModelCode = true;
        this.emfEditCode = true;
        this.emfEditorCode = true;
        this.eefPropertiesModels = true;
        this.eefEditorModels = false;
    }

    public IStatus execute(IProgressMonitor monitor) {
        try {
            GenModel genModel = this.helper.getGenModel();
            if (genModel != null) {
                String modelDirectory = genModel.getModelDirectory();
                String editDirectory = genModel.getEditDirectory();
                String editorDirectory = genModel.getEditorDirectory();
                if (this.genmodel) {
                    this.deleteGenmodel(monitor);
                }
                if (this.emfModelCode) {
                    this.deleteProject(modelDirectory, monitor);
                }
                if (this.emfEditCode) {
                    this.deleteProject(editDirectory, monitor);
                }
                if (this.emfEditorCode) {
                    this.deleteProject(editorDirectory, monitor);
                }
                if (this.eefPropertiesModels) {
                    this.deleteEEFPropertiesModels(monitor);
                }
                if (this.eefEditorModels) {
                    this.deleteEEFEditorModels(monitor);
                }
            }
        }
        catch (CoreException e) {
            return new Status(4, "org.eclipse.emf.eef.runtime.extended", "Unable to delete genmodel file.", (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public List<WizardPage> getInputPages() {
        this.helper = new GenmodelHelper(this.resourceSet, this.ecoreModel, this.targetFolder);
        CleanEEFEditorSourcesWizardPage cleanEEFEditorSourcesWizardPage = new CleanEEFEditorSourcesWizardPage("Clean EEF Editor sources page");
        ArrayList<WizardPage> pages = new ArrayList<WizardPage>();
        pages.add(cleanEEFEditorSourcesWizardPage);
        return pages;
    }

    protected void deleteGenmodel(IProgressMonitor monitor) throws CoreException {
        IFile genModelFile = this.helper.getGenModelFile();
        if (genModelFile.isAccessible()) {
            genModelFile.delete(true, monitor);
            this.helper.getTargetFolder().refreshLocal(2, monitor);
        }
    }

    protected void deleteProject(String srcFolderDirectory, IProgressMonitor monitor) throws CoreException {
        IFolder srcFolder = this.ecoreModel.getWorkspace().getRoot().getFolder((IPath)new Path(srcFolderDirectory));
        IProject project = srcFolder.getProject();
        IFile pluginXML = project.getFile((IPath)new Path(PLUGIN_XML));
        IFile pluginProperties = project.getFile((IPath)new Path(PLUGIN_PROPERTIES));
        IFile buildProperties = project.getFile((IPath)new Path(BUILD_PROPERTIES));
        if (srcFolder.isAccessible()) {
            srcFolder.delete(true, monitor);
        }
        if (pluginXML.isAccessible()) {
            pluginXML.delete(true, monitor);
        }
        if (pluginProperties.isAccessible()) {
            pluginProperties.delete(true, monitor);
        }
        if (buildProperties.isAccessible()) {
            buildProperties.delete(true, monitor);
        }
        project.refreshLocal(2, monitor);
    }

    protected void deleteEEFPropertiesModels(IProgressMonitor monitor) throws CoreException {
        IFile eefPropertiesEEFGenModel;
        IFile eefPropertiesComponentsModel = this.helper.getEEFPropertiesComponentsModel();
        if (eefPropertiesComponentsModel.isAccessible()) {
            eefPropertiesComponentsModel.delete(true, monitor);
        }
        if ((eefPropertiesEEFGenModel = this.helper.getEEFPropertiesEEFGenModel()).isAccessible()) {
            eefPropertiesEEFGenModel.delete(true, monitor);
        }
        this.helper.getEEFModelsFolder().refreshLocal(2, monitor);
    }

    protected void deleteEEFEditorModels(IProgressMonitor monitor) throws CoreException {
        IFile eefEditorEEFGenModel;
        IFile eefEditorComponentsModel = this.helper.getEEFEditorComponentsModel();
        if (eefEditorComponentsModel.isAccessible()) {
            eefEditorComponentsModel.delete(true, monitor);
        }
        if ((eefEditorEEFGenModel = this.helper.getEEFEditorEEFGenModel()).isAccessible()) {
            eefEditorEEFGenModel.delete(true, monitor);
        }
        this.helper.getEEFModelsFolder().refreshLocal(2, monitor);
    }

    private class CleanEEFEditorSourcesWizardPage
    extends WizardPage {
        private Button genmodelButton;
        private Button emfModelCodeButton;
        private Button emfEditCodeButton;
        private Button emfEditorCodeButton;
        private Button eefPropertiesModelsButton;
        private Button eefEditorModelsButton;

        public CleanEEFEditorSourcesWizardPage(String pageName) {
            super(pageName);
            this.setTitle("EEF editor sources cleaning");
            this.setDescription("Choose actions you want to perform");
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            container.setLayout((Layout)layout);
            this.genmodelButton = new Button(container, 32);
            this.genmodelButton.setText("Delete generated 'genmodel' file");
            this.genmodelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CleanEEFEditorSources.this.genmodel = !CleanEEFEditorSources.this.genmodel;
                }
            });
            if (CleanEEFEditorSources.this.helper.getGenModelFile().exists()) {
                this.genmodelButton.setSelection(CleanEEFEditorSources.this.genmodel);
            } else {
                this.genmodelButton.setEnabled(false);
                CleanEEFEditorSources.this.genmodel = false;
            }
            this.emfModelCodeButton = new Button(container, 32);
            this.emfModelCodeButton.setText("Delete generated EMF model code");
            this.emfModelCodeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CleanEEFEditorSources.this.emfModelCode = !CleanEEFEditorSources.this.emfModelCode;
                }
            });
            IFolder emfModelSrcFolder = CleanEEFEditorSources.this.helper.getEMFModelSrcFolder();
            if (emfModelSrcFolder != null && emfModelSrcFolder.isAccessible()) {
                this.emfModelCodeButton.setSelection(CleanEEFEditorSources.this.emfModelCode);
            } else {
                this.emfModelCodeButton.setEnabled(false);
                CleanEEFEditorSources.this.emfModelCode = false;
            }
            this.emfEditCodeButton = new Button(container, 32);
            this.emfEditCodeButton.setText("Delete generated EMF edit code");
            this.emfEditCodeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CleanEEFEditorSources.this.emfEditCode = !CleanEEFEditorSources.this.emfEditCode;
                }
            });
            IFolder emfEditSrcFolder = CleanEEFEditorSources.this.helper.getEMFEditSrcFolder();
            if (emfEditSrcFolder != null && emfEditSrcFolder.isAccessible()) {
                this.emfEditCodeButton.setSelection(CleanEEFEditorSources.this.emfEditCode);
            } else {
                this.emfEditCodeButton.setEnabled(false);
                CleanEEFEditorSources.this.emfEditCode = false;
            }
            this.emfEditorCodeButton = new Button(container, 32);
            this.emfEditorCodeButton.setText("Delete generated EMF editor code");
            this.emfEditorCodeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CleanEEFEditorSources.this.emfEditorCode = !CleanEEFEditorSources.this.emfEditorCode;
                }
            });
            IFolder emfEditorSrcFolder = CleanEEFEditorSources.this.helper.getEMFEditorSrcFolder();
            if (emfEditorSrcFolder != null && emfEditorSrcFolder.isAccessible()) {
                this.emfEditorCodeButton.setSelection(CleanEEFEditorSources.this.emfEditorCode);
            } else {
                this.emfEditorCodeButton.setEnabled(false);
                CleanEEFEditorSources.this.emfEditorCode = false;
            }
            this.eefPropertiesModelsButton = new Button(container, 32);
            this.eefPropertiesModelsButton.setText("Delete generated EEF models for properties views");
            this.eefPropertiesModelsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CleanEEFEditorSources.this.eefPropertiesModels = !CleanEEFEditorSources.this.eefPropertiesModels;
                }
            });
            if (CleanEEFEditorSources.this.helper.getEEFPropertiesComponentsModel().exists() || CleanEEFEditorSources.this.helper.getEEFPropertiesEEFGenModel().exists()) {
                this.eefPropertiesModelsButton.setSelection(CleanEEFEditorSources.this.eefPropertiesModels);
            } else {
                this.eefPropertiesModelsButton.setEnabled(false);
                CleanEEFEditorSources.this.eefPropertiesModels = false;
            }
            this.eefEditorModelsButton = new Button(container, 32);
            this.eefEditorModelsButton.setText("Delete generated EEF models for EEF editor");
            this.eefEditorModelsButton.setSelection(true);
            this.eefEditorModelsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CleanEEFEditorSources.this.eefEditorModels = !CleanEEFEditorSources.this.eefEditorModels;
                }
            });
            if (CleanEEFEditorSources.this.helper.getEEFEditorComponentsModel().exists() || CleanEEFEditorSources.this.helper.getEEFEditorEEFGenModel().exists()) {
                this.eefEditorModelsButton.setSelection(CleanEEFEditorSources.this.eefEditorModels);
            } else {
                this.eefEditorModelsButton.setEnabled(false);
                CleanEEFEditorSources.this.eefEditorModels = false;
            }
            this.setControl((Control)container);
        }
    }
}

