/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.papyrus.contentmergeviewer;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.diagram.ide.ui.papyrus.contentmergeviewer.facet.PapyrusFacetContentProviderWrapperAdapterFactory;
import org.eclipse.emf.compare.diagram.ide.ui.papyrus.contentmergeviewer.provider.PapyrusTreeContentMergeViewerItemLabelProvider;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree.TreeContentMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree.provider.MergeViewerItemProviderConfiguration;
import org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.ICompareAccessor;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl.AbstractMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl.AbstractTableOrTreeMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl.TreeMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.ICompareColor;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.provider.IMergeViewerItemProviderConfiguration;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;

public class PapyrusTreeContentMergeViewer
extends TreeContentMergeViewer {
    private static final int MAX_SEARCH_LEVEL = 20;
    private Map<Object, IMergeViewerItem> cachedMapForSelection;
    private LinkedList<AbstractContentFunction> leftContentComputations;
    private LinkedList<AbstractContentFunction> rightContentComputations;

    public PapyrusTreeContentMergeViewer(int style, ResourceBundle bundle, Composite parent, EMFCompareConfiguration config) {
        super(style, bundle, parent, config);
    }

    protected AbstractMergeViewer createMergeViewer(Composite parent, IMergeViewer.MergeViewerSide side) {
        TreeMergeViewer mergeTreeViewer = new TreeMergeViewer(parent, side, (ICompareColor.Provider)this, (IEMFCompareConfiguration)this.getCompareConfiguration());
        IContentProvider contentProvider = this.createMergeViewerContentProvider(side);
        mergeTreeViewer.setContentProvider(contentProvider);
        PapyrusTreeContentMergeViewerItemLabelProvider labelProvider = new PapyrusTreeContentMergeViewerItemLabelProvider(this.getResourceBundle(), (AdapterFactory)this.getAdapterFactory(), side);
        mergeTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.hookListeners(mergeTreeViewer);
        return mergeTreeViewer;
    }

    protected IMergeViewerItemProviderConfiguration createMergeViewerItemProviderConfiguration(IMergeViewer.MergeViewerSide side) {
        ComposedAdapterFactory factory = new ComposedAdapterFactory(new AdapterFactory[]{new PapyrusFacetContentProviderWrapperAdapterFactory(), this.getAdapterFactory()});
        return new MergeViewerItemProviderConfiguration((AdapterFactory)factory, this.getDifferenceGroupProvider(), this.getDifferenceFilterPredicate(), this.getCompareConfiguration().getComparison(), side);
    }

    private static boolean isCompareAccessor(Object input) {
        return input instanceof ICompareAccessor;
    }

    private boolean isDifferentInput(IMergeViewer.MergeViewerSide side, Object input) {
        TreeMergeViewer viewer = this.getMergeViewer(side);
        if (!PapyrusTreeContentMergeViewer.isCompareAccessor(input) || !PapyrusTreeContentMergeViewer.isCompareAccessor(viewer.getInput())) {
            return true;
        }
        ImmutableList inputItems = ((ICompareAccessor)ICompareAccessor.class.cast(input)).getItems();
        ImmutableList vieweritems = ((ICompareAccessor)ICompareAccessor.class.cast(viewer.getInput())).getItems();
        if (inputItems.size() != vieweritems.size()) {
            return true;
        }
        AbstractTableOrTreeMergeViewer.ElementComparer comparer = new AbstractTableOrTreeMergeViewer.ElementComparer();
        int i = 0;
        while (i < vieweritems.size()) {
            if (!comparer.equals(inputItems.get(i), vieweritems.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public TreeMergeViewer getMergeViewer(IMergeViewer.MergeViewerSide side) {
        if (side == IMergeViewer.MergeViewerSide.LEFT) {
            return this.getLeftMergeViewer();
        }
        if (side == IMergeViewer.MergeViewerSide.RIGHT) {
            return this.getRightMergeViewer();
        }
        return this.getAncestorMergeViewer();
    }

    protected void updateContent(Object ancestor, Object left, Object right) {
        if (this.isDifferentInput(IMergeViewer.MergeViewerSide.LEFT, left) || this.isDifferentInput(IMergeViewer.MergeViewerSide.RIGHT, right)) {
            this.getAncestorMergeViewer().setInput(ancestor);
            this.getLeftMergeViewer().setInput(left);
            this.getRightMergeViewer().setInput(right);
            this.leftContentComputations = null;
            this.rightContentComputations = null;
            this.cachedMapForSelection = null;
        }
        IMergeViewerItem leftInitialItem = null;
        if (left instanceof ICompareAccessor) {
            leftInitialItem = ((ICompareAccessor)left).getInitialItem();
        }
        if (leftInitialItem == null || leftInitialItem.getLeft() == null) {
            if (right instanceof ICompareAccessor) {
                IMergeViewerItem rightInitialItem = ((ICompareAccessor)right).getInitialItem();
                if (rightInitialItem == null) {
                    this.getLeftMergeViewer().setSelection((ISelection)StructuredSelection.EMPTY, true);
                } else {
                    this.setSelection((ICompareAccessor)right, this.getRightMergeViewer());
                }
            } else {
                this.getLeftMergeViewer().setSelection((ISelection)StructuredSelection.EMPTY, true);
            }
        } else {
            this.setSelection((ICompareAccessor)left, this.getLeftMergeViewer());
        }
        this.redrawCenterControl();
    }

    private void setSelection(ICompareAccessor accessor, TreeMergeViewer viewer) {
        IMergeViewerItem initialItem = accessor.getInitialItem();
        viewer.setSelection((ISelection)new StructuredSelection((Object)initialItem), true);
        if (viewer.getSelection().isEmpty()) {
            IMergeViewerItem itemToBeSelected = this.getItemToBeSelected(initialItem);
            if (itemToBeSelected != null) {
                viewer.setSelection((ISelection)new StructuredSelection((Object)itemToBeSelected), true);
            } else {
                viewer.setSelection((ISelection)new StructuredSelection(), true);
            }
        }
    }

    private IMergeViewerItem getItemToBeSelected(IMergeViewerItem item) {
        IMergeViewerItem result;
        IMergeViewer.MergeViewerSide side = item.getSide();
        Object itemValue = item.getSideValue(side);
        if (this.cachedMapForSelection == null) {
            this.cachedMapForSelection = new HashMap<Object, IMergeViewerItem>();
            result = null;
        } else {
            result = this.cachedMapForSelection.get(itemValue);
        }
        if (result == null) {
            LinkedList<AbstractContentFunction> contentComputations;
            switch (side) {
                case LEFT: {
                    if (this.leftContentComputations == null) {
                        this.leftContentComputations = new LinkedList();
                        this.leftContentComputations.add(new ElementFunction(side, this.getLeftMergeViewer(), this.leftContentComputations, this.cachedMapForSelection));
                    }
                    contentComputations = this.leftContentComputations;
                    break;
                }
                case RIGHT: {
                    if (this.rightContentComputations == null) {
                        this.rightContentComputations = new LinkedList();
                        this.rightContentComputations.add(new ElementFunction(side, this.getRightMergeViewer(), this.rightContentComputations, this.cachedMapForSelection));
                    }
                    contentComputations = this.rightContentComputations;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            Collection<Object> containers = this.getContainers(itemValue);
            if (!containers.isEmpty()) {
                List<AbstractContentFunction> containerComputations = this.extractComputations(contentComputations, containers);
                contentComputations.addAll(0, containerComputations);
            }
            while (!contentComputations.isEmpty()) {
                result = contentComputations.removeFirst().apply(itemValue, containers);
                if (result != null) break;
            }
        }
        return result;
    }

    protected void handleDispose(DisposeEvent event) {
        if (this.cachedMapForSelection != null) {
            this.cachedMapForSelection = null;
        }
        super.handleDispose(event);
    }

    private List<AbstractContentFunction> extractComputations(LinkedList<AbstractContentFunction> computations, Collection<Object> values) {
        ArrayList<AbstractContentFunction> extractedComputations = new ArrayList<AbstractContentFunction>();
        Iterator computationsIterator = computations.iterator();
        while (computationsIterator.hasNext()) {
            AbstractContentFunction contentFuction = (AbstractContentFunction)computationsIterator.next();
            if (!values.contains(contentFuction.getValue())) continue;
            computationsIterator.remove();
            extractedComputations.add(contentFuction);
        }
        return extractedComputations;
    }

    private Collection<Object> getContainers(Object eObject) {
        Set<Object> containers;
        if (eObject instanceof EObject) {
            containers = new HashSet();
            EObject container = ((EObject)eObject).eContainer();
            while (container != null) {
                containers.add(container);
                container = container.eContainer();
            }
        } else {
            containers = Collections.emptySet();
        }
        return containers;
    }

    private static abstract class AbstractContentFunction {
        protected final IMergeViewer.MergeViewerSide side;
        protected final ITreeContentProvider provider;
        protected final LinkedList<AbstractContentFunction> contentComputations;
        protected final Map<Object, IMergeViewerItem> selections;

        protected AbstractContentFunction(IMergeViewer.MergeViewerSide side, ITreeContentProvider provider, LinkedList<AbstractContentFunction> contentComputations, Map<Object, IMergeViewerItem> selections) {
            this.side = side;
            this.provider = provider;
            this.contentComputations = contentComputations;
            this.selections = selections;
        }

        public abstract IMergeViewerItem apply(Object var1, Collection<?> var2);

        public abstract Object getValue();

        protected IMergeViewerItem apply(Object matchValue, Collection<?> containers, Object[] values, int depth) {
            IMergeViewerItem result = null;
            Object[] objectArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IMergeViewerItem) {
                    IMergeViewerItem item = (IMergeViewerItem)element;
                    Object sideValue = item.getSideValue(this.side);
                    if (result == null && sideValue != null && sideValue.equals(matchValue)) {
                        result = item;
                    }
                    ChildFunction childFunction = new ChildFunction(this.side, this.provider, item, depth, this.contentComputations, this.selections);
                    if (containers.contains(sideValue)) {
                        this.contentComputations.addFirst(childFunction);
                    } else {
                        this.contentComputations.addLast(childFunction);
                    }
                }
                ++n2;
            }
            return result;
        }
    }

    private static final class ChildFunction
    extends AbstractContentFunction {
        private final IMergeViewerItem item;
        private final int depth;

        private ChildFunction(IMergeViewer.MergeViewerSide side, ITreeContentProvider provider, IMergeViewerItem item, int depth, LinkedList<AbstractContentFunction> contentComputations, Map<Object, IMergeViewerItem> selections) {
            super(side, provider, contentComputations, selections);
            this.item = item;
            this.depth = depth;
            Object value = item.getSideValue(side);
            if (value != null) {
                selections.put(value, item);
            }
        }

        @Override
        public Object getValue() {
            return this.item.getSideValue(this.side);
        }

        @Override
        public IMergeViewerItem apply(Object matchValue, Collection<?> containers) {
            if (this.depth == 20) {
                return null;
            }
            return this.apply(matchValue, containers, this.provider.getChildren((Object)this.item), this.depth + 1);
        }
    }

    private static final class ElementFunction
    extends AbstractContentFunction {
        private final Object input;

        private ElementFunction(IMergeViewer.MergeViewerSide side, TreeMergeViewer viewer, LinkedList<AbstractContentFunction> contentComputations, Map<Object, IMergeViewerItem> selections) {
            super(side, (ITreeContentProvider)viewer.getContentProvider(), contentComputations, selections);
            this.input = viewer.getInput();
        }

        @Override
        public Object getValue() {
            return this.input;
        }

        @Override
        public IMergeViewerItem apply(Object matchValue, Collection<?> containers) {
            return this.apply(matchValue, containers, this.provider.getElements(this.input), 0);
        }
    }
}

