/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.BranchingFeatureMapTableMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.BranchingListTableMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.HorizontalBranchingClassMapping;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBConnection;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBResultSet;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class HorizontalBranchingMappingStrategy
extends AbstractHorizontalMappingStrategy {
    public boolean hasAuditSupport() {
        return true;
    }

    public boolean hasBranchingSupport() {
        return true;
    }

    public boolean hasDeltaSupport() {
        return false;
    }

    protected IClassMapping doCreateClassMapping(EClass eClass) {
        return new HorizontalBranchingClassMapping(this, eClass);
    }

    public IListMapping doCreateListMapping(EClass containingClass, EStructuralFeature feature) {
        return new BranchingListTableMapping(this, containingClass, feature);
    }

    public IListMapping doCreateFeatureMapMapping(EClass containingClass, EStructuralFeature feature) {
        return new BranchingFeatureMapTableMapping(this, containingClass, feature);
    }

    public String getListJoin(String attrTable, String listTable) {
        String join = this.getListJoinBasic(attrTable, listTable);
        return this.modifyListJoin(attrTable, listTable, join, false);
    }

    protected String getListJoinForRawExport(String attrTable, String listTable) {
        String join = this.getListJoinBasic(attrTable, listTable);
        return this.modifyListJoin(attrTable, listTable, join, true);
    }

    protected String getListJoinBasic(String attrTable, String listTable) {
        return super.getListJoin(attrTable, listTable);
    }

    protected String modifyListJoin(String attrTable, String listTable, String join, boolean forRawExport) {
        join = String.valueOf(join) + " AND " + attrTable + "." + "CDO_VERSION";
        join = String.valueOf(join) + "=" + listTable + "." + "CDO_VERSION";
        join = String.valueOf(join) + " AND " + attrTable + "." + "CDO_BRANCH";
        join = String.valueOf(join) + "=" + listTable + "." + "CDO_BRANCH";
        return join;
    }

    protected void rawImportReviseOldRevisions(IDBConnection connection, IDBTable table, OMMonitor monitor) {
        String sqlUpdate = "UPDATE " + table + " SET " + "CDO_REVISED" + "=? WHERE " + "CDO_ID" + "=? AND " + "CDO_BRANCH" + "=? AND " + "CDO_VERSION" + "=?";
        String sqlQuery = "SELECT cdo1.CDO_ID, cdo1.CDO_BRANCH, cdo1.CDO_VERSION, cdo2.CDO_CREATED FROM " + table + " cdo1, " + table + " cdo2 WHERE cdo1." + "CDO_ID" + "=cdo2." + "CDO_ID" + " AND cdo1." + "CDO_BRANCH" + "=cdo2." + "CDO_BRANCH" + " AND (cdo1." + "CDO_VERSION" + "=cdo2." + "CDO_VERSION" + "-1 OR (cdo1." + "CDO_VERSION" + "+cdo2." + "CDO_VERSION" + "=-1 AND cdo1." + "CDO_VERSION" + ">cdo2." + "CDO_VERSION" + ")) AND cdo1." + "CDO_REVISED" + "=0";
        IIDHandler idHandler = this.getStore().getIDHandler();
        IDBPreparedStatement stmtUpdate = connection.prepareStatement(sqlUpdate, IDBPreparedStatement.ReuseProbability.MEDIUM);
        IDBPreparedStatement stmtQuery = connection.prepareStatement(sqlQuery, 1004, 1007, IDBPreparedStatement.ReuseProbability.MEDIUM);
        IDBResultSet resultSet = null;
        try {
            resultSet = stmtQuery.executeQuery();
            int size = DBUtil.getRowCount((ResultSet)resultSet);
            if (size == 0) {
                return;
            }
            try {
                monitor.begin((double)(2 * size));
                while (resultSet.next()) {
                    CDOID id = idHandler.getCDOID((ResultSet)resultSet, 1);
                    int branch = resultSet.getInt(2);
                    int version = resultSet.getInt(3);
                    long revised = resultSet.getLong(4) - 1L;
                    stmtUpdate.setLong(1, revised);
                    idHandler.setCDOID((PreparedStatement)stmtUpdate, 2, id);
                    stmtUpdate.setInt(3, branch);
                    stmtUpdate.setInt(4, version);
                    stmtUpdate.addBatch();
                    monitor.worked();
                }
                OMMonitor.Async async = monitor.forkAsync((double)size);
                try {
                    stmtUpdate.executeBatch();
                }
                finally {
                    async.stop();
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmtQuery);
            DBUtil.close((Statement)stmtUpdate);
            monitor.done();
        }
    }

    protected void rawImportUnreviseNewRevisions(IDBConnection connection, IDBTable table, long fromCommitTime, long toCommitTime, OMMonitor monitor) {
        String sql = "UPDATE " + table + " SET " + "CDO_REVISED" + "=0 WHERE " + "CDO_BRANCH" + ">=0 AND " + "CDO_CREATED" + "<=" + toCommitTime + " AND " + "CDO_REVISED" + ">" + toCommitTime + " AND " + "CDO_VERSION" + ">0";
        IDBPreparedStatement stmt = connection.prepareStatement(sql, IDBPreparedStatement.ReuseProbability.MEDIUM);
        try {
            try {
                monitor.begin();
                OMMonitor.Async async = monitor.forkAsync();
                try {
                    stmt.executeUpdate();
                }
                finally {
                    async.stop();
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
            monitor.done();
        }
    }
}

