/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.editors.automake;

import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.EditorUtility;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.ExternalEditorInput;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;

public class ExternalEditorInputFactory
implements IElementFactory {
    public static final String ID = "org.eclipse.cdt.ui.ExternalEditorInputFactory";
    private static final String TAG_PATH = "path";
    private static final String TAG_PROJECT = "project";

    public IAdaptable createElement(IMemento memento) {
        IProject project;
        String fileName = memento.getString(TAG_PATH);
        if (fileName == null) {
            return null;
        }
        Path location = new Path(fileName);
        ICProject cProject = null;
        String projectName = memento.getString(TAG_PROJECT);
        if (projectName != null && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)).isAccessible() && CoreModel.hasCNature((IProject)project)) {
            cProject = CoreModel.getDefault().create(project);
        }
        return EditorUtility.getEditorInputForLocation((IPath)location, cProject);
    }

    static void saveState(IMemento memento, ExternalEditorInput input) {
        IPath location = input.getPath(input);
        if (location != null) {
            memento.putString(TAG_PATH, location.toOSString());
        }
        IProject project = null;
        ITranslationUnit unit = input.getTranslationUnit();
        if (unit != null) {
            project = unit.getCProject().getProject();
        }
        if (project == null && input.getMarkerResource() instanceof IProject) {
            project = (IProject)input.getMarkerResource();
        }
        if (project != null) {
            memento.putString(TAG_PROJECT, project.getName());
        }
    }
}

