/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.util;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.PortType;

public class PartMappingUtil {
    public static List<Part> getPartsForPartMapping(Operation operation, int type, String faultName) {
        Definition definition = operation.getEnclosingDefinition();
        PortType portType = (PortType)operation.eContainer();
        if (portType == null || definition == null) {
            return Collections.emptyList();
        }
        Message message = PartMappingUtil.getMessage(operation, type, faultName);
        if (message == null) {
            return Collections.emptyList();
        }
        return PartMappingUtil.getPartsForPartMapping(operation, message, type);
    }

    private static Message getMessage(Operation operation, int type, String faultName) {
        Fault fault;
        Message message = null;
        if (type == 5) {
            Input input = operation.getEInput();
            if (input != null) {
                message = input.getEMessage();
            }
        } else if (type == 8) {
            Output output = operation.getEOutput();
            if (output != null) {
                message = output.getEMessage();
            }
        } else if (type == 3 && (fault = (Fault)operation.getFault(faultName)) != null) {
            message = fault.getEMessage();
        }
        return message;
    }

    private static List<Part> getPartsForPartMapping(Operation operation, Message message, int type) {
        EList parts = message.getEParts();
        return parts;
    }
}

