/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.ide.adapters;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.AbstractDialogHelper;
import org.eclipse.birt.report.designer.internal.ui.ide.dialog.StringVariableSelectionDialog;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class IDEResourcePageHelper
extends AbstractDialogHelper {
    public static final String WOKSPACE_BUTTON = Messages.getString((String)"IDEResourcePageHelper.WorkSpace.Button");
    public static final String FILESYSTEM_BUTTON = Messages.getString((String)"IDEResourcePageHelper.File.Button");
    public static final String VARIABLES_BUTTON = Messages.getString((String)"IDEResourcePageHelper.Varible.Button");
    private static final String DirectoryDialog_Text = Messages.getString((String)"IDEResourcePageHelper.Dialog.Title");
    private static final String DirectoryDialog_Message = Messages.getString((String)"IDEResourcePageHelper.Dialog.Prompt");
    private static final String ContainerSelectionDialog_Message = Messages.getString((String)"IDEResourcePageHelper.Dialog.Text");
    private String location = "";
    private Button fVariablesButton;
    private Button fFileSystemButton;
    private Button fWorkspaceButton;
    private Control control;
    private int butonAlignment = 0x1000008;
    private ButtonListener fListener = new ButtonListener();
    private String[] buttonLabels = new String[]{WOKSPACE_BUTTON, FILESYSTEM_BUTTON, VARIABLES_BUTTON};

    public void setButonAlignment(int butonAlignment) {
        this.butonAlignment = butonAlignment;
    }

    public void setButtonLabels(String[] buttonLabels) {
        this.buttonLabels = buttonLabels;
    }

    public void createContent(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        GridLayout layout = new GridLayout(this.buttonLabels.length, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        buttons.setLayoutData((Object)gd);
        this.control = buttons;
        this.createButtons(buttons, this.buttonLabels);
    }

    public Control getControl() {
        return this.control;
    }

    protected void createButtons(Composite parent, String[] buttonLabels) {
        Button button = this.createButton(parent, buttonLabels[0]);
        this.populateButton(button, buttonLabels[0]);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = this.butonAlignment;
        button.setLayoutData((Object)gd);
        int i = 1;
        while (i < buttonLabels.length) {
            this.populateButton(this.createButton(parent, buttonLabels[i]), buttonLabels[i]);
            ++i;
        }
    }

    private void populateButton(Button button, String label) {
        if (WOKSPACE_BUTTON.equals(label)) {
            this.fWorkspaceButton = button;
        } else if (FILESYSTEM_BUTTON.equals(label)) {
            this.fFileSystemButton = button;
        } else if (VARIABLES_BUTTON.equals(label)) {
            this.fVariablesButton = button;
        }
    }

    protected Button createButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setLayoutData((Object)new GridData());
        button.addSelectionListener((SelectionListener)this.fListener);
        StringVariableSelectionDialog.setButtonDimensionHint(button);
        return button;
    }

    protected void handleBrowseFileSystem() {
        DirectoryDialog dialog = new DirectoryDialog(this.getControl().getShell());
        dialog.setFilterPath(this.getLocation());
        dialog.setText(DirectoryDialog_Text);
        dialog.setMessage(DirectoryDialog_Message);
        String result = dialog.open();
        if (result != null) {
            this.location = result;
            result = this.replaceString(result);
            this.notifyTextChange(result);
        }
    }

    private String replaceString(String str) {
        String retValue = str.replace('\\', '/');
        if (!retValue.endsWith("/")) {
            retValue = String.valueOf(retValue) + "/";
        }
        return retValue;
    }

    protected void handleBrowseWorkspace() {
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getControl().getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), true, ContainerSelectionDialog_Message);
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            if (result.length == 0) {
                return;
            }
            IPath path = (IPath)result[0];
            this.notifyTextChange("${workspace_loc:" + path.makeRelative().toString() + "}");
        }
    }

    private void handleInsertVariable() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getControl().getShell());
        if (dialog.open() == 0) {
            this.notifyTextChange(dialog.getVariableExpression());
        }
    }

    private String getLocation() {
        return this.location;
    }

    private void notifyTextChange(String text) {
        Event event = new Event();
        event.text = text;
        List list = (List)this.listeners.get(13);
        int i = 0;
        while (i < list.size()) {
            Listener listener = (Listener)list.get(i);
            listener.handleEvent(event);
            ++i;
        }
    }

    class ButtonListener
    extends SelectionAdapter {
        ButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == IDEResourcePageHelper.this.fFileSystemButton) {
                IDEResourcePageHelper.this.handleBrowseFileSystem();
            } else if (source == IDEResourcePageHelper.this.fWorkspaceButton) {
                IDEResourcePageHelper.this.handleBrowseWorkspace();
            } else if (source == IDEResourcePageHelper.this.fVariablesButton) {
                IDEResourcePageHelper.this.handleInsertVariable();
            }
        }
    }
}

