/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.mongodb.ui.impl;

import java.util.Properties;
import org.eclipse.birt.data.oda.mongodb.impl.MongoDBDriver;
import org.eclipse.birt.data.oda.mongodb.internal.impl.MDbMetaData;
import org.eclipse.birt.data.oda.mongodb.ui.i18n.Messages;
import org.eclipse.birt.data.oda.mongodb.ui.util.UIHelper;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MongoDBDataSourcePageHelper {
    private static final String EMPTY_STRING = "";
    private WizardPage wizardPage;
    private PreferencePage propertyPage;
    private Button URIElementsRadioBtn;
    private Button URIRadioBtn;
    private Button socketAliveCheckbox;
    private Button requestSessionCheckbox;
    private Group URIElementsGroup;
    private Text serverHostText;
    private Text serverPortText;
    private Text databaseNameText;
    private Text userNameText;
    private Text passwordText;
    private Text databaseURIText;
    private boolean isPropertyPage;
    private boolean isURITextFieldFoucs;
    private boolean socketAlive;
    private boolean requestSession;
    private String dbURI;
    private String serverHost;
    private String serverPort;
    private String dbName;
    private String userName;
    private String password;
    private String DEFAULT_MESSAGE = Messages.getString("MongoDBDataSourceWizardPage.message.default");

    public MongoDBDataSourcePageHelper(WizardPage page) {
        this.wizardPage = page;
        this.isPropertyPage = false;
    }

    public MongoDBDataSourcePageHelper(PreferencePage page) {
        this.propertyPage = page;
        this.isPropertyPage = true;
    }

    public Composite createPageControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.createURIRadioButtonsArea(composite);
        this.createClientSettingsArea(composite);
        return composite;
    }

    private void createClientSettingsArea(Composite composite) {
        Group settingsGroup = new Group(composite, 0);
        settingsGroup.setText(Messages.getString("MongoDBDataSourceWizardPage.GroupTitle.SupplementalSetting"));
        settingsGroup.setLayout((Layout)new GridLayout(1, false));
        GridData groupGridData = new GridData(768);
        settingsGroup.setLayoutData((Object)groupGridData);
        this.socketAliveCheckbox = new Button((Composite)settingsGroup, 32);
        this.socketAliveCheckbox.setText(Messages.getString("MongoDBDataSourceWizardPage.checkbox.label.SocketAlive"));
        this.socketAliveCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MongoDBDataSourcePageHelper.this.socketAlive = MongoDBDataSourcePageHelper.this.socketAliveCheckbox.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.requestSessionCheckbox = new Button((Composite)settingsGroup, 32);
        this.requestSessionCheckbox.setText(Messages.getString("MongoDBDataSourceWizardPage.checkbox.label.RequestSession"));
        this.requestSessionCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MongoDBDataSourcePageHelper.this.requestSession = MongoDBDataSourcePageHelper.this.requestSessionCheckbox.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createURIRadioButtonsArea(Composite composite) {
        Composite URIComposite1 = new Composite(composite, 0);
        URIComposite1.setLayout((Layout)new GridLayout(2, false));
        URIComposite1.setLayoutData((Object)new GridData(768));
        this.URIElementsRadioBtn = new Button(URIComposite1, 16);
        GridData radioBtnData = new GridData();
        radioBtnData.verticalAlignment = 128;
        this.URIElementsRadioBtn.setLayoutData((Object)radioBtnData);
        this.URIElementsRadioBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (MongoDBDataSourcePageHelper.this.URIElementsRadioBtn.getSelection()) {
                    MongoDBDataSourcePageHelper.this.isURITextFieldFoucs = false;
                    MongoDBDataSourcePageHelper.this.handleRadioButtonSelection();
                    MongoDBDataSourcePageHelper.this.validatePageProperties();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.URIElementsGroup = new Group(URIComposite1, 0);
        this.URIElementsGroup.setText(Messages.getString("MongoDBDataSourceWizardPage.GroupTitle.URIElements"));
        this.URIElementsGroup.setLayout((Layout)new GridLayout(2, false));
        GridData groupGridData = new GridData(768);
        this.URIElementsGroup.setLayoutData((Object)groupGridData);
        Label serverHostLabel = new Label((Composite)this.URIElementsGroup, 0);
        serverHostLabel.setText(Messages.getString("MongoDBDataSourceWizardPage.text.label.ServerHost"));
        this.serverHostText = new Text((Composite)this.URIElementsGroup, 2048);
        this.serverHostText.setLayoutData((Object)new GridData(768));
        this.serverHostText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MongoDBDataSourcePageHelper.this.serverHost = MongoDBDataSourcePageHelper.this.serverHostText.getText().trim();
                MongoDBDataSourcePageHelper.this.validatePageProperties();
            }
        });
        Label serverPortLabel = new Label((Composite)this.URIElementsGroup, 0);
        serverPortLabel.setText(Messages.getString("MongoDBDataSourceWizardPage.text.label.ServerPort"));
        this.serverPortText = new Text((Composite)this.URIElementsGroup, 2048);
        this.serverPortText.setLayoutData((Object)new GridData(768));
        this.serverPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MongoDBDataSourcePageHelper.this.serverPort = MongoDBDataSourcePageHelper.this.serverPortText.getText().trim();
                MongoDBDataSourcePageHelper.this.validatePageProperties();
            }
        });
        Label databaseNameLabel = new Label((Composite)this.URIElementsGroup, 0);
        databaseNameLabel.setText(Messages.getString("MongoDBDataSourceWizardPage.text.label.DatabaseName"));
        this.databaseNameText = new Text((Composite)this.URIElementsGroup, 2048);
        this.databaseNameText.setLayoutData((Object)new GridData(768));
        this.databaseNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MongoDBDataSourcePageHelper.this.dbName = MongoDBDataSourcePageHelper.this.databaseNameText.getText().trim();
                MongoDBDataSourcePageHelper.this.validatePageProperties();
            }
        });
        Label userNameLabel = new Label((Composite)this.URIElementsGroup, 0);
        userNameLabel.setText(Messages.getString("MongoDBDataSourceWizardPage.text.label.UserName"));
        this.userNameText = new Text((Composite)this.URIElementsGroup, 2048);
        this.userNameText.setLayoutData((Object)new GridData(768));
        this.userNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MongoDBDataSourcePageHelper.this.userName = MongoDBDataSourcePageHelper.this.userNameText.getText().trim();
                MongoDBDataSourcePageHelper.this.validatePageProperties();
            }
        });
        Label passwordLabel = new Label((Composite)this.URIElementsGroup, 0);
        passwordLabel.setText(Messages.getString("MongoDBDataSourceWizardPage.text.label.Password"));
        this.passwordText = new Text((Composite)this.URIElementsGroup, 0x400800);
        this.passwordText.setLayoutData((Object)new GridData(768));
        this.passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MongoDBDataSourcePageHelper.this.password = MongoDBDataSourcePageHelper.this.passwordText.getText().trim();
                MongoDBDataSourcePageHelper.this.validatePageProperties();
            }
        });
        Composite URIComposite2 = new Composite(composite, 0);
        URIComposite2.setLayout((Layout)new GridLayout(2, false));
        URIComposite2.setLayoutData((Object)new GridData(768));
        this.URIRadioBtn = new Button(URIComposite2, 16);
        this.URIRadioBtn.setText(Messages.getString("MongoDBDataSourceWizardPage.RadioButton.label.DatabaseURI"));
        this.URIRadioBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (MongoDBDataSourcePageHelper.this.URIRadioBtn.getSelection()) {
                    MongoDBDataSourcePageHelper.this.isURITextFieldFoucs = true;
                    MongoDBDataSourcePageHelper.this.handleRadioButtonSelection();
                    MongoDBDataSourcePageHelper.this.dbURI = MongoDBDataSourcePageHelper.this.databaseURIText.getText().trim();
                    MongoDBDataSourcePageHelper.this.validatePageProperties();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.databaseURIText = new Text(URIComposite2, 2048);
        this.databaseURIText.setLayoutData((Object)new GridData(768));
        this.databaseURIText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MongoDBDataSourcePageHelper.this.dbURI = MongoDBDataSourcePageHelper.this.databaseURIText.getText().trim();
                MongoDBDataSourcePageHelper.this.validatePageProperties();
            }
        });
    }

    private void handleRadioButtonSelection() {
        this.URIElementsRadioBtn.setSelection(!this.isURITextFieldFoucs);
        this.URIRadioBtn.setSelection(this.isURITextFieldFoucs);
        this.resetURIEditControlStatus();
    }

    protected void resetURIEditControlStatus() {
        if (this.databaseURIText != null && !this.databaseURIText.isDisposed()) {
            this.setURIElementsGroupEnabled(!this.isURITextFieldFoucs);
            this.databaseURIText.setEnabled(this.isURITextFieldFoucs);
        }
    }

    private void setURIElementsGroupEnabled(boolean enabled) {
        this.URIElementsGroup.setEnabled(enabled);
        Control[] children = this.URIElementsGroup.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].setEnabled(enabled);
            ++i;
        }
    }

    protected void initPageInfos(Properties dataSourceProps) {
        boolean ignoreURI;
        if (dataSourceProps == null) {
            return;
        }
        this.dbURI = dataSourceProps.getProperty(MongoDBDriver.MONGO_URI_PROP);
        this.serverHost = dataSourceProps.getProperty(MongoDBDriver.SERVER_HOST_PROP);
        this.serverPort = dataSourceProps.getProperty(MongoDBDriver.SERVER_PORT_PROP);
        if (this.serverPort == null || this.serverPort.trim().length() == 0) {
            this.serverPort = String.valueOf(MDbMetaData.defaultPort());
        }
        this.dbName = dataSourceProps.getProperty(MongoDBDriver.DBNAME_PROP);
        this.userName = dataSourceProps.getProperty(MongoDBDriver.USERNAME_PROP);
        this.password = dataSourceProps.getProperty(MongoDBDriver.PASSWORD_PROP);
        boolean bl = this.isURITextFieldFoucs = !UIHelper.isEmptyString(this.dbURI);
        if (this.isURITextFieldFoucs && (ignoreURI = Boolean.valueOf(dataSourceProps.getProperty(MongoDBDriver.IGNORE_URI_PROP)).booleanValue())) {
            this.isURITextFieldFoucs = false;
        }
        this.socketAlive = dataSourceProps.getProperty(MongoDBDriver.SOCKET_KEEP_ALIVE_PROP) != null ? Boolean.parseBoolean(dataSourceProps.getProperty(MongoDBDriver.SOCKET_KEEP_ALIVE_PROP)) : false;
        this.requestSession = dataSourceProps.getProperty(MongoDBDriver.REQUEST_SESSION_PROP) != null ? Boolean.parseBoolean(dataSourceProps.getProperty(MongoDBDriver.REQUEST_SESSION_PROP)) : false;
    }

    public void initPageControls(Properties dataSourceProps) {
        if (dataSourceProps == null) {
            return;
        }
        this.initPageInfos(dataSourceProps);
        this.refreshPageControls();
        this.validatePageProperties();
    }

    protected void refresh() {
        if (this.databaseURIText != null && !this.databaseURIText.isDisposed()) {
            this.refreshPageControls();
            this.validatePageProperties();
        }
    }

    protected void refreshPageControls() {
        this.databaseURIText.setText(this.dbURI == null ? EMPTY_STRING : this.dbURI);
        this.serverHostText.setText(this.serverHost == null ? EMPTY_STRING : this.serverHost);
        if (this.serverPort != null) {
            this.serverPortText.setText(this.serverPort);
        } else {
            this.serverPortText.setText(String.valueOf(MDbMetaData.defaultPort()));
        }
        this.databaseNameText.setText(this.dbName == null ? EMPTY_STRING : this.dbName);
        this.userNameText.setText(this.userName == null ? EMPTY_STRING : this.userName);
        this.passwordText.setText(this.password == null ? EMPTY_STRING : this.password);
        this.handleRadioButtonSelection();
        this.socketAliveCheckbox.setSelection(this.socketAlive);
        this.requestSessionCheckbox.setSelection(this.requestSession);
        if (this.isURITextFieldFoucs) {
            this.databaseURIText.setFocus();
        } else {
            this.serverHostText.setFocus();
        }
    }

    private boolean validatePageProperties() {
        boolean isValid = true;
        if (this.URIRadioBtn.getSelection() || this.isURITextFieldFoucs) {
            if (this.databaseURIText.getText().trim().length() == 0) {
                isValid = false;
            }
        } else if (this.serverHostText.getText().trim().length() == 0 || this.serverPortText.getText().trim().length() == 0 || this.databaseNameText.getText().trim().length() == 0) {
            isValid = false;
        }
        if (!isValid) {
            if (this.isPropertyPage) {
                this.propertyPage.setMessage(Messages.getString("MongoDBDataSourceWizardPage.error.MissingConnectionProperty"), 3);
            } else {
                this.wizardPage.setMessage(Messages.getString("MongoDBDataSourceWizardPage.error.MissingConnectionProperty"), 3);
            }
        } else if (this.isPropertyPage) {
            this.propertyPage.setMessage(this.DEFAULT_MESSAGE);
        } else {
            this.wizardPage.setMessage(this.DEFAULT_MESSAGE);
        }
        if (this.wizardPage != null) {
            this.wizardPage.setPageComplete(isValid);
        }
        return isValid;
    }

    protected Properties collectCustomProperties(Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        if (this.serverHost != null) {
            properties.setProperty(MongoDBDriver.SERVER_HOST_PROP, this.serverHost);
        }
        if (this.serverPort != null) {
            properties.setProperty(MongoDBDriver.SERVER_PORT_PROP, this.serverPort);
        }
        if (this.dbName != null) {
            properties.setProperty(MongoDBDriver.DBNAME_PROP, this.dbName);
        }
        if (this.userName != null) {
            properties.setProperty(MongoDBDriver.USERNAME_PROP, this.userName);
        }
        if (this.password != null) {
            properties.setProperty(MongoDBDriver.PASSWORD_PROP, this.password);
        }
        if (this.dbURI != null) {
            properties.setProperty(MongoDBDriver.MONGO_URI_PROP, this.dbURI);
        }
        properties.setProperty(MongoDBDriver.IGNORE_URI_PROP, Boolean.toString(this.URIElementsRadioBtn.getSelection() || UIHelper.isEmptyString(this.dbURI)));
        properties.setProperty(MongoDBDriver.SOCKET_KEEP_ALIVE_PROP, String.valueOf(this.socketAlive));
        properties.setProperty(MongoDBDriver.REQUEST_SESSION_PROP, String.valueOf(this.requestSession));
        return properties;
    }

    protected void setFocus() {
        if (this.isURITextFieldFoucs) {
            this.databaseURIText.setFocus();
        } else {
            this.serverHostText.setFocus();
        }
    }
}

