/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.builders.prefs;

import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.builders.AcceleoBuilderSettings;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;

public class AcceleoCompilerPage
extends PreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private IAdaptable element;
    private Button strictCompliance;
    private Button xmiResourceButton;
    private Button binaryResourceButton;
    private Button trimmedPositionButton;
    private Button platformResourceButton;
    private Button absolutePathButton;

    public AcceleoCompilerPage() {
        this.setDescription(AcceleoUIMessages.getString("AcceleoCompilerPage.Description"));
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        if (this.element instanceof IProject) {
            final IProject project = (IProject)this.element;
            AcceleoBuilderSettings settings = new AcceleoBuilderSettings(project);
            if (this.strictCompliance.getSelection()) {
                settings.setCompliance("strict");
            } else {
                settings.setCompliance("pragmatic");
            }
            if (this.xmiResourceButton.getSelection()) {
                settings.setResourceKind("xmi");
            } else {
                settings.setResourceKind("binary");
            }
            if (this.platformResourceButton.getSelection()) {
                settings.setCompilationKind("compilation.platform.resource");
            } else {
                settings.setCompilationKind("compilation.absolute.path");
            }
            settings.setTrimmedPositions(this.trimmedPositionButton.getSelection());
            try {
                settings.save();
            }
            catch (CoreException e) {
                AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
            }
            Job job = new Job(AcceleoUIMessages.getString("AcceleoCompilerPage.BuildingProject", project.getName())){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        project.build(6, monitor);
                    }
                    catch (CoreException e) {
                        AcceleoUIActivator.log((Exception)((Object)e), true);
                        return new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        return super.performOk();
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.createResourceKindGroup(composite);
        this.createComplianceGroup(composite);
        this.createTrimmmedPositionGroup(composite);
        this.createCompilationPathGroup(composite);
        return composite;
    }

    private void createComplianceGroup(Composite parent) {
        this.strictCompliance = new Button(parent, 32);
        this.strictCompliance.setText(AcceleoUIMessages.getString("AcceleoCompilerPage.StrictMTLCompliance"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.strictCompliance.setLayoutData((Object)gridData);
        if (this.element instanceof IProject) {
            IProject project = (IProject)this.element;
            AcceleoBuilderSettings settings = new AcceleoBuilderSettings(project);
            if ("strict".equals(settings.getCompliance())) {
                this.strictCompliance.setSelection(true);
            } else if ("pragmatic".equals(settings.getCompliance())) {
                this.strictCompliance.setSelection(false);
            } else {
                this.strictCompliance.setSelection(false);
            }
        } else {
            this.strictCompliance.setSelection(false);
        }
        Image image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_LCL_LINKTO_HELP");
        ToolBar result = new ToolBar(parent, 0x880000);
        result.setLayoutData((Object)new GridData(64));
        ToolItem item = new ToolItem(result, 0);
        item.setImage(image);
        String helpMessage = AcceleoUIMessages.getString("AcceleoCompilerPage.StrictMTLComplianceHelp");
        if (helpMessage != null && !"".equals(helpMessage)) {
            item.setToolTipText(helpMessage);
        }
    }

    private void createResourceKindGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        group.setText(AcceleoUIMessages.getString("AcceleoCompilerPage.ResourceKind"));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        layout.numColumns = 1;
        this.binaryResourceButton = new Button((Composite)group, 16);
        this.binaryResourceButton.setText(AcceleoUIMessages.getString("AcceleoCompilerPage.BinaryResourceKind"));
        this.binaryResourceButton.setLayoutData((Object)new GridData());
        this.xmiResourceButton = new Button((Composite)group, 16);
        this.xmiResourceButton.setText(AcceleoUIMessages.getString("AcceleoCompilerPage.XMIResourceKind"));
        this.xmiResourceButton.setLayoutData((Object)new GridData());
        if (this.element instanceof IProject) {
            IProject project = (IProject)this.element;
            AcceleoBuilderSettings settings = new AcceleoBuilderSettings(project);
            if ("xmi".equals(settings.getResourceKind())) {
                this.xmiResourceButton.setSelection(true);
                this.binaryResourceButton.setSelection(false);
            } else if ("binary".equals(settings.getResourceKind())) {
                this.xmiResourceButton.setSelection(false);
                this.binaryResourceButton.setSelection(true);
            } else {
                this.xmiResourceButton.setSelection(false);
                this.binaryResourceButton.setSelection(true);
            }
        } else {
            this.xmiResourceButton.setSelection(false);
            this.binaryResourceButton.setSelection(true);
        }
        Image image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_LCL_LINKTO_HELP");
        ToolBar result = new ToolBar(parent, 0x880000);
        result.setLayoutData((Object)new GridData(64));
        ToolItem item = new ToolItem(result, 0);
        item.setImage(image);
        String helpMessage = AcceleoUIMessages.getString("AcceleoCompilerPage.ResourceSerialization");
        if (helpMessage != null && !"".equals(helpMessage)) {
            item.setToolTipText(helpMessage);
        }
    }

    private void createTrimmmedPositionGroup(Composite parent) {
        this.trimmedPositionButton = new Button(parent, 32);
        this.trimmedPositionButton.setText(AcceleoUIMessages.getString("AcceleoCompilerPage.TrimmedPosition"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.trimmedPositionButton.setLayoutData((Object)gridData);
        if (this.element instanceof IProject) {
            IProject project = (IProject)this.element;
            AcceleoBuilderSettings settings = new AcceleoBuilderSettings(project);
            this.trimmedPositionButton.setSelection(settings.isTrimmedPositions());
        } else {
            this.trimmedPositionButton.setSelection(false);
        }
        Image image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_LCL_LINKTO_HELP");
        ToolBar result = new ToolBar(parent, 0x880000);
        result.setLayoutData((Object)new GridData(64));
        ToolItem item = new ToolItem(result, 0);
        item.setImage(image);
        String helpMessage = AcceleoUIMessages.getString("AcceleoCompilerPage.TrimmedPositionHelp");
        if (helpMessage != null && !"".equals(helpMessage)) {
            item.setToolTipText(helpMessage);
        }
    }

    private void createCompilationPathGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        group.setText(AcceleoUIMessages.getString("AcceleoCompilerPage.CompilationKind"));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        layout.numColumns = 1;
        this.platformResourceButton = new Button((Composite)group, 16);
        this.platformResourceButton.setText(AcceleoUIMessages.getString("AcceleoCompilerPage.PlatformResourcePath"));
        this.platformResourceButton.setLayoutData((Object)new GridData());
        this.absolutePathButton = new Button((Composite)group, 16);
        this.absolutePathButton.setText(AcceleoUIMessages.getString("AcceleoCompilerPage.AbsolutePath"));
        this.absolutePathButton.setLayoutData((Object)new GridData());
        if (this.element instanceof IProject) {
            IProject project = (IProject)this.element;
            AcceleoBuilderSettings settings = new AcceleoBuilderSettings(project);
            if ("compilation.absolute.path".equals(settings.getCompilationKind())) {
                this.absolutePathButton.setSelection(true);
                this.platformResourceButton.setSelection(false);
            } else if ("compilation.platform.resource".equals(settings.getCompilationKind())) {
                this.absolutePathButton.setSelection(false);
                this.platformResourceButton.setSelection(true);
            } else {
                this.absolutePathButton.setSelection(true);
                this.platformResourceButton.setSelection(false);
            }
        } else {
            this.absolutePathButton.setSelection(true);
            this.platformResourceButton.setSelection(false);
        }
        Image image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_LCL_LINKTO_HELP");
        ToolBar result = new ToolBar(parent, 0x880000);
        result.setLayoutData((Object)new GridData(64));
        ToolItem item = new ToolItem(result, 0);
        item.setImage(image);
        String helpMessage = AcceleoUIMessages.getString("AcceleoCompilerPage.CompilationPathHelp");
        if (helpMessage != null && !"".equals(helpMessage)) {
            item.setToolTipText(helpMessage);
        }
    }
}

