/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.transaction.xa.XAException;
import org.apache.derby.client.am.ClientBlob;
import org.apache.derby.client.am.ClientCallableStatement;
import org.apache.derby.client.am.ClientClob;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientDatabaseMetaData;
import org.apache.derby.client.am.ClientPreparedStatement;
import org.apache.derby.client.am.ClientResultSet;
import org.apache.derby.client.am.ClientStatement;
import org.apache.derby.client.am.ColumnMetaData;
import org.apache.derby.client.am.ExceptionFormatter;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.am.Version;
import org.apache.derby.jdbc.BasicClientDataSource40;

public class LogWriter {
    protected final PrintWriter printWriter_;
    private final int traceLevel_;
    private boolean driverConfigurationHasBeenWrittenToJdbc1Stream_ = false;
    private boolean driverConfigurationHasBeenWrittenToJdbc2Stream_ = false;
    public boolean printWriterNeedsToBeClosed_;

    public LogWriter(PrintWriter printWriter, int n) {
        this.printWriter_ = printWriter;
        this.traceLevel_ = n;
    }

    protected final boolean loggingEnabled(int n) {
        return (n & this.traceLevel_) != 0;
    }

    void close() {
        if (this.printWriterNeedsToBeClosed_) {
            this.printWriter_.close();
            this.printWriterNeedsToBeClosed_ = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dncprintln(String string) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.printWriter_.println("[derby] " + string);
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dncprint(String string) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.printWriter_.print("[derby] " + string);
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dncprintln(String string, String string2) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.printWriter_.println("[derby]" + string + " " + string2);
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dncprint(String string, String string2) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.printWriter_.print("[derby]" + string + " " + string2);
            this.printWriter_.flush();
        }
    }

    public void tracepoint(String string, int n, String string2, String string3) {
        String string4 = string + "[time:" + System.currentTimeMillis() + "]" + "[thread:" + Thread.currentThread().getName() + "]" + "[tracepoint:" + n + "]" + "[" + string2 + "." + string3 + "]";
        this.dncprintln(string4);
    }

    private void traceExternalMethod(Object object, String string, String string2) {
        this.dncprint(this.buildExternalMethodHeader(object, string), string2);
    }

    private void traceExternalDeprecatedMethod(Object object, String string, String string2) {
        this.dncprint(this.buildExternalMethodHeader(object, string), "Deprecated " + string2);
    }

    private String buildExternalMethodHeader(Object object, String string) {
        return "[Time:" + System.currentTimeMillis() + "]" + "[Thread:" + Thread.currentThread().getName() + "]" + "[" + string + "@" + Integer.toHexString(object.hashCode()) + "]";
    }

    private String getClassNameOfInstanceIfTraced(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ClientConnection && this.loggingEnabled(1)) {
            return "ClientConnection";
        }
        if (object instanceof ClientResultSet && this.loggingEnabled(4)) {
            return "ClientResultSet";
        }
        if (object instanceof ClientCallableStatement && this.loggingEnabled(2)) {
            return "ClientCallableStatement";
        }
        if (object instanceof ClientPreparedStatement && this.loggingEnabled(2)) {
            return "ClientPreparedStatement";
        }
        if (object instanceof ClientStatement && this.loggingEnabled(2)) {
            return "ClientStatement";
        }
        if (object instanceof ClientBlob && this.loggingEnabled(-1)) {
            return "ClientBlob";
        }
        if (object instanceof ClientClob && this.loggingEnabled(-1)) {
            return "ClientClob";
        }
        if (object instanceof ClientDatabaseMetaData && this.loggingEnabled(-1)) {
            return "ClientDatabaseMetaData";
        }
        if (this.loggingEnabled(2048) && object.getClass().getName().startsWith("org.apache.derby.client.net.NetXAResource")) {
            return "NetXAResource";
        }
        if (this.loggingEnabled(-1) && object.getClass().getName().equals("org.apache.derby.client.ClientPooledConnection")) {
            return "ClientPooledConnection";
        }
        if (this.loggingEnabled(-1) && object.getClass().getName().equals("org.apache.derby.jdbc.ClientConnectionPoolDataSource")) {
            return "ClientConnectionPoolDataSource";
        }
        if (this.loggingEnabled(-1) && object.getClass().getName().equals("org.apache.derby.client.ClientXAConnection")) {
            return "ClientXAConnection";
        }
        if (this.loggingEnabled(-1) && object.getClass().getName().equals("org.apache.derby.jdbc.ClientDataSource")) {
            return "ClientDataSource";
        }
        if (this.loggingEnabled(-1) && object.getClass().getName().equals("org.apache.derby.jdbc.ClientXADataSource")) {
            return "ClientXADataSource";
        }
        return object.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceExit(Object object, String string, Object object2) {
        String string2 = this.getClassNameOfInstanceIfTraced(object);
        if (string2 == null) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.traceExternalMethod(object, string2, string);
            this.printWriter_.println(" () returned " + object2);
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void traceDeprecatedExit(Object object, String string, Object object2) {
        String string2 = this.getClassNameOfInstanceIfTraced(object);
        if (string2 == null) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.traceExternalDeprecatedMethod(object, string2, string);
            this.printWriter_.println(" () returned " + object2);
            this.printWriter_.flush();
        }
    }

    void traceExit(Object object, String string, ClientResultSet clientResultSet) {
        String string2 = clientResultSet == null ? "ResultSet@null" : "ResultSet@" + Integer.toHexString(clientResultSet.hashCode());
        this.traceExit(object, string, string2);
    }

    void traceExit(Object object, String string, ClientStatement clientStatement) {
        this.traceExit(object, string, "Statement@" + Integer.toHexString(clientStatement.hashCode()));
    }

    void traceExit(Object object, String string, ClientBlob clientBlob) {
        String string2 = clientBlob == null ? "Blob@null" : "Blob@" + Integer.toHexString(clientBlob.hashCode());
        this.traceExit(object, string, string2);
    }

    void traceExit(Object object, String string, ClientClob clientClob) {
        String string2 = clientClob == null ? "Clob@null" : "Clob@" + Integer.toHexString(clientClob.hashCode());
        this.traceExit(object, string, string2);
    }

    void traceExit(Object object, String string, ClientDatabaseMetaData clientDatabaseMetaData) {
        this.traceExit(object, string, "DatabaseMetaData@" + Integer.toHexString(clientDatabaseMetaData.hashCode()));
    }

    void traceExit(Object object, String string, ClientConnection clientConnection) {
        this.traceExit(object, string, "Connection@" + Integer.toHexString(clientConnection.hashCode()));
    }

    void traceExit(Object object, String string, ColumnMetaData columnMetaData) {
        this.traceExit(object, string, "MetaData@" + (columnMetaData != null ? Integer.toHexString(columnMetaData.hashCode()) : null));
    }

    void traceExit(Object object, String string, byte[] byArray) {
        this.traceExit(object, string, Utils.getStringFromBytes(byArray));
    }

    void traceExit(Object object, String string, byte by) {
        this.traceExit(object, string, "0x" + Integer.toHexString(by & 0xFF));
    }

    public void traceEntry(Object object, String string, Object ... objectArray) {
        this.traceEntryAllArgs(object, string, false, objectArray);
    }

    public void traceDeprecatedEntry(Object object, String string, Object ... objectArray) {
        this.traceEntryAllArgs(object, string, true, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceEntryAllArgs(Object object, String string, boolean bl, Object[] objectArray) {
        String string2 = this.getClassNameOfInstanceIfTraced(object);
        if (string2 == null) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            if (bl) {
                this.traceExternalDeprecatedMethod(object, string2, string);
            } else {
                this.traceExternalMethod(object, string2, string);
            }
            this.printWriter_.print(" (");
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    this.printWriter_.print(", ");
                }
                this.printWriter_.print(LogWriter.toPrintableString(objectArray[i]));
            }
            this.printWriter_.println(") called");
            this.printWriter_.flush();
        }
    }

    private static String toPrintableString(Object object) {
        if (object instanceof byte[]) {
            return Utils.getStringFromBytes((byte[])object);
        }
        if (object instanceof Byte) {
            return "0x" + Integer.toHexString((Byte)object & 0xFF);
        }
        return String.valueOf(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void traceDiagnosable(SqlException sqlException) {
        if (!this.loggingEnabled(512)) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.dncprintln("BEGIN TRACE_DIAGNOSTICS");
            ExceptionFormatter.printTrace(sqlException, this.printWriter_, "[derby]", true);
            this.dncprintln("END TRACE_DIAGNOSTICS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceDiagnosable(SQLException sQLException) {
        if (!this.loggingEnabled(512)) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.dncprintln("BEGIN TRACE_DIAGNOSTICS");
            ExceptionFormatter.printTrace(sQLException, this.printWriter_, "[derby]", true);
            this.dncprintln("END TRACE_DIAGNOSTICS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void traceDiagnosable(XAException xAException) {
        if (!this.loggingEnabled(512)) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.dncprintln("BEGIN TRACE_DIAGNOSTICS");
            ExceptionFormatter.printTrace(xAException, this.printWriter_, "[derby]");
            this.dncprintln("END TRACE_DIAGNOSTICS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void traceParameterMetaData(ClientStatement clientStatement, ColumnMetaData columnMetaData) {
        if (!this.loggingEnabled(256) || columnMetaData == null) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            String string = "[ParameterMetaData@" + Integer.toHexString(columnMetaData.hashCode()) + "]";
            try {
                this.dncprintln(string, "BEGIN TRACE_PARAMETER_META_DATA");
                this.dncprintln(string, "Parameter meta data for statement Statement@" + Integer.toHexString(clientStatement.hashCode()));
                this.dncprintln(string, "Number of parameter columns: " + columnMetaData.getColumnCount());
                this.traceColumnMetaData(string, columnMetaData);
                this.dncprintln(string, "END TRACE_PARAMETER_META_DATA");
            }
            catch (SQLException sQLException) {
                this.dncprintln(string, "Encountered an SQL exception while trying to trace parameter meta data");
                this.dncprintln(string, "END TRACE_PARAMETER_META_DATA");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void traceResultSetMetaData(ClientStatement clientStatement, ColumnMetaData columnMetaData) {
        if (!this.loggingEnabled(128) || columnMetaData == null) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            String string = "[ResultSetMetaData@" + Integer.toHexString(columnMetaData.hashCode()) + "]";
            try {
                this.dncprintln(string, "BEGIN TRACE_RESULT_SET_META_DATA");
                this.dncprintln(string, "Result set meta data for statement Statement@" + Integer.toHexString(clientStatement.hashCode()));
                this.dncprintln(string, "Number of result set columns: " + columnMetaData.getColumnCount());
                this.traceColumnMetaData(string, columnMetaData);
                this.dncprintln(string, "END TRACE_RESULT_SET_META_DATA");
            }
            catch (SQLException sQLException) {
                this.dncprintln(string, "Encountered an SQL exception while trying to trace result set meta data");
                this.dncprintln(string, "END TRACE_RESULT_SET_META_DATA");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceColumnMetaData(String string, ColumnMetaData columnMetaData) {
        try {
            PrintWriter printWriter = this.printWriter_;
            synchronized (printWriter) {
                for (int i = 1; i <= columnMetaData.getColumnCount(); ++i) {
                    this.dncprint(string, "Column " + i + ": { ");
                    this.printWriter_.print("label=" + columnMetaData.getColumnLabel(i) + ", ");
                    this.printWriter_.print("name=" + columnMetaData.getColumnName(i) + ", ");
                    this.printWriter_.print("type name=" + columnMetaData.getColumnTypeName(i) + ", ");
                    this.printWriter_.print("type=" + columnMetaData.getColumnType(i) + ", ");
                    this.printWriter_.print("nullable=" + columnMetaData.isNullable(i) + ", ");
                    this.printWriter_.print("precision=" + columnMetaData.getPrecision(i) + ", ");
                    this.printWriter_.print("scale=" + columnMetaData.getScale(i) + ", ");
                    this.printWriter_.print("schema name=" + columnMetaData.getSchemaName(i) + ", ");
                    this.printWriter_.print("table name=" + columnMetaData.getTableName(i) + ", ");
                    this.printWriter_.print("writable=" + columnMetaData.isWritable(i) + ", ");
                    this.printWriter_.print("sqlPrecision=" + (columnMetaData.sqlPrecision_ == null ? "<null>" : "" + columnMetaData.sqlPrecision_[i - 1]) + ", ");
                    this.printWriter_.print("sqlScale=" + (columnMetaData.sqlScale_ == null ? "<null>" : "" + columnMetaData.sqlScale_[i - 1]) + ", ");
                    this.printWriter_.print("sqlLength=" + (columnMetaData.sqlLength_ == null ? "<null>" : "" + columnMetaData.sqlLength_[i - 1]) + ", ");
                    this.printWriter_.print("sqlType=" + (columnMetaData.sqlType_ == null ? "<null>" : "" + columnMetaData.sqlType_[i - 1]) + ", ");
                    this.printWriter_.print("sqlCcsid=" + (columnMetaData.sqlCcsid_ == null ? "<null>" : "" + columnMetaData.sqlCcsid_[i - 1]) + ", ");
                    this.printWriter_.print("sqlName=" + (columnMetaData.sqlName_ == null ? "<null>" : columnMetaData.sqlName_[i - 1]) + ", ");
                    this.printWriter_.print("sqlLabel=" + (columnMetaData.sqlLabel_ == null ? "<null>" : columnMetaData.sqlLabel_[i - 1]) + ", ");
                    this.printWriter_.print("sqlUnnamed=" + (columnMetaData.sqlUnnamed_ == null ? "<null>" : "" + columnMetaData.sqlUnnamed_[i - 1]) + ", ");
                    this.printWriter_.print("sqlComment=" + (columnMetaData.sqlComment_ == null ? "<null>" : columnMetaData.sqlComment_[i - 1]) + ", ");
                    this.printWriter_.print("sqlxKeymem=" + (columnMetaData.sqlxKeymem_ == null ? "<null>" : "" + columnMetaData.sqlxKeymem_[i - 1]) + ", ");
                    this.printWriter_.print("sqlxGenerated=" + (columnMetaData.sqlxGenerated_ == null ? "<null>" : "" + columnMetaData.sqlxGenerated_[i - 1]) + ", ");
                    this.printWriter_.print("sqlxParmmode=" + (columnMetaData.sqlxParmmode_ == null ? "<null>" : "" + columnMetaData.sqlxParmmode_[i - 1]) + ", ");
                    this.printWriter_.print("sqlxCorname=" + (columnMetaData.sqlxCorname_ == null ? "<null>" : columnMetaData.sqlxCorname_[i - 1]) + ", ");
                    this.printWriter_.print("sqlxName=" + (columnMetaData.sqlxName_ == null ? "<null>" : columnMetaData.sqlxName_[i - 1]) + ", ");
                    this.printWriter_.print("sqlxBasename=" + (columnMetaData.sqlxBasename_ == null ? "<null>" : columnMetaData.sqlxBasename_[i - 1]) + ", ");
                    this.printWriter_.print("sqlxUpdatable=" + (columnMetaData.sqlxUpdatable_ == null ? "<null>" : "" + columnMetaData.sqlxUpdatable_[i - 1]) + ", ");
                    this.printWriter_.print("sqlxSchema=" + (columnMetaData.sqlxSchema_ == null ? "<null>" : columnMetaData.sqlxSchema_[i - 1]) + ", ");
                    this.printWriter_.print("sqlxRdbnam=" + (columnMetaData.sqlxRdbnam_ == null ? "<null>" : columnMetaData.sqlxRdbnam_[i - 1]) + ", ");
                    this.printWriter_.print("internal type=" + columnMetaData.types_[i - 1] + ", ");
                    this.printWriter_.println(" }");
                }
                this.dncprint(string, "{ ");
                this.printWriter_.print("sqldHold=" + columnMetaData.sqldHold_ + ", ");
                this.printWriter_.print("sqldReturn=" + columnMetaData.sqldReturn_ + ", ");
                this.printWriter_.print("sqldScroll=" + columnMetaData.sqldScroll_ + ", ");
                this.printWriter_.print("sqldSensitive=" + columnMetaData.sqldSensitive_ + ", ");
                this.printWriter_.print("sqldFcode=" + columnMetaData.sqldFcode_ + ", ");
                this.printWriter_.print("sqldKeytype=" + columnMetaData.sqldKeytype_ + ", ");
                this.printWriter_.print("sqldRdbnam=" + columnMetaData.sqldRdbnam_ + ", ");
                this.printWriter_.print("sqldSchema=" + columnMetaData.sqldSchema_);
                this.printWriter_.println(" }");
                this.printWriter_.flush();
            }
        }
        catch (SQLException sQLException) {
            this.dncprintln(string, "Encountered an SQL exception while trying to trace column meta data");
        }
    }

    void traceConnectEntry(BasicClientDataSource40 basicClientDataSource40) {
        if (this.loggingEnabled(16)) {
            this.traceDriverConfigurationJdbc2();
        }
        if (this.loggingEnabled(32)) {
            this.traceConnectsEntry(basicClientDataSource40);
        }
    }

    void traceConnectEntry(String string, int n, String string2, Properties properties) {
        if (this.loggingEnabled(16)) {
            this.traceDriverConfigurationJdbc1();
        }
        if (this.loggingEnabled(32)) {
            this.traceConnectsEntry(string, n, string2, properties);
        }
    }

    void traceConnectResetEntry(Object object, LogWriter logWriter, String string, BasicClientDataSource40 basicClientDataSource40) {
        this.traceEntry(object, "reset", logWriter, string, "<escaped>", basicClientDataSource40);
        if (this.loggingEnabled(32)) {
            this.traceConnectsResetEntry(basicClientDataSource40);
        }
    }

    void traceConnectExit(ClientConnection clientConnection) {
        if (this.loggingEnabled(32)) {
            this.traceConnectsExit(clientConnection);
        }
    }

    public void traceConnectResetExit(ClientConnection clientConnection) {
        if (this.loggingEnabled(32)) {
            this.traceConnectsResetExit(clientConnection);
        }
    }

    private void traceConnectsResetEntry(BasicClientDataSource40 basicClientDataSource40) {
        try {
            this.traceConnectsResetEntry(basicClientDataSource40.getServerName(), basicClientDataSource40.getPortNumber(), basicClientDataSource40.getDatabaseName(), this.getProperties(basicClientDataSource40));
        }
        catch (SqlException sqlException) {
            this.dncprintln("Encountered an SQL exception while trying to trace connection reset entry");
        }
    }

    private void traceConnectsEntry(BasicClientDataSource40 basicClientDataSource40) {
        try {
            this.traceConnectsEntry(basicClientDataSource40.getServerName(), basicClientDataSource40.getPortNumber(), basicClientDataSource40.getDatabaseName(), this.getProperties(basicClientDataSource40));
        }
        catch (SqlException sqlException) {
            this.dncprintln("Encountered an SQL exception while trying to trace connection entry");
        }
    }

    private void traceConnectsResetEntry(String string, int n, String string2, Properties properties) {
        this.dncprintln("BEGIN TRACE_CONNECT_RESET");
        this.dncprintln("Connection reset requested for " + string + ":" + n + "/" + string2);
        this.dncprint("Using properties: ");
        this.writeProperties(properties);
        this.dncprintln("END TRACE_CONNECT_RESET");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceConnectsEntry(String string, int n, String string2, Properties properties) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.dncprintln("BEGIN TRACE_CONNECTS");
            this.dncprintln("Attempting connection to " + string + ":" + n + "/" + string2);
            this.dncprint("Using properties: ");
            this.writeProperties(properties);
            this.dncprintln("END TRACE_CONNECTS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceConnectsExit(ClientConnection clientConnection) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            String string = "[Connection@" + Integer.toHexString(clientConnection.hashCode()) + "]";
            try {
                this.dncprintln(string, "BEGIN TRACE_CONNECTS");
                this.dncprintln(string, "Successfully connected to server " + clientConnection.databaseMetaData_.getURL());
                this.dncprintln(string, "User: " + clientConnection.databaseMetaData_.getUserName());
                this.dncprintln(string, "Database product name: " + clientConnection.databaseMetaData_.getDatabaseProductName());
                this.dncprintln(string, "Database product version: " + clientConnection.databaseMetaData_.getDatabaseProductVersion());
                this.dncprintln(string, "Driver name: " + clientConnection.databaseMetaData_.getDriverName());
                this.dncprintln(string, "Driver version: " + clientConnection.databaseMetaData_.getDriverVersion());
                this.dncprintln(string, "END TRACE_CONNECTS");
            }
            catch (SQLException sQLException) {
                this.dncprintln(string, "Encountered an SQL exception while trying to trace connection exit");
                this.dncprintln(string, "END TRACE_CONNECTS");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceConnectsResetExit(ClientConnection clientConnection) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            String string = "[Connection@" + Integer.toHexString(clientConnection.hashCode()) + "]";
            try {
                this.dncprintln(string, "BEGIN TRACE_CONNECT_RESET");
                this.dncprintln(string, "Successfully reset connection to server " + clientConnection.databaseMetaData_.getURL());
                this.dncprintln(string, "User: " + clientConnection.databaseMetaData_.getUserName());
                this.dncprintln(string, "Database product name: " + clientConnection.databaseMetaData_.getDatabaseProductName());
                this.dncprintln(string, "Database product version: " + clientConnection.databaseMetaData_.getDatabaseProductVersion());
                this.dncprintln(string, "Driver name: " + clientConnection.databaseMetaData_.getDriverName());
                this.dncprintln(string, "Driver version: " + clientConnection.databaseMetaData_.getDriverVersion());
                this.dncprintln(string, "END TRACE_CONNECT_RESET");
            }
            catch (SQLException sQLException) {
                this.dncprintln(string, "Encountered an SQL exception while trying to trace connection reset exit");
                this.dncprintln(string, "END TRACE_CONNECT_RESET");
            }
        }
    }

    private void writeProperties(Properties properties) {
        this.printWriter_.print("{ ");
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            if ("password".equals(entry.getKey())) {
                this.printWriter_.print("password=" + this.escapePassword((String)entry.getValue()));
            } else {
                this.printWriter_.print(entry.getKey() + "=" + entry.getValue());
            }
            if (!iterator.hasNext()) continue;
            this.printWriter_.print(", ");
        }
        this.printWriter_.println(" }");
        this.printWriter_.flush();
    }

    private String escapePassword(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = 0; i < string.length(); ++i) {
            stringBuilder.setCharAt(i, '*');
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceDriverConfigurationJdbc2() {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            if (!this.driverConfigurationHasBeenWrittenToJdbc2Stream_) {
                this.writeDriverConfiguration();
                this.driverConfigurationHasBeenWrittenToJdbc2Stream_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceDriverConfigurationJdbc1() {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            if (!this.driverConfigurationHasBeenWrittenToJdbc1Stream_) {
                this.writeDriverConfiguration();
                this.driverConfigurationHasBeenWrittenToJdbc1Stream_ = true;
            }
        }
    }

    private void writeDriverConfiguration() {
        Version.writeDriverConfiguration(this.printWriter_);
    }

    private Properties getProperties(BasicClientDataSource40 basicClientDataSource40) throws SqlException {
        Properties properties = BasicClientDataSource40.getProperties(basicClientDataSource40);
        if (properties.getProperty("password") != null) {
            properties.setProperty("password", "********");
        }
        return properties;
    }
}

