/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatting;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.ITextReplacerContext;
import org.eclipse.xtext.formatting2.debug.HiddenRegionFormattingToString;
import org.eclipse.xtext.formatting2.internal.CommentReplacer;
import org.eclipse.xtext.formatting2.internal.WhitespaceReplacer;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegionPart;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.IWhitespace;

public class HiddenRegionReplacer
implements ITextReplacer {
    private final IHiddenRegionFormatting formatting;
    private final IHiddenRegion region;

    public HiddenRegionReplacer(IHiddenRegion region, IHiddenRegionFormatting formatting) {
        this.region = region;
        this.formatting = formatting;
    }

    protected void applyHiddenRegionFormatting(List<ITextReplacer> replacers) {
        IHiddenRegionFormatting separator = this.findWhitespaceThatSeparatesSemanticRegions(replacers).getFormatting();
        Integer inc = this.formatting.getIndentationIncrease();
        Integer dec = this.formatting.getIndentationDecrease();
        if (inc != null && dec != null) {
            ((WhitespaceReplacer)replacers.get(0)).getFormatting().setIndentationIncrease(inc);
            ((WhitespaceReplacer)replacers.get(replacers.size() - 1)).getFormatting().setIndentationDecrease(dec);
        } else if (inc != null) {
            separator.setIndentationIncrease(inc);
        } else if (dec != null) {
            separator.setIndentationDecrease(dec);
        }
        separator.setNewLinesDefault(this.formatting.getNewLineDefault());
        separator.setNewLinesMax(this.formatting.getNewLineMax());
        separator.setNewLinesMin(this.formatting.getNewLineMin());
        separator.setSpace(this.formatting.getSpace());
        for (ITextReplacer replacer : replacers) {
            if (!(replacer instanceof WhitespaceReplacer)) continue;
            IHiddenRegionFormatting formatting2 = ((WhitespaceReplacer)replacer).getFormatting();
            formatting2.setPriority(this.formatting.getPriority());
            if (formatting2 == separator) continue;
            formatting2.setSpace(replacer.getRegion().getOffset() > 0 ? " " : "");
            formatting2.setNewLinesMin(0);
            formatting2.setNewLinesMax(1);
        }
        for (int i = 0; i < replacers.size(); ++i) {
            ITextReplacer replacer;
            replacer = replacers.get(i);
            if (!(replacer instanceof CommentReplacer)) continue;
            CommentReplacer commentReplacer = (CommentReplacer)replacer;
            WhitespaceReplacer leading = (WhitespaceReplacer)replacers.get(i - 1);
            WhitespaceReplacer trailing = (WhitespaceReplacer)replacers.get(i + 1);
            commentReplacer.configureWhitespace(leading, trailing);
        }
    }

    @Override
    public ITextReplacerContext createReplacements(ITextReplacerContext context) {
        AbstractFormatter2 formatter = context.getFormatter();
        List<IHiddenRegionPart> hiddens = this.region.getParts();
        if (hiddens.isEmpty()) {
            return formatter.createWhitespaceReplacer(this.region, this.formatting).createReplacements(context);
        }
        if (hiddens.size() == 1 && hiddens.get(0) instanceof IWhitespace) {
            return formatter.createWhitespaceReplacer(hiddens.get(0), this.formatting).createReplacements(context);
        }
        List<ITextReplacer> replacers = this.createReplacers(formatter);
        this.applyHiddenRegionFormatting(replacers);
        ITextReplacerContext current = context;
        current.setNextReplacerIsChild();
        for (ITextReplacer replacer : replacers) {
            current = replacer.createReplacements(current.withReplacer(replacer));
        }
        return current;
    }

    protected List<ITextReplacer> createReplacers(AbstractFormatter2 formatter) {
        List<ITextSegment> regions = this.region.getAlternatingMergedSpaceAndComments();
        ArrayList replacers = Lists.newArrayListWithCapacity((int)regions.size());
        for (ITextSegment region : regions) {
            if (region instanceof IComment) {
                replacers.add(formatter.createCommentReplacer((IComment)region));
                continue;
            }
            replacers.add(formatter.createWhitespaceReplacer(region, formatter.createHiddenRegionFormatting()));
        }
        return replacers;
    }

    protected WhitespaceReplacer findWhitespaceThatSeparatesSemanticRegions(List<ITextReplacer> replacers) {
        boolean hasSeenWrap = false;
        for (ITextReplacer replacer : replacers) {
            WhitespaceReplacer whitespaceReplacer;
            if (!(replacer instanceof WhitespaceReplacer) || !(hasSeenWrap |= (whitespaceReplacer = (WhitespaceReplacer)replacer).getRegion().isMultiline())) continue;
            return whitespaceReplacer;
        }
        return (WhitespaceReplacer)replacers.get(replacers.size() - 1);
    }

    public IHiddenRegionFormatting getFormatting() {
        return this.formatting;
    }

    @Override
    public IHiddenRegion getRegion() {
        return this.region;
    }

    public String toString() {
        return new HiddenRegionFormattingToString().apply(this.formatting);
    }
}

