/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;
import org.eclipse.xtext.ui.refactoring.ElementRenameArguments;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.impl.AbstractReferenceUpdater;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringCrossReferenceSerializer;
import org.eclipse.xtext.util.ITextRegion;

public class DefaultReferenceUpdater
extends AbstractReferenceUpdater {
    private static final Logger log = Logger.getLogger(DefaultReferenceUpdater.class);
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    @Inject
    private ITransientValueService transientValueService;
    @Inject
    private RefactoringCrossReferenceSerializer crossReferenceSerializer;

    @Override
    protected void createReferenceUpdates(ElementRenameArguments elementRenameArguments, Multimap<URI, IReferenceDescription> resource2references, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Creating reference updates", (int)resource2references.keySet().size());
        for (URI referringResourceURI : resource2references.keySet()) {
            if (progress.isCanceled()) {
                return;
            }
            Resource referringResource = resourceSet.getResource(referringResourceURI, false);
            if (!(referringResource instanceof XtextResource)) {
                updateAcceptor.getRefactoringStatus().add(3, "Resource {0} is not an XtextResource.", referringResource.getURI(), resourceSet);
            } else {
                Collection referenceDescriptions = resource2references.get((Object)referringResourceURI);
                this.processReferringResource(referringResource, referenceDescriptions, elementRenameArguments, updateAcceptor);
            }
            progress.worked(1);
        }
    }

    protected void processReferringResource(Resource referringResource, Iterable<IReferenceDescription> referenceDescriptions, ElementRenameArguments elementRenameArguments, IRefactoringUpdateAcceptor updateAcceptor) {
        ((XtextResource)referringResource).getCache().clear(referringResource);
        for (IReferenceDescription referenceDescription : referenceDescriptions) {
            this.createReferenceUpdate(referenceDescription, referringResource.getURI(), elementRenameArguments, referringResource.getResourceSet(), updateAcceptor);
        }
    }

    protected void createReferenceUpdate(IReferenceDescription referenceDescription, URI referringResourceURI, ElementRenameArguments elementRenameArguments, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor) {
        URI referringElementNewURI = elementRenameArguments.getNewElementURI(referenceDescription.getSourceEObjectUri());
        EObject referringElement = resourceSet.getEObject(referringElementNewURI, false);
        if (referringElement == null) {
            updateAcceptor.getRefactoringStatus().add(3, "Cannot find new referring element.", referringElementNewURI);
            log.error((Object)("Cannot find new referring element. ReferringElementURI:" + referringElementNewURI));
            return;
        }
        URI targetElementNewURI = elementRenameArguments.getNewElementURI(referenceDescription.getTargetEObjectUri());
        EObject newTargetElement = resourceSet.getEObject(targetElementNewURI, false);
        if (newTargetElement == null) {
            updateAcceptor.getRefactoringStatus().add(3, "Cannot find new target element.", targetElementNewURI);
            log.error((Object)("Cannot find new target element. ReferringElement:" + referringElement + " targetElementNewURI:" + targetElementNewURI));
            return;
        }
        this.createReferenceUpdate(referringElement, referringResourceURI, referenceDescription.getEReference(), referenceDescription.getIndexInList(), newTargetElement, updateAcceptor);
    }

    protected void createReferenceUpdate(EObject referringElement, URI referringResourceURI, EReference reference, int indexInList, EObject newTargetElement, IRefactoringUpdateAcceptor updateAcceptor) {
        CrossReference crossReference;
        ITextRegion referenceTextRegion;
        if (!this.transientValueService.isValueInListTransient(referringElement, indexInList, (EStructuralFeature)reference) && (referenceTextRegion = this.locationInFileProvider.getFullTextRegion(referringElement, (EStructuralFeature)reference, indexInList)) != null && (crossReference = this.getCrossReference(referringElement, referenceTextRegion.getOffset())) != null) {
            RefactoringCrossReferenceSerializer.RefTextEvaluator refTextComparator = this.getRefTextEvaluator(referringElement, referringResourceURI, reference, indexInList, newTargetElement);
            String newReferenceText = this.crossReferenceSerializer.getCrossRefText(referringElement, crossReference, newTargetElement, refTextComparator, referenceTextRegion, updateAcceptor.getRefactoringStatus());
            if (newReferenceText == null) {
                newReferenceText = this.resolveNameConflict(referringElement, reference, newTargetElement, updateAcceptor);
            }
            if (newReferenceText == null) {
                updateAcceptor.getRefactoringStatus().add(3, "Refactoring introduces a name conflict.", referringElement, referenceTextRegion);
            }
            this.createTextChange(referenceTextRegion, newReferenceText, referringElement, newTargetElement, reference, referringResourceURI, updateAcceptor);
        }
    }

    protected String resolveNameConflict(EObject referringElement, EReference reference, EObject newTargetElement, IRefactoringUpdateAcceptor updateAcceptor) {
        return null;
    }

    protected RefactoringCrossReferenceSerializer.RefTextEvaluator getRefTextEvaluator(EObject referringElement, URI referringResourceURI, EReference reference, int indexInList, EObject newTargetElement) {
        return new RefactoringCrossReferenceSerializer.RefTextEvaluator(){

            @Override
            public boolean isValid(IEObjectDescription target) {
                return true;
            }

            @Override
            public boolean isBetterThan(String newText, String currentText) {
                return newText.length() < currentText.length();
            }
        };
    }

    protected void createTextChange(ITextRegion referenceTextRegion, String newReferenceText, EObject referringElement, EObject newTargetElement, EReference reference, URI referringResourceURI, IRefactoringUpdateAcceptor updateAcceptor) {
        if (newReferenceText != null) {
            ReplaceEdit referenceEdit = new ReplaceEdit(referenceTextRegion.getOffset(), referenceTextRegion.getLength(), newReferenceText);
            updateAcceptor.accept(referringResourceURI, (TextEdit)referenceEdit);
        }
    }

    protected CrossReference getCrossReference(EObject referringElement, int offset) {
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)referringElement);
        if (node != null) {
            for (INode childNode : node.getAsTreeIterable()) {
                if (childNode.getOffset() < offset || !(childNode.getGrammarElement() instanceof CrossReference)) continue;
                return (CrossReference)childNode.getGrammarElement();
            }
        }
        return null;
    }

    protected ILocationInFileProvider getLocationInFileProvider() {
        return this.locationInFileProvider;
    }

    protected ITransientValueService getTransientValueService() {
        return this.transientValueService;
    }
}

