/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.support;

import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swt.support.AbstractSupport;
import org.eclipse.wb.internal.swt.support.PointSupport;
import org.eclipse.wb.internal.swt.support.RectangleSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlSupport
extends AbstractSupport {
    public static Class<?> getWidgetClass() {
        return ControlSupport.loadClass("org.eclipse.swt.widgets.Widget");
    }

    public static Class<?> getControlClass() {
        return ControlSupport.loadClass("org.eclipse.swt.widgets.Control");
    }

    public static boolean isControlClass(Class<?> clazz) {
        return ReflectionUtils.isSuccessorOf(clazz, (String)"org.eclipse.swt.widgets.Control");
    }

    public static boolean isControl(Object o) {
        if (o != null) {
            return ControlSupport.isControlClass(o.getClass());
        }
        return false;
    }

    public static int getStyle(Object widget) {
        return (Integer)ReflectionUtils.invokeMethodEx((Object)widget, (String)"getStyle()", (Object[])new Object[0]);
    }

    public static boolean isStyle(Object widget, int style) {
        return (ControlSupport.getStyle(widget) & style) != 0;
    }

    public static Rectangle getBounds(Object control) throws Exception {
        Object bounds = ReflectionUtils.invokeMethod((Object)control, (String)"getBounds()", (Object[])new Object[0]);
        return RectangleSupport.getRectangle(bounds);
    }

    public static Point toDisplay(Object control, int x, int y) throws Exception {
        Object location = ReflectionUtils.invokeMethod((Object)control, (String)"toDisplay(int,int)", (Object[])new Object[]{x, y});
        return PointSupport.getPoint(location);
    }

    public static void setSize(Object control, int width, int height) throws Exception {
        ReflectionUtils.invokeMethod((Object)control, (String)"setSize(int,int)", (Object[])new Object[]{width, height});
    }

    public static void setLocation(Object control, int x, int y) throws Exception {
        ReflectionUtils.invokeMethod((Object)control, (String)"setLocation(int,int)", (Object[])new Object[]{x, y});
    }

    public static Object computeSize_DEFAULT(Object control) throws Exception {
        return ReflectionUtils.invokeMethod((Object)control, (String)"computeSize(int,int)", (Object[])new Object[]{-1, -1});
    }

    public static Dimension getPreferredSize(Object control) throws Exception {
        Object size = ReflectionUtils.invokeMethod((Object)control, (String)"computeSize(int,int)", (Object[])new Object[]{-1, -1});
        Point pointSize = PointSupport.getPoint(size);
        return new Dimension(pointSize.x, pointSize.y);
    }

    public static int getBorderWidth(Object control) {
        return (Integer)ReflectionUtils.invokeMethodEx((Object)control, (String)"getBorderWidth()", (Object[])new Object[0]);
    }

    public static void pack(Object control) throws Exception {
        ReflectionUtils.invokeMethod((Object)control, (String)"pack()", (Object[])new Object[0]);
    }

    public static Object getLayoutData(Object control) {
        return ReflectionUtils.invokeMethodEx((Object)control, (String)"getLayoutData()", (Object[])new Object[0]);
    }

    public static void setLayoutData(Object control, Object layoutData) {
        ReflectionUtils.invokeMethodEx((Object)control, (String)"setLayoutData(java.lang.Object)", (Object[])new Object[]{layoutData});
    }

    public static Object getData(Object control, String key) throws Exception {
        return ReflectionUtils.invokeMethod((Object)control, (String)"getData(java.lang.String)", (Object[])new Object[]{key});
    }

    public static void setData(Object control, String key, Object value) throws Exception {
        ReflectionUtils.invokeMethod((Object)control, (String)"setData(java.lang.String,java.lang.Object)", (Object[])new Object[]{key, value});
    }

    public static Object getParent(Object control) {
        return ReflectionUtils.invokeMethodEx((Object)control, (String)"getParent()", (Object[])new Object[0]);
    }

    public static Object getShell(Object control) {
        return ReflectionUtils.invokeMethodEx((Object)control, (String)"getShell()", (Object[])new Object[0]);
    }

    public static void dispose(Object widget) {
        if (widget == null) {
            return;
        }
        if (!ControlSupport.isDisposed(widget)) {
            ReflectionUtils.invokeMethodEx((Object)widget, (String)"dispose()", (Object[])new Object[0]);
        }
    }

    public static boolean isDisposed(Object widget) {
        return (Boolean)ReflectionUtils.invokeMethodEx((Object)widget, (String)"isDisposed()", (Object[])new Object[0]);
    }
}

