/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.property.editor.color;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.JavaInfoEvaluationHelper;
import org.eclipse.wb.internal.core.model.clipboard.IClipboardSourceProvider;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.presentation.ButtonPropertyEditorPresentation;
import org.eclipse.wb.internal.core.model.property.editor.presentation.PropertyEditorPresentation;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;
import org.eclipse.wb.internal.core.model.util.TemplateUtils;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.ui.DrawUtils;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.AbstractColorDialog;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.AbstractColorsComposite;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.AbstractColorsGridComposite;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.ColorInfo;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.ColorsGridComposite;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.pages.NamedColorsComposite;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.pages.WebSafeColorsComposite;
import org.eclipse.wb.internal.swt.model.ModelMessages;
import org.eclipse.wb.internal.swt.model.jface.resource.ColorRegistryInfo;
import org.eclipse.wb.internal.swt.model.jface.resource.KeyFieldInfo;
import org.eclipse.wb.internal.swt.model.jface.resource.RegistryContainerInfo;
import org.eclipse.wb.internal.swt.model.jface.resource.ResourceRegistryInfo;
import org.eclipse.wb.internal.swt.model.property.editor.color.SwtColors;
import org.eclipse.wb.internal.swt.support.ColorSupport;
import org.eclipse.wb.internal.swt.support.SwtSupport;
import org.eclipse.wb.internal.swt.utils.ManagerUtils;

public final class ColorPropertyEditor
extends PropertyEditor
implements IClipboardSourceProvider {
    public static final PropertyEditor INSTANCE = new ColorPropertyEditor();
    private static final int SAMPLE_SIZE = 10;
    private static final int SAMPLE_MARGIN = 3;
    private final PropertyEditorPresentation m_presentation = new ButtonPropertyEditorPresentation(){

        protected void onClick(PropertyTable propertyTable, Property property) throws Exception {
            ColorPropertyEditor.this.openDialog(property);
        }
    };

    private ColorPropertyEditor() {
    }

    public PropertyEditorPresentation getPresentation() {
        return this.m_presentation;
    }

    public void paint(Property property, GC gc, int x, int y, int width, int height) throws Exception {
        Object value = property.getValue();
        if (value != Property.UNKNOWN_VALUE && value != null) {
            Color color = ColorSupport.getColor(value);
            Color oldBackground = gc.getBackground();
            Color oldForeground = gc.getForeground();
            try {
                int width_c = 10;
                int height_c = 10;
                int x_c = x;
                int y_c = y + (height - height_c) / 2;
                int delta = 13;
                x += delta;
                width -= delta;
                gc.setBackground(color);
                gc.fillRectangle(x_c, y_c, width_c, height_c);
                gc.setForeground(IColorConstants.gray);
                gc.drawRectangle(x_c, y_c, width_c, height_c);
            }
            finally {
                gc.setBackground(oldBackground);
                gc.setForeground(oldForeground);
                color.dispose();
            }
            String text = this.getText(property);
            DrawUtils.drawStringCV((GC)gc, (String)text, (int)x, (int)y, (int)width, (int)height);
        }
    }

    private String getText(Property property) throws Exception {
        Object value = property.getValue();
        if (value != Property.UNKNOWN_VALUE) {
            MethodInvocation invocation;
            Expression idExpression;
            String fieldName;
            Expression expression = ((GenericProperty)property).getExpression();
            if (AstNodeUtils.isMethodInvocation((ASTNode)expression, (String)"org.eclipse.swt.widgets.Display", (String)"getSystemColor(int)") && (fieldName = ColorPropertyEditor.getColorFieldName(idExpression = (Expression)DomGenerics.arguments((MethodInvocation)(invocation = (MethodInvocation)expression)).get(0))) != null) {
                return fieldName;
            }
            if (AstNodeUtils.isMethodInvocation((ASTNode)expression, (String)"org.eclipse.wb.swt.SWTResourceManager", (String)"getColor(int)")) {
                invocation = (MethodInvocation)expression;
                idExpression = (Expression)DomGenerics.arguments((MethodInvocation)invocation).get(0);
                return ColorPropertyEditor.getColorFieldName(idExpression);
            }
            if (expression instanceof MethodInvocation && AstNodeUtils.getMethodSignature((MethodInvocation)(invocation = (MethodInvocation)expression)).equals("get(java.lang.String)") && AstNodeUtils.isSuccessorOf((ITypeBinding)AstNodeUtils.getTypeBinding((Expression)invocation.getExpression()), (String)"org.eclipse.jface.resource.ColorRegistry")) {
                Object keyArgument = invocation.arguments().get(0);
                if (keyArgument instanceof QualifiedName) {
                    GenericProperty genericProperty = (GenericProperty)property;
                    ResourceRegistryInfo registry = RegistryContainerInfo.getRegistry(genericProperty.getJavaInfo().getRootJava(), (ASTNode)invocation.getExpression());
                    QualifiedName keyQualifiedName = (QualifiedName)keyArgument;
                    return String.valueOf(registry.getVariableSupport().getTitle()) + " - " + keyQualifiedName.getName().getIdentifier();
                }
                return null;
            }
            return ColorSupport.toString(value);
        }
        return null;
    }

    private static String getColorFieldName(Expression idExpression) throws Exception {
        int id = (Integer)JavaInfoEvaluationHelper.getValue((Expression)idExpression);
        Field[] fieldArray = SwtSupport.getSwtClass().getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            String fieldName = field.getName();
            if (fieldName.startsWith("COLOR_") && field.getInt(null) == id) {
                return fieldName;
            }
            ++n2;
        }
        throw new IllegalArgumentException(MessageFormat.format(ModelMessages.ColorPropertyEditor_wrongSwtColor, idExpression, id));
    }

    public String getClipboardSource(GenericProperty property) throws Exception {
        Expression idExpression;
        MethodInvocation invocation;
        Object value = property.getValue();
        if (value == Property.UNKNOWN_VALUE) {
            return null;
        }
        ColorInfo colorInfo = ColorSupport.createInfo(value);
        Expression expression = property.getExpression();
        if (AstNodeUtils.isMethodInvocation((ASTNode)expression, (String)"org.eclipse.swt.widgets.Display", (String)"getSystemColor(int)")) {
            invocation = (MethodInvocation)expression;
            idExpression = (Expression)DomGenerics.arguments((MethodInvocation)invocation).get(0);
            colorInfo.setData((Object)("org.eclipse.swt.SWT." + ColorPropertyEditor.getColorFieldName(idExpression)));
        }
        if (AstNodeUtils.isMethodInvocation((ASTNode)expression, (String)"org.eclipse.wb.swt.SWTResourceManager", (String)"getColor(int)")) {
            invocation = (MethodInvocation)expression;
            idExpression = (Expression)DomGenerics.arguments((MethodInvocation)invocation).get(0);
            colorInfo.setData((Object)("org.eclipse.swt.SWT." + ColorPropertyEditor.getColorFieldName(idExpression)));
        }
        return ColorPropertyEditor.getSource(property, colorInfo);
    }

    public boolean activate(PropertyTable propertyTable, Property property, Point location) throws Exception {
        if (location == null) {
            this.openDialog(property);
        }
        return false;
    }

    private void openDialog(Property property) throws Exception {
        GenericProperty genericProperty = (GenericProperty)property;
        ColorDialog colorDialog = new ColorDialog(genericProperty.getJavaInfo());
        Object value = property.getValue();
        if (value != Property.UNKNOWN_VALUE && value != null) {
            colorDialog.setColorInfo(ColorSupport.createInfo(value));
        }
        if (colorDialog.open() == 0) {
            ColorInfo colorInfo = colorDialog.getColorInfo();
            String source = ColorPropertyEditor.getSource(genericProperty, colorInfo);
            genericProperty.setExpression(source, Property.UNKNOWN_VALUE);
        }
    }

    private static String getSource(GenericProperty property, ColorInfo colorInfo) throws Exception {
        if (colorInfo.getData() instanceof Object[]) {
            Object[] data = (Object[])colorInfo.getData();
            ColorRegistryInfo registryInfo = (ColorRegistryInfo)((Object)data[0]);
            KeyFieldInfo keyInfo = (KeyFieldInfo)data[1];
            return TemplateUtils.format((String)"{0}.get({1})", (Object[])new Object[]{registryInfo, keyInfo.keySource});
        }
        IPreferenceStore preferences = property.getJavaInfo().getDescription().getToolkit().getPreferences();
        if (preferences.getBoolean("useResourceManager")) {
            ManagerUtils.ensure_SWTResourceManager(property.getJavaInfo());
            if (colorInfo.getData() != null) {
                return "org.eclipse.wb.swt.SWTResourceManager.getColor(" + colorInfo.getData() + ")";
            }
            return "org.eclipse.wb.swt.SWTResourceManager.getColor(" + colorInfo.getCommaRGB() + ")";
        }
        if (colorInfo.getData() != null) {
            return "org.eclipse.swt.widgets.Display.getCurrent().getSystemColor(" + colorInfo.getData() + ")";
        }
        return "new org.eclipse.swt.graphics.Color(null, " + colorInfo.getCommaRGB() + ")";
    }

    private static final class ColorDialog
    extends AbstractColorDialog {
        private static String m_lastPageTitle;
        private final JavaInfo m_javaInfo;

        public ColorDialog(JavaInfo javaInfo) {
            super(DesignerPlugin.getShell());
            this.m_javaInfo = javaInfo;
        }

        protected void addPages(Composite parent) {
            this.addPage(ModelMessages.ColorPropertyEditor_systemColorsPage, (AbstractColorsComposite)new SystemColorsPage(parent, 0, this, this.m_javaInfo));
            this.addPage(ModelMessages.ColorPropertyEditor_namedColorsPage, (AbstractColorsComposite)new NamedColorsComposite(parent, 0, (AbstractColorDialog)this));
            this.addPage(ModelMessages.ColorPropertyEditor_webSafePage, (AbstractColorsComposite)new WebSafeColorsComposite(parent, 0, (AbstractColorDialog)this));
            try {
                List<ColorRegistryInfo> registries = RegistryContainerInfo.getRegistries(this.m_javaInfo.getRootJava(), ColorRegistryInfo.class);
                if (!registries.isEmpty()) {
                    this.addPage("ColorRegistry", (AbstractColorsComposite)new RegistryColorsPage(parent, 0, this, registries));
                }
            }
            catch (Throwable e) {
                DesignerPlugin.log((Throwable)e);
            }
            this.selectPageByTitle(m_lastPageTitle);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                m_lastPageTitle = this.getSelectedPageTitle();
            }
            super.buttonPressed(buttonId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RegistryColorsPage
    extends AbstractColorsGridComposite {
        public RegistryColorsPage(Composite parent, int style, AbstractColorDialog colorDialog, List<ColorRegistryInfo> registries) throws Exception {
            super(parent, style, colorDialog);
            for (ColorRegistryInfo registryInfo : registries) {
                Object registry = registryInfo.getObject();
                ArrayList infos = Lists.newArrayList();
                for (KeyFieldInfo keyInfo : registryInfo.getKeyFields()) {
                    if (keyInfo.value == null) {
                        keyInfo.value = ReflectionUtils.invokeMethod((Object)registry, (String)"get(java.lang.String)", (Object[])new Object[]{keyInfo.keyValue});
                    }
                    if (keyInfo.value == null) continue;
                    ColorInfo colorInfo = ColorSupport.createInfo(keyInfo.keyName, keyInfo.value);
                    colorInfo.setData((Object)new Object[]{registryInfo, keyInfo});
                    infos.add(colorInfo);
                }
                ColorsGridComposite colorsGrid = this.createColorsGroup((Composite)this, registryInfo.getVariableSupport().getTitle(), infos.toArray(new ColorInfo[infos.size()]));
                colorsGrid.showNames(50);
                colorsGrid.setCellHeight(25);
                colorsGrid.setColumns(2);
            }
        }
    }

    private static final class SystemColorsPage
    extends AbstractColorsGridComposite {
        public SystemColorsPage(Composite parent, int style, AbstractColorDialog colorDialog, JavaInfo javaInfo) {
            super(parent, style, colorDialog);
            ColorsGridComposite colorsGrid = this.createColorsGroup((Composite)this, null, SwtColors.getSystemColors(javaInfo));
            colorsGrid.showNames(50);
            colorsGrid.setCellHeight(25);
            colorsGrid.setColumns(2);
        }
    }
}

