/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.wizards;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.viatra.query.tooling.core.targetplatform.ITargetPlatformMetamodelLoader;
import org.eclipse.viatra.query.tooling.ui.wizards.NewVqlFileWizardContainerConfigurationPage;
import org.eclipse.viatra.query.tooling.ui.wizards.internal.ImportListAdapter;
import org.eclipse.viatra.query.tooling.ui.wizards.internal.ImportListLabelProvider;
import org.eclipse.viatra.query.tooling.ui.wizards.internal.ObjectListAdapter;
import org.eclipse.viatra.query.tooling.ui.wizards.internal.ObjectListLabelProvider;
import org.eclipse.viatra.query.tooling.ui.wizards.internal.ObjectParameter;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public class NewVqlFileWizardPatternConfigurationPage
extends WizardPage {
    private static final String TITLE = "VIATRA Query Definition Wizard";
    private static final String PATTERN_NAME_SHOULD_BE_SPECIFIED = "Pattern name should be specified!";
    private static final String PATTERN_NAME_MUST_BE_SPECIFIED = "Pattern name must be specified, if at least one parameter is set!";
    private Text patternText;
    private ListDialogField<String> importList;
    private ListDialogField<ObjectParameter> objectList;
    private ImportListLabelProvider importListLabelProvider;
    private ObjectListLabelProvider objectListLabelProvider;
    private ImportListAdapter importListAdapter;
    private ObjectListAdapter objectListAdapter;
    public boolean parameterSet;
    @Inject
    private ITargetPlatformMetamodelLoader metamodelLoader;
    @Inject
    private IResourceSetProvider resourceSetProvider;
    private ResourceSet resourceSet;

    public NewVqlFileWizardPatternConfigurationPage() {
        super(TITLE);
        this.setTitle(TITLE);
        this.parameterSet = false;
    }

    private void createImportsControl(Composite parent, int nColumns) {
        String[] buttonLiterals = new String[]{"Add", "Remove"};
        NewVqlFileWizardContainerConfigurationPage firstPage = (NewVqlFileWizardContainerConfigurationPage)this.getPreviousPage();
        this.resourceSet = this.resourceSetProvider.get(firstPage.getProject());
        this.importListAdapter = new ImportListAdapter(this.metamodelLoader);
        this.importListLabelProvider = new ImportListLabelProvider();
        this.importList = new ListDialogField((IListAdapter)this.importListAdapter, buttonLiterals, (ILabelProvider)this.importListLabelProvider);
        this.importList.setLabelText("&Imported packages:");
        this.importList.setTableColumns(new ListDialogField.ColumnsDescription(new String[]{"EPackage"}, true));
        this.importList.setRemoveButtonIndex(1);
        this.importList.doFillIntoGrid(parent, nColumns);
    }

    private void createObjectSelectionControl(Composite parent, int nColumns) {
        String[] buttonLiterals = new String[]{"Add", "Modify", "Remove"};
        this.objectListAdapter = new ObjectListAdapter(this, this.importList, this.metamodelLoader);
        this.objectListLabelProvider = new ObjectListLabelProvider();
        this.objectList = new ListDialogField((IListAdapter)this.objectListAdapter, buttonLiterals, (ILabelProvider)this.objectListLabelProvider);
        this.objectList.setLabelText("&Pattern parameters:");
        this.objectList.setTableColumns(new ListDialogField.ColumnsDescription(new String[]{"Name", "Type"}, true));
        this.objectList.enableButton(1, false);
        this.objectList.setRemoveButtonIndex(2);
        this.objectList.doFillIntoGrid(parent, nColumns);
    }

    public void createControl(Composite parent) {
        int nColumns = 5;
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText("&Pattern name:");
        this.patternText = new Text(composite, 2052);
        this.patternText.setText("");
        GridData gd_1 = new GridData(768);
        gd_1.horizontalSpan = 3;
        this.patternText.setLayoutData((Object)gd_1);
        this.patternText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewVqlFileWizardPatternConfigurationPage.this.validatePage();
            }
        });
        label = new Label(composite, 258);
        GridData gd_2 = new GridData(768);
        gd_2.horizontalSpan = nColumns;
        label.setLayoutData((Object)gd_2);
        this.createImportsControl(composite, nColumns);
        this.createObjectSelectionControl(composite, nColumns);
        this.setControl((Control)composite);
        this.validatePage();
    }

    public void validatePage() {
        String patternName;
        StatusInfo si = new StatusInfo(0, "");
        if (this.patternText != null && ((patternName = this.patternText.getText()) == null || patternName.length() == 0)) {
            if (this.parameterSet) {
                si.setWarning(PATTERN_NAME_MUST_BE_SPECIFIED);
            } else {
                si.setWarning(PATTERN_NAME_SHOULD_BE_SPECIFIED);
            }
        }
        if (si.getSeverity() == 0) {
            si.setInfo("");
        }
        this.updateStatus((IStatus)si);
        if (si.isError()) {
            this.setErrorMessage(si.getMessage());
        }
    }

    protected void updateStatus(IStatus status) {
        this.setPageComplete(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)status);
    }

    public String getPatternName() {
        return this.patternText.getText();
    }

    public List<EPackage> getImports() {
        return Lists.transform((List)this.importList.getElements(), (Function)new Function<String, EPackage>(){

            public EPackage apply(String input) {
                return NewVqlFileWizardPatternConfigurationPage.this.metamodelLoader.loadPackage(NewVqlFileWizardPatternConfigurationPage.this.resourceSet, input);
            }
        });
    }

    public List<ObjectParameter> getParameters() {
        return this.objectList.getElements();
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }
}

