/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryregistry;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryChangeListener;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.runtime.registry.IRegistryView;
import org.eclipse.viatra.query.runtime.registry.IRegistryViewFactory;
import org.eclipse.viatra.query.runtime.registry.view.AbstractRegistryView;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeEntry;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeInputChange;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreePackage;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeSource;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeViewListener;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class QueryRegistryTreeInput {
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private Map<String, QueryRegistryTreeSource> sources = Maps.newTreeMap();
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private IQuerySpecificationRegistry registry;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private IRegistryView view;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private QueryRegistryTreeViewListener listener;

    public QueryRegistryTreeInput(final IQuerySpecificationRegistry registry) {
        IRegistryView _createView;
        QueryRegistryTreeViewListener _queryRegistryTreeViewListener;
        this.registry = registry;
        this.listener = _queryRegistryTreeViewListener = new QueryRegistryTreeViewListener();
        this.listener.input = this;
        IRegistryViewFactory _function = new IRegistryViewFactory(){

            public IRegistryView createView(IQuerySpecificationRegistry it) {
                return new AbstractRegistryView(registry, true){

                    protected boolean isEntryRelevant(IQuerySpecificationRegistryEntry entry) {
                        return true;
                    }
                };
            }
        };
        this.view = _createView = registry.createView(_function);
        Iterable _entries = this.view.getEntries();
        Procedures.Procedure1<IQuerySpecificationRegistryEntry> _function_1 = new Procedures.Procedure1<IQuerySpecificationRegistryEntry>(){

            public void apply(IQuerySpecificationRegistryEntry it) {
                String _sourceIdentifier = it.getSourceIdentifier();
                QueryRegistryTreeInputChange source = QueryRegistryTreeInput.this.getOrCreateSource(_sourceIdentifier);
                QueryRegistryTreeSource _source = source.getSource();
                String _fullyQualifiedName = it.getFullyQualifiedName();
                String _packageName = QueryRegistryTreeInput.this.getPackageName(_fullyQualifiedName);
                QueryRegistryTreeInputChange treePackage = QueryRegistryTreeInput.this.getOrCreatePackage(_source, _packageName);
                QueryRegistryTreePackage _pckg = treePackage.getPckg();
                QueryRegistryTreeEntry entry = new QueryRegistryTreeEntry(_pckg, it);
                QueryRegistryTreePackage _pckg_1 = treePackage.getPckg();
                Map<String, QueryRegistryTreeEntry> _entries = _pckg_1.getEntries();
                String _fullyQualifiedName_1 = it.getFullyQualifiedName();
                _entries.put(_fullyQualifiedName_1, entry);
            }
        };
        IterableExtensions.forEach((Iterable)_entries, (Procedures.Procedure1)_function_1);
        this.view.addViewListener((IQuerySpecificationRegistryChangeListener)this.listener);
    }

    public QueryRegistryTreeInputChange addEntryToInput(IQuerySpecificationRegistryEntry entry) {
        String _sourceIdentifier = entry.getSourceIdentifier();
        QueryRegistryTreeInputChange source = this.getOrCreateSource(_sourceIdentifier);
        QueryRegistryTreeSource _source = source.getSource();
        String _fullyQualifiedName = entry.getFullyQualifiedName();
        String _packageName = this.getPackageName(_fullyQualifiedName);
        QueryRegistryTreeInputChange treePackage = this.getOrCreatePackage(_source, _packageName);
        QueryRegistryTreePackage treePckg = treePackage.getPckg();
        QueryRegistryTreeEntry treeEntry = new QueryRegistryTreeEntry(treePckg, entry);
        Map<String, QueryRegistryTreeEntry> _entries = treePckg.getEntries();
        boolean emptyPckg = _entries.isEmpty();
        QueryRegistryTreePackage _pckg = treePackage.getPckg();
        Map<String, QueryRegistryTreeEntry> _entries_1 = _pckg.getEntries();
        String _fullyQualifiedName_1 = entry.getFullyQualifiedName();
        _entries_1.put(_fullyQualifiedName_1, treeEntry);
        boolean _or = false;
        boolean _isPckgAffected = treePackage.isPckgAffected();
        _or = _isPckgAffected ? true : emptyPckg;
        boolean _isSourceAffected = source.isSourceAffected();
        QueryRegistryTreeSource _source_1 = source.getSource();
        return new QueryRegistryTreeInputChange(true, treeEntry, _or, treePckg, _isSourceAffected, _source_1);
    }

    public QueryRegistryTreeInputChange removeEntry(IQuerySpecificationRegistryEntry entry) {
        Map<String, QueryRegistryTreePackage> _packages_1;
        boolean emptySource;
        String _sourceIdentifier = entry.getSourceIdentifier();
        QueryRegistryTreeInputChange sourceDTO = this.getOrCreateSource(_sourceIdentifier);
        QueryRegistryTreeSource source = sourceDTO.getSource();
        QueryRegistryTreeSource _source = sourceDTO.getSource();
        String _fullyQualifiedName = entry.getFullyQualifiedName();
        String _packageName = this.getPackageName(_fullyQualifiedName);
        QueryRegistryTreeInputChange treePackageDTO = this.getOrCreatePackage(_source, _packageName);
        QueryRegistryTreePackage treePckg = treePackageDTO.getPckg();
        Map<String, QueryRegistryTreeEntry> _entries = treePckg.getEntries();
        String _fullyQualifiedName_1 = entry.getFullyQualifiedName();
        QueryRegistryTreeEntry treeEntry = _entries.remove(_fullyQualifiedName_1);
        Map<String, QueryRegistryTreeEntry> _entries_1 = treePckg.getEntries();
        boolean emptyPckg = _entries_1.isEmpty();
        if (emptyPckg) {
            Map<String, QueryRegistryTreePackage> _packages = source.getPackages();
            String _packageName_1 = treePckg.getPackageName();
            _packages.remove(_packageName_1);
        }
        if (emptySource = (_packages_1 = source.getPackages()).isEmpty()) {
            String _sourceIdentifier_1 = source.getSourceIdentifier();
            this.sources.remove(_sourceIdentifier_1);
        }
        boolean _or = false;
        boolean _isPckgAffected = treePackageDTO.isPckgAffected();
        _or = _isPckgAffected ? true : emptyPckg;
        boolean _or_1 = false;
        boolean _isSourceAffected = sourceDTO.isSourceAffected();
        _or_1 = _isSourceAffected ? true : emptySource;
        return new QueryRegistryTreeInputChange(true, treeEntry, _or, treePckg, _or_1, source);
    }

    public QueryRegistryTreeInputChange getOrCreateSource(String sourceIdentifier) {
        QueryRegistryTreeSource existingSource = this.sources.get(sourceIdentifier);
        boolean _equals = Objects.equal((Object)existingSource, null);
        if (_equals) {
            QueryRegistryTreeSource newSource = new QueryRegistryTreeSource(this, sourceIdentifier);
            this.sources.put(sourceIdentifier, newSource);
            return new QueryRegistryTreeInputChange(false, null, false, null, true, newSource);
        }
        return new QueryRegistryTreeInputChange(false, null, false, null, false, existingSource);
    }

    public QueryRegistryTreeInputChange getOrCreatePackage(QueryRegistryTreeSource source, String packageName) {
        Map<String, QueryRegistryTreePackage> _packages = source.getPackages();
        QueryRegistryTreePackage existingPackage = _packages.get(packageName);
        boolean _equals = Objects.equal((Object)existingPackage, null);
        if (_equals) {
            QueryRegistryTreePackage newPackage = new QueryRegistryTreePackage(source, packageName);
            Map<String, QueryRegistryTreePackage> _packages_1 = source.getPackages();
            _packages_1.put(packageName, newPackage);
            return new QueryRegistryTreeInputChange(false, null, true, newPackage, false, null);
        }
        return new QueryRegistryTreeInputChange(false, null, false, existingPackage, false, null);
    }

    public String getPackageName(String fullyQualifiedName) {
        int _lastIndexOf = fullyQualifiedName.lastIndexOf(".");
        return fullyQualifiedName.substring(0, _lastIndexOf);
    }

    protected TreePath _getTreePath(QueryRegistryTreePackage pckg) {
        QueryRegistryTreeSource _parent = pckg.getParent();
        return new TreePath(new Object[]{_parent, pckg});
    }

    protected TreePath _getTreePath(QueryRegistryTreeEntry entry) {
        QueryRegistryTreePackage _parent = entry.getParent();
        TreePath _treePath = this.getTreePath(_parent);
        return _treePath.createChildPath((Object)entry);
    }

    public TreePath getTreePath(Object entry) {
        if (entry instanceof QueryRegistryTreeEntry) {
            return this._getTreePath((QueryRegistryTreeEntry)entry);
        }
        if (entry instanceof QueryRegistryTreePackage) {
            return this._getTreePath((QueryRegistryTreePackage)entry);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(entry).toString());
    }

    @Pure
    public Map<String, QueryRegistryTreeSource> getSources() {
        return this.sources;
    }

    @Pure
    public IQuerySpecificationRegistry getRegistry() {
        return this.registry;
    }

    @Pure
    public IRegistryView getView() {
        return this.view;
    }

    @Pure
    public QueryRegistryTreeViewListener getListener() {
        return this.listener;
    }
}

