/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.psystem.queries;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.TypeJudgement;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PDisjunction;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PProblem;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQueries;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.viatra.query.runtime.matchers.tuple.FlatTuple;

public abstract class BasePQuery
implements PQuery {
    protected PQuery.PQueryStatus status = PQuery.PQueryStatus.UNINITIALIZED;
    protected List<PProblem> pProblems = new ArrayList<PProblem>();
    private List<PAnnotation> annotations = new ArrayList<PAnnotation>();
    private QueryEvaluationHint evaluationHints = null;
    PDisjunction canonicalDisjunction;
    private List<Object> wrappingQuerySpecifications = new ArrayList<Object>(1);

    @Override
    public Integer getPositionOfParameter(String parameterName) {
        this.ensureInitializedSneaky();
        int index = this.getParameterNames().indexOf(parameterName);
        return index != -1 ? Integer.valueOf(index) : null;
    }

    protected void setStatus(PQuery.PQueryStatus newStatus) {
        this.status = newStatus;
    }

    protected void addError(PProblem problem) {
        this.status = PQuery.PQueryStatus.ERROR;
        this.pProblems.add(problem);
    }

    @Override
    public PQuery.PQueryStatus getStatus() {
        return this.status;
    }

    @Override
    public List<PProblem> getPProblems() {
        return Collections.unmodifiableList(this.pProblems);
    }

    @Override
    public boolean isMutable() {
        return this.status.equals((Object)PQuery.PQueryStatus.UNINITIALIZED) || this.status.equals((Object)PQuery.PQueryStatus.INITIALIZING);
    }

    @Override
    public void checkMutability() throws IllegalStateException {
        Preconditions.checkState((boolean)this.isMutable(), (Object)("Cannot edit query definition " + this.getFullyQualifiedName()));
    }

    public void setEvaluationHints(QueryEvaluationHint hints) {
        this.checkMutability();
        this.evaluationHints = hints;
    }

    @Override
    public QueryEvaluationHint getEvaluationHints() {
        this.ensureInitializedSneaky();
        return this.evaluationHints;
    }

    protected void addAnnotation(PAnnotation annotation) {
        this.checkMutability();
        this.annotations.add(annotation);
    }

    @Override
    public List<PAnnotation> getAllAnnotations() {
        this.ensureInitializedSneaky();
        return Lists.newArrayList(this.annotations);
    }

    @Override
    public List<PAnnotation> getAnnotationsByName(String annotationName) {
        this.ensureInitializedSneaky();
        return Lists.newArrayList((Iterable)Iterables.filter(this.annotations, (Predicate)new AnnotationNameTester(annotationName)));
    }

    @Override
    public PAnnotation getFirstAnnotationByName(String annotationName) {
        this.ensureInitializedSneaky();
        return (PAnnotation)Iterables.find(this.annotations, (Predicate)new AnnotationNameTester(annotationName), null);
    }

    @Override
    public List<String> getParameterNames() {
        this.ensureInitializedSneaky();
        return Lists.transform(this.getParameters(), PQueries.parameterNameFunction());
    }

    @Override
    public Set<PQuery> getDirectReferredQueries() {
        this.ensureInitializedSneaky();
        return this.canonicalDisjunction.getDirectReferredQueries();
    }

    @Override
    public Set<PQuery> getAllReferredQueries() {
        this.ensureInitializedSneaky();
        return this.canonicalDisjunction.getAllReferredQueries();
    }

    @Override
    public List<Object> publishedAs() {
        return this.wrappingQuerySpecifications;
    }

    @Override
    public Set<TypeJudgement> getTypeGuarantees() {
        this.ensureInitializedSneaky();
        HashSet<TypeJudgement> result = new HashSet<TypeJudgement>();
        List<PParameter> parameters = this.getParameters();
        int i = 0;
        while (i < parameters.size()) {
            PParameter parameter = parameters.get(i);
            IInputKey declaredUnaryType = parameter.getDeclaredUnaryType();
            if (declaredUnaryType != null) {
                result.add(new TypeJudgement(declaredUnaryType, new FlatTuple(i)));
            }
            ++i;
        }
        return result;
    }

    @Override
    public PDisjunction getDisjunctBodies() {
        this.ensureInitializedSneaky();
        Preconditions.checkState((!this.status.equals((Object)PQuery.PQueryStatus.ERROR) ? 1 : 0) != 0, (Object)("Query " + this.getFullyQualifiedName() + " contains errors."));
        return this.canonicalDisjunction;
    }

    @Override
    public final void ensureInitialized() throws QueryInitializationException {
        try {
            if (this.status.equals((Object)PQuery.PQueryStatus.UNINITIALIZED)) {
                this.setStatus(PQuery.PQueryStatus.INITIALIZING);
                this.setBodies(this.doGetContainedBodies());
                this.setStatus(PQuery.PQueryStatus.OK);
            }
        }
        catch (QueryInitializationException e) {
            this.addError(new PProblem(e, e.getShortMessage()));
            throw e;
        }
    }

    public final void ensureInitializedSneaky() {
        try {
            this.ensureInitialized();
        }
        catch (QueryInitializationException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void setBodies(Set<PBody> bodies) {
        this.canonicalDisjunction = new PDisjunction(this, bodies);
        for (PBody body : this.canonicalDisjunction.getBodies()) {
            body.setStatus(null);
        }
        this.setStatus(PQuery.PQueryStatus.OK);
    }

    protected abstract Set<PBody> doGetContainedBodies() throws QueryInitializationException;

    public String toString() {
        return String.format("PQuery<%s>=%s", this.getFullyQualifiedName(), super.toString());
    }

    private static final class AnnotationNameTester
    implements Predicate<PAnnotation> {
        private final String annotationName;

        private AnnotationNameTester(String annotationName) {
            this.annotationName = annotationName;
        }

        public boolean apply(PAnnotation annotation) {
            return annotation == null ? false : this.annotationName.equals(annotation.getName());
        }
    }
}

