/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.backend.historytree;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.IntegerRangeCondition;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTConfig;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTInterval;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.IHistoryTree;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.ParentNode;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;

public abstract class HTNode {
    private static final int COMMON_HEADER_SIZE = 38;
    private final HTConfig fConfig;
    private final long fNodeStart;
    private long fNodeEnd;
    private int fMinQuark = Integer.MAX_VALUE;
    private int fMaxQuark = Integer.MIN_VALUE;
    private final int fSequenceNumber;
    private int fParentSequenceNumber;
    private int fSizeOfIntervalSection;
    private volatile boolean fIsOnDisk;
    private final List<HTInterval> fIntervals;
    private final ReentrantReadWriteLock fRwl = new ReentrantReadWriteLock(false);
    private static final Comparator<ITmfStateInterval> NODE_ORDER = Comparator.comparingLong(ITmfStateInterval::getEndTime).thenComparingLong(ITmfStateInterval::getStartTime).thenComparingInt(ITmfStateInterval::getAttribute);

    protected HTNode(HTConfig config, int seqNumber, int parentSeqNumber, long start) {
        this.fConfig = config;
        this.fNodeStart = start;
        this.fSequenceNumber = seqNumber;
        this.fParentSequenceNumber = parentSeqNumber;
        this.fSizeOfIntervalSection = 0;
        this.fIsOnDisk = false;
        this.fIntervals = new ArrayList<HTInterval>();
    }

    public static final @NonNull HTNode readNode(HTConfig config, FileChannel fc, IHistoryTree.IHTNodeFactory nodeFactory) throws IOException {
        HTNode newNode = null;
        ByteBuffer buffer = ByteBuffer.allocate(config.getBlockSize());
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.clear();
        int res = fc.read(buffer);
        assert (res == config.getBlockSize());
        buffer.flip();
        byte typeByte = buffer.get();
        NodeType type = NodeType.fromByte(typeByte);
        long start = buffer.getLong();
        long end = buffer.getLong();
        int min = buffer.getInt();
        int max = buffer.getInt();
        int seqNb = buffer.getInt();
        int parentSeqNb = buffer.getInt();
        int intervalCount = buffer.getInt();
        buffer.get();
        switch (type) {
            case CORE: {
                newNode = nodeFactory.createCoreNode(config, seqNb, parentSeqNb, start);
                newNode.readSpecificHeader(buffer);
                break;
            }
            case LEAF: {
                newNode = nodeFactory.createLeafNode(config, seqNb, parentSeqNb, start);
                newNode.readSpecificHeader(buffer);
                break;
            }
            default: {
                throw new IOException();
            }
        }
        int i = 0;
        while (i < intervalCount) {
            HTInterval interval = HTInterval.readFrom(buffer);
            newNode.fIntervals.add(interval);
            newNode.fSizeOfIntervalSection += interval.getSizeOnDisk();
            ++i;
        }
        newNode.fNodeEnd = end;
        newNode.fMinQuark = min;
        newNode.fMaxQuark = max;
        newNode.fIsOnDisk = true;
        return newNode;
    }

    /*
     * Unable to fully structure code
     */
    public final void writeSelf(FileChannel fc) throws IOException {
        this.fRwl.readLock().lock();
        try {
            blockSize = this.fConfig.getBlockSize();
            buffer = ByteBuffer.allocate(blockSize);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.clear();
            buffer.put(this.getNodeType().toByte());
            buffer.putLong(this.fNodeStart);
            buffer.putLong(this.fNodeEnd);
            buffer.putInt(this.fMinQuark);
            buffer.putInt(this.fMaxQuark);
            buffer.putInt(this.fSequenceNumber);
            buffer.putInt(this.fParentSequenceNumber);
            buffer.putInt(this.fIntervals.size());
            buffer.put((byte)1);
            this.writeSpecificHeader(buffer);
            this.fIntervals.forEach((Consumer<HTInterval>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$0(java.nio.ByteBuffer org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTInterval ), (Lorg/eclipse/tracecompass/internal/statesystem/core/backend/historytree/HTInterval;)V)((ByteBuffer)buffer));
            if (blockSize - buffer.position() == this.getNodeFreeSpace()) ** GOTO lbl33
            throw new IllegalStateException("Wrong free space: Actual: " + (blockSize - buffer.position()) + ", Expected: " + this.getNodeFreeSpace());
lbl-1000:
            // 1 sources

            {
                buffer.put((byte)0);
lbl33:
                // 2 sources

                ** while (buffer.position() < blockSize)
            }
lbl34:
            // 1 sources

            buffer.flip();
            res = fc.write(buffer);
            if (res != blockSize) {
                throw new IllegalStateException("Wrong size of block written: Actual: " + res + ", Expected: " + blockSize);
            }
        }
        finally {
            this.fRwl.readLock().unlock();
        }
        this.fIsOnDisk = true;
    }

    protected HTConfig getConfig() {
        return this.fConfig;
    }

    public long getNodeStart() {
        return this.fNodeStart;
    }

    public long getNodeEnd() {
        this.fRwl.readLock().lock();
        try {
            long l = this.fNodeEnd;
            return l;
        }
        finally {
            this.fRwl.readLock().unlock();
        }
    }

    public int getSequenceNumber() {
        return this.fSequenceNumber;
    }

    public int getParentSequenceNumber() {
        return this.fParentSequenceNumber;
    }

    public void setParentSequenceNumber(int newParent) {
        this.fParentSequenceNumber = newParent;
    }

    public boolean isOnDisk() {
        return this.fIsOnDisk;
    }

    public void addInterval(HTInterval newInterval) {
        this.fRwl.writeLock().lock();
        try {
            assert (newInterval.getSizeOnDisk() <= this.getNodeFreeSpace());
            int index = 0;
            if (!this.fIntervals.isEmpty()) {
                index = Collections.binarySearch(this.fIntervals, newInterval, NODE_ORDER);
                index = -index - 1;
            }
            this.fIntervals.add(index, newInterval);
            this.fNodeEnd = Long.max(this.fNodeEnd, newInterval.getEndTime());
            this.fMinQuark = Integer.min(this.fMinQuark, newInterval.getAttribute());
            this.fMaxQuark = Integer.max(this.fMaxQuark, newInterval.getAttribute());
            this.fSizeOfIntervalSection += newInterval.getSizeOnDisk();
        }
        finally {
            this.fRwl.writeLock().unlock();
        }
    }

    public void closeThisNode(long endtime) {
        this.fRwl.writeLock().lock();
        try {
            if (this.fNodeEnd > endtime) {
                throw new IllegalArgumentException("Closing end time should be greater than or equal to the end time of the intervals of this node");
            }
            this.fNodeEnd = endtime;
        }
        finally {
            this.fRwl.writeLock().unlock();
        }
    }

    public void writeInfoFromNode(List<ITmfStateInterval> stateInfo, long t) throws TimeRangeException {
        this.fRwl.readLock().lock();
        try {
            int i = this.getStartIndexFor(t);
            while (i < this.fIntervals.size()) {
                ITmfStateInterval interval = this.fIntervals.get(i);
                if (t >= interval.getStartTime() && interval.getAttribute() < stateInfo.size()) {
                    stateInfo.set(interval.getAttribute(), interval);
                }
                ++i;
            }
        }
        finally {
            this.fRwl.readLock().unlock();
        }
    }

    public HTInterval getRelevantInterval(int key, long t) throws TimeRangeException {
        this.fRwl.readLock().lock();
        try {
            int i = this.getStartIndexFor(t);
            while (i < this.fIntervals.size()) {
                HTInterval curInterval = this.fIntervals.get(i);
                if (curInterval.getAttribute() == key && curInterval.getStartTime() <= t) {
                    HTInterval hTInterval = curInterval;
                    return hTInterval;
                }
                ++i;
            }
            return null;
        }
        finally {
            this.fRwl.readLock().unlock();
        }
    }

    public Iterable<HTInterval> iterable2D(IntegerRangeCondition quarks, TimeRangeCondition times) {
        this.fRwl.readLock().lock();
        try {
            IntegerRangeCondition subQuarks = quarks.subCondition(this.fMinQuark, this.fMaxQuark);
            if (subQuarks == null) {
                List<HTInterval> list = Collections.emptyList();
                return list;
            }
            TimeRangeCondition subTimes = times.subCondition(this.fNodeStart, this.fNodeEnd);
            if (subTimes == null) {
                List<HTInterval> list = Collections.emptyList();
                return list;
            }
            long start = subTimes.min();
            ArrayList<HTInterval> intervals = new ArrayList<HTInterval>();
            for (HTInterval interval : this.fIntervals.subList(this.getStartIndexFor(start), this.fIntervals.size())) {
                if (!subQuarks.test(interval.getAttribute()) || !subTimes.intersects(interval.getStartTime(), interval.getEndTime())) continue;
                intervals.add(interval);
            }
            ArrayList<HTInterval> arrayList = intervals;
            return arrayList;
        }
        finally {
            this.fRwl.readLock().unlock();
        }
    }

    private int getStartIndexFor(long t) throws TimeRangeException {
        if (this.fIntervals.isEmpty()) {
            return 0;
        }
        HTInterval dummy = new HTInterval(Long.MIN_VALUE, t, 0, null);
        int index = Collections.binarySearch(this.fIntervals, dummy, NODE_ORDER);
        return index >= 0 ? index : -index - 1;
    }

    public final int getTotalHeaderSize() {
        return 38 + this.getSpecificHeaderSize();
    }

    private int getDataSectionEndOffset() {
        return this.getTotalHeaderSize() + this.fSizeOfIntervalSection;
    }

    public int getNodeFreeSpace() {
        this.fRwl.readLock().lock();
        int ret = this.fConfig.getBlockSize() - this.getDataSectionEndOffset();
        this.fRwl.readLock().unlock();
        return ret;
    }

    public long getNodeUsagePercent() {
        this.fRwl.readLock().lock();
        try {
            int blockSize = this.fConfig.getBlockSize();
            float freePercent = (float)this.getNodeFreeSpace() / (float)(blockSize - this.getTotalHeaderSize()) * 100.0f;
            long l = (long)(100.0f - freePercent);
            return l;
        }
        finally {
            this.fRwl.readLock().unlock();
        }
    }

    public int getMinQuark() {
        this.fRwl.readLock().lock();
        try {
            int n = this.fMinQuark;
            return n;
        }
        finally {
            this.fRwl.readLock().unlock();
        }
    }

    public int getMaxQuark() {
        this.fRwl.readLock().lock();
        try {
            int n = this.fMaxQuark;
            return n;
        }
        finally {
            this.fRwl.readLock().unlock();
        }
    }

    public String toString() {
        return String.format("Node #%d, %s, %s, %d intervals (%d%% used), [%d - %s]", this.fSequenceNumber, this.fParentSequenceNumber == -1 ? "Root" : "Parent #" + this.fParentSequenceNumber, this.toStringSpecific(), this.fIntervals.size(), this.getNodeUsagePercent(), this.fNodeStart, this.fIsOnDisk || this.fNodeEnd != 0L ? Long.valueOf(this.fNodeEnd) : "...");
    }

    public void debugPrintIntervals(PrintWriter writer) {
        writer.println("Intervals for node #" + this.fSequenceNumber + ":");
        if (this.getNodeType() != NodeType.LEAF) {
            ParentNode thisNode = (ParentNode)this;
            writer.print("  " + thisNode.getNbChildren() + " children");
            if (thisNode.getNbChildren() >= 1) {
                writer.print(": [ " + thisNode.getChild(0));
                int i = 1;
                while (i < thisNode.getNbChildren()) {
                    writer.print(", " + thisNode.getChild(i));
                    ++i;
                }
                writer.print(']');
            }
            writer.print('\n');
        }
        writer.println("  Intervals contained:");
        int i = 0;
        while (i < this.fIntervals.size()) {
            writer.println(this.fIntervals.get(i).toString());
            ++i;
        }
        writer.println('\n');
    }

    public abstract NodeType getNodeType();

    protected abstract int getSpecificHeaderSize();

    protected abstract void readSpecificHeader(ByteBuffer var1);

    protected abstract void writeSpecificHeader(ByteBuffer var1);

    protected abstract String toStringSpecific();

    private static /* synthetic */ void lambda$0(ByteBuffer byteBuffer, HTInterval i) {
        i.writeInterval(byteBuffer);
    }

    public static enum NodeType {
        CORE,
        LEAF;


        public static NodeType fromByte(byte rep) throws IOException {
            switch (rep) {
                case 1: {
                    return CORE;
                }
                case 2: {
                    return LEAF;
                }
            }
            throw new IOException();
        }

        public byte toByte() {
            switch (this) {
                case CORE: {
                    return 1;
                }
                case LEAF: {
                    return 2;
                }
            }
            throw new IllegalStateException();
        }
    }
}

