/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.counters.core;

import com.google.common.collect.BiMap;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.TreeMultimap;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.counters.core.CounterAnalysis;
import org.eclipse.tracecompass.internal.analysis.counters.core.Messages;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.AbstractStateSystemAnalysisDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.TmfCommonXAxisResponseFactory;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectedCounterQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfCommonXAxisModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.internal.tmf.core.model.YModel;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

public class CounterDataProvider
extends AbstractStateSystemAnalysisDataProvider
implements ITmfTreeXYDataProvider<TmfTreeDataModel> {
    public static final String ID = "org.eclipse.tracecompass.analysis.counters.core.CounterDataProvider";
    private static final String TITLE = Objects.requireNonNull(Messages.CounterDataProvider_ChartTitle);
    private static final AtomicLong COUNTER_ENTRY_ID = new AtomicLong();
    private final CounterAnalysis fModule;
    private final BiMap<Long, Integer> fIdToQuark = HashBiMap.create();
    private final Map<Integer, TmfTreeDataModel> fQuarkToEntry = new LinkedHashMap<Integer, TmfTreeDataModel>();
    private @Nullable TmfModelResponse<List<TmfTreeDataModel>> fCached = null;

    public static @Nullable CounterDataProvider create(ITmfTrace trace, @Nullable CounterAnalysis module) {
        if (trace instanceof TmfExperiment) {
            throw new UnsupportedOperationException("This data providers does not support experiment");
        }
        if (module != null) {
            module.schedule();
            return new CounterDataProvider(trace, module);
        }
        return null;
    }

    private CounterDataProvider(ITmfTrace trace, CounterAnalysis analysis) {
        super(trace);
        this.fModule = analysis;
    }

    public TmfModelResponse<List<TmfTreeDataModel>> fetchTree(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        if (this.fCached != null) {
            return this.fCached;
        }
        this.fModule.waitForInitialization();
        ITmfStateSystem ss = this.fModule.getStateSystem();
        if (ss == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.STATE_SYSTEM_FAILED);
        }
        boolean complete = ss.waitUntilBuilt(0L);
        TmfTreeDataModel trace = this.fQuarkToEntry.get(-1);
        if (trace == null) {
            trace = new TmfTreeDataModel(COUNTER_ENTRY_ID.getAndIncrement(), -1L, this.getTrace().getName());
            this.fQuarkToEntry.put(-1, trace);
        }
        this.addTreeViewerBranch(ss, trace, "Grouped");
        this.addTreeViewerBranch(ss, trace, "Ungrouped");
        ArrayList<TmfTreeDataModel> model = new ArrayList<TmfTreeDataModel>(this.fQuarkToEntry.values());
        if (complete) {
            TmfModelResponse response;
            this.fCached = response = new TmfModelResponse(model, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        return new TmfModelResponse(model, ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
    }

    private void addTreeViewerBranch(ITmfStateSystem stateSystem, TmfTreeDataModel rootBranch, String branchName) {
        int quark = stateSystem.optQuarkAbsolute(new String[]{branchName});
        if (quark != -2 && !stateSystem.getSubAttributes(quark, false).isEmpty()) {
            TmfTreeDataModel branch = this.fQuarkToEntry.get(quark);
            if (branch == null) {
                branch = new TmfTreeDataModel(COUNTER_ENTRY_ID.getAndIncrement(), rootBranch.getId(), branchName);
                this.fQuarkToEntry.put(quark, branch);
            }
            this.addTreeViewerEntries(stateSystem, branch, quark);
        }
    }

    private void addTreeViewerEntries(ITmfStateSystem ss, TmfTreeDataModel parentBranch, int quark) {
        Iterator iterator = ss.getSubAttributes(quark, false).iterator();
        while (iterator.hasNext()) {
            int childQuark = (Integer)iterator.next();
            TmfTreeDataModel childBranch = this.fQuarkToEntry.get(childQuark);
            if (childBranch == null) {
                long id = COUNTER_ENTRY_ID.getAndIncrement();
                if (ss.getSubAttributes(childQuark, false).isEmpty()) {
                    this.fIdToQuark.put((Object)id, (Object)childQuark);
                }
                childBranch = new TmfTreeDataModel(id, parentBranch.getId(), ss.getAttributeName(childQuark));
                this.fQuarkToEntry.put(childQuark, childBranch);
            }
            this.addTreeViewerEntries(ss, childBranch, childQuark);
        }
    }

    public TmfModelResponse<ITmfCommonXAxisModel> fetchXY(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        if (filter instanceof SelectedCounterQueryFilter) {
            SelectedCounterQueryFilter selection = (SelectedCounterQueryFilter)filter;
            return this.internalFetch(this.getSelectedQuarks(selection), selection, monitor);
        }
        return TmfCommonXAxisResponseFactory.create((String)TITLE, (long[])filter.getTimesRequested(), Collections.emptyMap(), (boolean)true);
    }

    private Collection<Integer> getSelectedQuarks(SelectedCounterQueryFilter filter) {
        HashSet<Integer> quarks = new HashSet<Integer>();
        for (Long selectedItem : filter.getSelectedItems()) {
            Integer quark = (Integer)this.fIdToQuark.get((Object)selectedItem);
            if (quark == null) continue;
            quarks.add(quark);
        }
        return quarks;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private TmfModelResponse<ITmfCommonXAxisModel> internalFetch(Collection<Integer> selectedQuarks, SelectedCounterQueryFilter filter, @Nullable IProgressMonitor monitor) {
        ITmfStateSystem ss = Objects.requireNonNull(this.fModule.getStateSystem());
        long stateSystemEndTime = ss.getCurrentEndTime();
        Collection<Long> times = CounterDataProvider.extractRequestedTimes(ss, filter, stateSystemEndTime);
        TreeMultimap countersIntervals = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparingLong(ITmfStateInterval::getStartTime));
        try {
            @NonNull Iterable query2d = ss.query2D(selectedQuarks, times);
            for (ITmfStateInterval interval : query2d) {
                if (monitor != null && monitor.isCanceled()) {
                    return TmfCommonXAxisResponseFactory.createCancelledResponse((String)CommonStatusMessage.TASK_CANCELLED);
                }
                countersIntervals.put((Object)interval.getAttribute(), (Object)interval);
            }
            ImmutableMap.Builder ySeries = ImmutableMap.builder();
            for (Integer quark : selectedQuarks) {
                if (monitor != null && monitor.isCanceled()) {
                    return TmfCommonXAxisResponseFactory.createCancelledResponse((String)CommonStatusMessage.TASK_CANCELLED);
                }
                double[] yValues = CounterDataProvider.buildYValues(countersIntervals.get((Object)quark), filter);
                String seriesName = String.valueOf(this.getTrace().getName()) + '/' + ss.getFullAttributePath(quark.intValue());
                ySeries.put((Object)seriesName, (Object)new YModel(seriesName, yValues));
            }
            boolean complete = ss.waitUntilBuilt(0L) || filter.getEnd() <= stateSystemEndTime;
            return TmfCommonXAxisResponseFactory.create((String)TITLE, (long[])filter.getTimesRequested(), (Map)ySeries.build(), (boolean)complete);
        }
        catch (IndexOutOfBoundsException | TimeRangeException e) {
            return TmfCommonXAxisResponseFactory.createFailedResponse((String)e.getMessage());
        }
        catch (StateSystemDisposedException e) {
            return TmfCommonXAxisResponseFactory.create((String)TITLE, (long[])filter.getTimesRequested(), Collections.emptyMap(), (boolean)true);
        }
    }

    private static Collection<Long> extractRequestedTimes(ITmfStateSystem ss, SelectedCounterQueryFilter filter, long currentEndTime) {
        long prevTime;
        ArrayList<Long> times = new ArrayList<Long>();
        long[] xValues = filter.getTimesRequested();
        long queryStart = filter.getStart();
        long stateSystemStartTime = ss.getStartTime();
        if (!filter.isCumulative() && (prevTime = Long.max(stateSystemStartTime, 2L * queryStart - xValues[1])) <= currentEndTime) {
            times.add(prevTime);
        }
        times.addAll(Collections2.filter((Collection)Longs.asList((long[])xValues), t -> stateSystemStartTime <= t && t <= currentEndTime));
        return times;
    }

    private static double[] buildYValues(NavigableSet<ITmfStateInterval> countersIntervals, SelectedCounterQueryFilter filter) {
        Object value;
        long[] times = filter.getTimesRequested();
        boolean isCumulative = filter.isCumulative();
        double[] yValues = new double[times.length];
        long prevValue = 0L;
        if (!countersIntervals.isEmpty() && (value = ((ITmfStateInterval)countersIntervals.first()).getValue()) instanceof Number) {
            prevValue = ((Number)value).longValue();
        }
        int to = 0;
        for (ITmfStateInterval interval : countersIntervals) {
            long l;
            int from = Arrays.binarySearch(times, interval.getStartTime());
            from = from >= 0 ? from : -1 - from;
            Number value2 = (Number)interval.getValue();
            long l2 = l = value2 != null ? value2.longValue() : 0L;
            if (isCumulative) {
                to = Arrays.binarySearch(times, interval.getEndTime());
                to = to >= 0 ? to + 1 : -1 - to;
                Arrays.fill(yValues, from, to, (double)l);
            } else {
                yValues[from] = l - prevValue;
            }
            prevValue = l;
        }
        if (isCumulative) {
            Arrays.fill(yValues, to, yValues.length, (double)prevValue);
        }
        return yValues;
    }

    public static String getTitle() {
        return TITLE;
    }

    public String getId() {
        return ID;
    }
}

