/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.info;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamProvider;
import org.eclipse.team.svn.core.connector.SVNConflictDescriptor;
import org.eclipse.team.svn.core.connector.SVNEntryInfo;
import org.eclipse.team.svn.core.connector.SVNLock;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IResourcePropertyProvider;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.operation.local.InfoOperation;
import org.eclipse.team.svn.core.operation.local.property.GetPropertiesOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.PropertiesComposite;
import org.eclipse.team.svn.ui.utility.DateFormatter;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class LocalInfoPage
extends PropertyPage {
    protected PropertiesComposite properties;
    protected IResource resource;
    protected ILocalResource local;
    protected Button verifyTagButton;
    protected boolean isVerifyTagOnCommit;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        composite.setLayoutData((Object)data);
        this.resource = (IResource)this.getElement().getAdapter(IResource.class);
        InfoOperation op = new InfoOperation(this.resource);
        UIMonitorUtility.doTaskBusyDefault((IActionOperation)op);
        this.local = op.getLocal();
        if (!(this.resource instanceof IProject)) {
            this.noDefaultAndApplyButton();
        }
        Label description = new Label(composite, 64);
        description.setLayoutData((Object)new GridData());
        description.setText(SVNUIMessages.LocalInfoPage_LocalPath);
        Text content = new Text(composite, 64);
        data = new GridData();
        data.widthHint = 300;
        content.setLayoutData((Object)data);
        content.setEditable(false);
        content.setText(this.resource.getFullPath().toString());
        description = new Label(composite, 64);
        description.setLayoutData((Object)new GridData());
        description.setText(SVNUIMessages.LocalInfoPage_TextStatus);
        content = new Text(composite, 4);
        content.setLayoutData((Object)new GridData());
        content.setEditable(false);
        content.setText(SVNUtility.getStatusText((String)this.local.getTextStatus()));
        description = new Label(composite, 64);
        description.setLayoutData((Object)new GridData());
        description.setText(SVNUIMessages.LocalInfoPage_PropertyStatus);
        content = new Text(composite, 4);
        content.setLayoutData((Object)new GridData());
        content.setEditable(false);
        content.setText(SVNUtility.getStatusText((String)this.local.getPropStatus()));
        description = new Label(composite, 64);
        description.setLayoutData((Object)new GridData());
        description.setText(SVNUIMessages.LocalInfoPage_Copied);
        content = new Text(composite, 4);
        content.setLayoutData((Object)new GridData());
        content.setEditable(false);
        content.setText(String.valueOf(this.local.isCopied()));
        SVNEntryInfo info = op.getInfo();
        if (IStateFilter.SF_ONREPOSITORY.accept(this.local) && info != null) {
            new Label(composite, 64);
            new Label(composite, 64);
            description = new Label(composite, 64);
            description.setLayoutData((Object)new GridData(2));
            description.setText(SVNUIMessages.LocalInfoPage_ResourceURL);
            content = new Text(composite, 64);
            data = new GridData();
            data.widthHint = 300;
            content.setLayoutData((Object)data);
            content.setEditable(false);
            content.setText(SVNUtility.decodeURL((String)info.url));
            description = new Label(composite, 64);
            description.setLayoutData((Object)new GridData());
            description.setText(SVNUIMessages.LocalInfoPage_Revision);
            content = new Text(composite, 4);
            content.setLayoutData((Object)new GridData());
            content.setEditable(false);
            content.setText(String.valueOf(info.revision));
            description = new Label(composite, 64);
            description.setLayoutData((Object)new GridData());
            description.setText(SVNUIMessages.LocalInfoPage_LastChangedAuthor);
            content = new Text(composite, 4);
            content.setLayoutData((Object)new GridData());
            content.setEditable(false);
            content.setText(info.lastChangedAuthor == null ? SVNMessages.SVNInfo_NoAuthor : info.lastChangedAuthor);
            description = new Label(composite, 64);
            description.setLayoutData((Object)new GridData());
            description.setText(SVNUIMessages.LocalInfoPage_LastChangedDate);
            content = new Text(composite, 4);
            content.setLayoutData((Object)new GridData());
            content.setEditable(false);
            content.setText(info.lastChangedDate == 0L ? SVNMessages.SVNInfo_NoDate : DateFormatter.formatDate(info.lastChangedDate));
            description = new Label(composite, 64);
            description.setLayoutData((Object)new GridData());
            description.setText(SVNUIMessages.LocalInfoPage_LastChangedRevision);
            content = new Text(composite, 4);
            content.setLayoutData((Object)new GridData());
            content.setEditable(false);
            content.setText(String.valueOf(info.lastChangedRevision));
            SVNLock lock = info.lock;
            if (lock != null) {
                new Label(composite, 64);
                new Label(composite, 64);
                description = new Label(composite, 64);
                description.setLayoutData((Object)new GridData());
                description.setText(SVNUIMessages.LocalInfoPage_LockOwner);
                content = new Text(composite, 4);
                content.setLayoutData((Object)new GridData());
                content.setEditable(false);
                content.setText(lock.owner == null ? SVNMessages.SVNInfo_NoAuthor : lock.owner);
                description = new Label(composite, 64);
                description.setLayoutData((Object)new GridData());
                description.setText(SVNUIMessages.LocalInfoPage_LockComment);
                content = new Text(composite, 4);
                content.setLayoutData((Object)new GridData());
                content.setEditable(false);
                content.setText(lock.comment == null ? SVNMessages.SVNInfo_NoComment : lock.comment);
                description = new Label(composite, 64);
                description.setLayoutData((Object)new GridData());
                description.setText(SVNUIMessages.LocalInfoPage_LockCreationDate);
                content = new Text(composite, 4);
                content.setLayoutData((Object)new GridData());
                content.setEditable(false);
                content.setText(lock.creationDate == 0L ? SVNMessages.SVNInfo_NoAuthor : DateFormatter.formatDate(lock.creationDate));
                if (lock.expirationDate != 0L) {
                    description = new Label(composite, 64);
                    description.setLayoutData((Object)new GridData());
                    description.setText(SVNUIMessages.LocalInfoPage_LockExpirationDate);
                    content = new Text(composite, 4);
                    content.setLayoutData((Object)new GridData());
                    content.setEditable(false);
                    content.setText(lock.expirationDate == 0L ? SVNMessages.SVNInfo_NoDate : DateFormatter.formatDate(lock.expirationDate));
                }
            }
        }
        if (this.local.hasTreeConflict()) {
            new Label(composite, 64);
            new Label(composite, 64);
            description = new Label(composite, 64);
            description.setLayoutData((Object)new GridData());
            description.setText(SVNUIMessages.LocalInfoPage_TreeConflict);
            content = new Text(composite, 64);
            data = new GridData();
            data.widthHint = 300;
            content.setLayoutData((Object)data);
            content.setEditable(false);
            content.setText(this.getTreeConflictDescription(this.local.getTreeConflictDescriptor()));
        }
        this.createOptions(composite);
        if (IStateFilter.SF_VERSIONED.accept(this.local)) {
            new Label(composite, 64);
            new Label(composite, 64);
            Composite group = new Composite(composite, 2048);
            data = new GridData(1808);
            data.horizontalSpan = 2;
            group.setLayoutData((Object)data);
            layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            group.setLayout((Layout)layout);
            this.properties = new PropertiesComposite(group);
            GetPropertiesOperation propertyProvider = new GetPropertiesOperation(this.resource);
            UIMonitorUtility.doTaskBusyDefault((IActionOperation)propertyProvider);
            this.properties.setResource((IAdaptable)this.resource, (IResourcePropertyProvider)propertyProvider);
            UIMonitorUtility.doTaskBusyDefault(this.properties.getRefreshViewOperation());
            this.properties.setLayoutData(new GridData(1808));
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.team.svn.help.SVNInfoContext");
        return composite;
    }

    protected String getTreeConflictDescription(SVNConflictDescriptor conflictDescriptor) {
        String reason = "";
        String action = "";
        String operation = "";
        switch (conflictDescriptor.reason) {
            case MODIFIED: {
                reason = "edit";
                break;
            }
            case OBSTRUCTED: {
                reason = "obstruction";
                break;
            }
            case DELETED: {
                reason = "delete";
                break;
            }
            case MISSING: {
                reason = "missing";
                break;
            }
            case UNVERSIONED: {
                reason = "unversioned";
                break;
            }
            case ADDED: {
                reason = "add";
                break;
            }
            case MOVED_AWAY: {
                reason = "moved away";
                break;
            }
            case MOVED_HERE: {
                reason = "moved here";
                break;
            }
            case REPLACED: {
                reason = "replaced";
            }
        }
        switch (conflictDescriptor.action) {
            case MODIFY: {
                action = "edit";
                break;
            }
            case ADD: {
                action = "add";
                break;
            }
            case DELETE: {
                action = "delete";
                break;
            }
            case REPLACE: {
                action = "replace";
            }
        }
        switch (conflictDescriptor.operation) {
            case NONE: {
                operation = "none";
                break;
            }
            case UPDATE: {
                operation = "update";
                break;
            }
            case SWITCHED: {
                operation = "switch";
                break;
            }
            case MERGE: {
                operation = "merge";
            }
        }
        return SVNUIMessages.format((String)SVNUIMessages.LocalInfoPage_TreeConflictDescription, (Object[])new String[]{reason, action, operation});
    }

    protected void createOptions(Composite parent) {
        if (this.resource instanceof IProject) {
            SVNTeamProvider provider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)((IProject)this.resource), (String)"org.eclipse.team.svn.core.svnnature");
            new Label(parent, 64);
            new Label(parent, 64);
            this.verifyTagButton = new Button(parent, 32);
            GridData data = new GridData();
            data.horizontalSpan = 2;
            this.verifyTagButton.setLayoutData((Object)data);
            this.verifyTagButton.setText(SVNUIMessages.LocalInfoPage_VerifyTagModification);
            this.verifyTagButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    LocalInfoPage.this.isVerifyTagOnCommit = LocalInfoPage.this.verifyTagButton.getSelection();
                }
            });
            this.isVerifyTagOnCommit = provider.isVerifyTagOnCommit();
            this.verifyTagButton.setSelection(this.isVerifyTagOnCommit);
        }
    }

    public boolean performOk() {
        SVNTeamProvider provider;
        if (this.resource instanceof IProject && this.isVerifyTagOnCommit != (provider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)((IProject)this.resource), (String)"org.eclipse.team.svn.core.svnnature")).isVerifyTagOnCommit()) {
            try {
                provider.setVerifyTagOnCommit(this.isVerifyTagOnCommit);
            }
            catch (CoreException e) {
                LoggedOperation.reportError((String)((Object)((Object)this)).getClass().getName(), (Throwable)e);
            }
        }
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.isVerifyTagOnCommit = true;
        this.verifyTagButton.setSelection(true);
    }
}

