/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.ui.util.WindowUtil;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.PropertyChangeContributionItem;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsMessages;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ColorPropertyContributionItem
extends PropertyChangeContributionItem
implements Listener {
    private static final InventoryColorDescriptor WHITE = new InventoryColorDescriptor(new RGB(255, 255, 255), DiagramUIActionsMessages.ColorPropertyChangeAction_white);
    private static final InventoryColorDescriptor BLACK = new InventoryColorDescriptor(new RGB(0, 0, 0), DiagramUIActionsMessages.ColorPropertyChangeAction_black);
    private static final InventoryColorDescriptor LIGHT_GRAY = new InventoryColorDescriptor(new RGB(192, 192, 192), DiagramUIActionsMessages.ColorPropertyChangeAction_lightGray);
    private static final InventoryColorDescriptor GRAY = new InventoryColorDescriptor(new RGB(128, 128, 128), DiagramUIActionsMessages.ColorPropertyChangeAction_gray);
    private static final InventoryColorDescriptor DARK_GRAY = new InventoryColorDescriptor(new RGB(64, 64, 64), DiagramUIActionsMessages.ColorPropertyChangeAction_darkGray);
    private static final InventoryColorDescriptor RED = new InventoryColorDescriptor(new RGB(227, 164, 156), DiagramUIActionsMessages.ColorPropertyChangeAction_red);
    private static final InventoryColorDescriptor GREEN = new InventoryColorDescriptor(new RGB(166, 193, 152), DiagramUIActionsMessages.ColorPropertyChangeAction_green);
    private static final InventoryColorDescriptor BLUE = new InventoryColorDescriptor(new RGB(152, 168, 191), DiagramUIActionsMessages.ColorPropertyChangeAction_blue);
    private static final InventoryColorDescriptor YELLOW = new InventoryColorDescriptor(new RGB(225, 225, 135), DiagramUIActionsMessages.ColorPropertyChangeAction_yellow);
    private static final InventoryColorDescriptor PURPLE = new InventoryColorDescriptor(new RGB(184, 151, 192), DiagramUIActionsMessages.ColorPropertyChangeAction_magenta);
    private static final InventoryColorDescriptor TEAL = new InventoryColorDescriptor(new RGB(155, 199, 204), DiagramUIActionsMessages.ColorPropertyChangeAction_cyan);
    private static final InventoryColorDescriptor PINK = new InventoryColorDescriptor(new RGB(228, 179, 229), DiagramUIActionsMessages.ColorPropertyChangeAction_pink);
    private static final InventoryColorDescriptor ORANGE = new InventoryColorDescriptor(new RGB(237, 201, 122), DiagramUIActionsMessages.ColorPropertyChangeAction_orange);
    private static final Point ICON_SIZE = new Point(16, 16);
    private static final int CUSTOM_SIZE = 3;
    private static final RGB DEFAULT_PREF_COLOR = new RGB(0, 0, 0);
    private static final RGB OUTLINE_COLOR = new RGB(192, 192, 192);
    private static final String DEFAULT = "Default";
    private static final String CHOOSE = "Choose";
    private static final String CLEAR = "Clear";
    private ImageData basicImageData;
    private ImageData disabledBasicImageData;
    private Image disabledBasicImage;
    private Image overlyedImage;
    private Integer lastColor;
    private List customColors = new ArrayList();
    private List inventoryColors = new ArrayList();
    private HashMap imageColorMap = new HashMap();
    private Menu menu;

    public ColorPropertyContributionItem(IWorkbenchPage workbenchPage, String id, String propertyId, String propertyName, String toolTipText, ImageData basicImageData, ImageData disabledBasicImageData) {
        super(workbenchPage, id, propertyId, propertyName);
        assert (toolTipText != null);
        assert (basicImageData != null);
        this.basicImageData = basicImageData;
        this.disabledBasicImageData = disabledBasicImageData;
        this.setLabel(toolTipText);
    }

    protected void init() {
        super.init();
        super.setWorkbenchPart(this.getWorkbenchPart());
        this.overlyedImage = new ColorMenuImageDescriptor(this.getBasicImageData(), null).createImage();
        this.disabledBasicImage = new ColorMenuImageDescriptor(this.disabledBasicImageData, null).createImage();
    }

    public void dispose() {
        if (this.overlyedImage != null && !this.overlyedImage.isDisposed()) {
            this.overlyedImage.dispose();
            this.overlyedImage = null;
        }
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
            this.menu = null;
        }
        for (Image image : this.imageColorMap.values()) {
            if (image.isDisposed()) continue;
            image.dispose();
        }
        if (this.disabledBasicImage != null && !this.disabledBasicImage.isDisposed()) {
            this.disabledBasicImage.dispose();
            this.disabledBasicImage = null;
        }
        this.imageColorMap = new HashMap();
        super.dispose();
    }

    protected ToolItem createToolItem(ToolBar parent, int index) {
        ToolItem ti = new ToolItem(parent, 4, index);
        ti.addListener(13, this.getItemListener());
        ti.setImage(this.overlyedImage);
        ti.setDisabledImage(this.disabledBasicImage);
        return ti;
    }

    protected MenuItem createMenuItem(Menu parent, int index) {
        MenuItem mi = index >= 0 ? new MenuItem(parent, 64, index) : new MenuItem(parent, 64);
        this.createMenu((Item)mi);
        mi.setImage(this.overlyedImage);
        return mi;
    }

    protected void handleWidgetEvent(Event e) {
        switch (e.type) {
            case 13: {
                this.handleWidgetSelection(e);
                break;
            }
            default: {
                super.handleWidgetEvent(e);
            }
        }
    }

    private void handleWidgetSelection(Event e) {
        if (e.detail == 4) {
            this.createMenu(this.getItem());
        } else if (this.lastColor != null) {
            this.runWithEvent(e);
        }
    }

    private void createMenu(Item item) {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        if (item instanceof ToolItem) {
            ToolItem toolItem = (ToolItem)item;
            this.menu = new Menu((Control)toolItem.getParent());
            Rectangle b = toolItem.getBounds();
            Point p = toolItem.getParent().toDisplay(new Point(b.x, b.y + b.height));
            this.menu.setLocation(p.x, p.y);
            this.menu.setVisible(true);
        } else if (item instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)item;
            this.menu = new Menu(menuItem.getParent());
            menuItem.setMenu(this.menu);
        }
        assert (this.menu != null) : "falid to create menu";
        this.buildMenu(this.menu);
    }

    protected Object getNewPropertyValue() {
        return this.lastColor;
    }

    private void buildMenu(Menu theMenu) {
        this.createInventoryColorMenuItem(theMenu, WHITE);
        this.createInventoryColorMenuItem(theMenu, BLACK);
        this.createInventoryColorMenuItem(theMenu, LIGHT_GRAY);
        this.createInventoryColorMenuItem(theMenu, GRAY);
        this.createInventoryColorMenuItem(theMenu, DARK_GRAY);
        this.createInventoryColorMenuItem(theMenu, RED);
        this.createInventoryColorMenuItem(theMenu, GREEN);
        this.createInventoryColorMenuItem(theMenu, BLUE);
        this.createInventoryColorMenuItem(theMenu, YELLOW);
        this.createInventoryColorMenuItem(theMenu, PURPLE);
        this.createInventoryColorMenuItem(theMenu, TEAL);
        this.createInventoryColorMenuItem(theMenu, PINK);
        this.createInventoryColorMenuItem(theMenu, ORANGE);
        if (!this.customColors.isEmpty()) {
            this.createMenuSeparator(theMenu);
            for (RGB rgb : this.customColors) {
                this.createColorMenuItem(theMenu, rgb);
            }
            this.createClearCustomColorMenuItem(theMenu);
        }
        this.createMenuSeparator(theMenu);
        this.createChooseColorMenuItem(theMenu);
    }

    private void createMenuSeparator(Menu theMenu) {
        new MenuItem(theMenu, 2);
    }

    private void createInventoryColorMenuItem(Menu theMenu, InventoryColorDescriptor color) {
        RGB rgb = color.colorValue;
        Image image = (Image)this.imageColorMap.get(rgb);
        if (image == null) {
            image = new ColorBoxImageDescriptor(color.colorValue).createImage();
            this.imageColorMap.put(rgb, image);
        }
        MenuItem mi = this.createMenuItem(theMenu, color.colorName, image);
        mi.setData((Object)rgb);
        this.inventoryColors.add(rgb);
    }

    private void createColorMenuItem(Menu theMenu, RGB rgb) {
        Image image = (Image)this.imageColorMap.get(rgb);
        if (image == null) {
            image = new ColorBoxImageDescriptor(rgb).createImage();
            this.imageColorMap.put(rgb, image);
        }
        MenuItem mi = this.createMenuItem(theMenu, rgb.toString(), image);
        mi.setData((Object)rgb);
    }

    private void createChooseColorMenuItem(Menu theMenu) {
        String text = DiagramUIActionsMessages.ColorPropertyChangeAction_moreColors;
        Image image = null;
        MenuItem mi = this.createMenuItem(theMenu, text, image);
        mi.setData((Object)CHOOSE);
    }

    private void createClearCustomColorMenuItem(Menu theMenu) {
        String text = DiagramUIActionsMessages.ColorPropertyChangeAction_clearColors;
        Image image = null;
        MenuItem mi = this.createMenuItem(theMenu, text, image);
        mi.setData((Object)CLEAR);
    }

    private MenuItem createMenuItem(Menu theMenu, String text, Image image) {
        MenuItem mi = new MenuItem(theMenu, 8);
        if (text != null) {
            mi.setText(text);
        }
        if (image != null) {
            mi.setImage(image);
        }
        mi.addListener(13, (Listener)this);
        return mi;
    }

    public void handleEvent(Event event) {
        MenuItem menuItem = (MenuItem)event.widget;
        Object data = menuItem.getData();
        RGB rgb = null;
        if (data instanceof RGB) {
            rgb = (RGB)data;
        } else if (data.equals(CHOOSE)) {
            rgb = this.getBrowseColor();
        } else if (data.equals(DEFAULT)) {
            rgb = this.getDefaultColor();
        } else if (data.equals(CLEAR)) {
            this.customColors.clear();
        }
        if (rgb != null) {
            if (this.getToolItem() != null) {
                if (!this.customColors.contains(rgb) && !this.inventoryColors.contains(rgb)) {
                    if (this.customColors.size() == 3) {
                        this.customColors.remove(0);
                    }
                    this.customColors.add(rgb);
                }
                if (this.overlyedImage != null) {
                    this.overlyedImage.dispose();
                }
                this.overlyedImage = new ColorMenuImageDescriptor(this.getBasicImageData(), rgb).createImage();
                this.getItem().setImage(this.overlyedImage);
            }
            this.lastColor = FigureUtilities.RGBToInteger((RGB)rgb);
            this.runWithEvent(event);
        }
    }

    protected IWorkbenchPart getWorkbenchPart() {
        IWorkbenchPart resultWorkbenchPart = super.getWorkbenchPart();
        if (resultWorkbenchPart == null && PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
            resultWorkbenchPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        }
        return resultWorkbenchPart;
    }

    protected RGB getBrowseColor() {
        ColorDialog dialog = new ColorDialog(Display.getCurrent().getActiveShell());
        WindowUtil.centerDialog((Shell)dialog.getParent(), (Shell)Display.getCurrent().getActiveShell());
        if (this.lastColor != null) {
            dialog.setRGB(FigureUtilities.integerToRGB((Integer)this.lastColor));
        }
        dialog.open();
        return dialog.getRGB();
    }

    protected RGB getDefaultColor() {
        for (EditPart editpart : this.getOperationSet()) {
            EStructuralFeature feature;
            Object preferredValue;
            if (!(editpart instanceof IGraphicalEditPart) || !((preferredValue = ((IGraphicalEditPart)editpart).getPreferredValue(feature = (EStructuralFeature)PackageUtil.getElement((String)this.getPropertyId()))) instanceof Integer)) continue;
            return FigureUtilities.integerToRGB((Integer)((Integer)preferredValue));
        }
        return DEFAULT_PREF_COLOR;
    }

    protected ImageData getBasicImageData() {
        return this.basicImageData;
    }

    public static ColorPropertyContributionItem createFontColorContributionItem(IWorkbenchPage workbenchPage) {
        String propertyName = DiagramUIActionsMessages.PropertyDescriptorFactory_FontColor;
        String toolTipText = DiagramUIActionsMessages.ColorChangeActionMenu_fontColor;
        ImageData basicImageData = DiagramUIActionsPluginImages.DESC_FONT_COLOR.getImageData();
        ImageData disabledBasicImageData = DiagramUIActionsPluginImages.DESC_FONT_COLOR_DISABLED.getImageData();
        return new ColorPropertyContributionItem(workbenchPage, "fontColorContributionItem", Properties.ID_FONTCOLOR, propertyName, toolTipText, basicImageData, disabledBasicImageData);
    }

    public static ColorPropertyContributionItem createLineColorContributionItem(IWorkbenchPage workbenchPage) {
        String propertyName = DiagramUIActionsMessages.PropertyDescriptorFactory_LineColor;
        String toolTipText = DiagramUIActionsMessages.ColorChangeActionMenu_lineColor;
        ImageData basicImageData = DiagramUIActionsPluginImages.DESC_LINE_COLOR.getImageData();
        ImageData disabledBasicImageData = DiagramUIActionsPluginImages.DESC_LINE_COLOR_DISABLED.getImageData();
        return new ColorPropertyContributionItem(workbenchPage, "lineColorContributionItem", Properties.ID_LINECOLOR, propertyName, toolTipText, basicImageData, disabledBasicImageData);
    }

    public static ColorPropertyContributionItem createFillColorContributionItem(IWorkbenchPage workbenchPage) {
        String propertyName = DiagramUIActionsMessages.PropertyDescriptorFactory_FillColor;
        String toolTipText = DiagramUIActionsMessages.ColorChangeActionMenu_fillColor;
        ImageData basicImageData = DiagramUIActionsPluginImages.DESC_FILL_COLOR.getImageData();
        ImageData disabledBasicImageData = DiagramUIActionsPluginImages.DESC_FILL_COLOR_DISABLED.getImageData();
        return new ColorPropertyContributionItem(workbenchPage, "fillColorContributionItem", Properties.ID_FILLCOLOR, propertyName, toolTipText, basicImageData, disabledBasicImageData);
    }

    private static class ColorBoxImageDescriptor
    extends ImageDescriptor {
        private RGB rgb;

        ColorBoxImageDescriptor(RGB rgb) {
            this.rgb = rgb;
        }

        public ImageData getImageData() {
            ImageData data = new ImageData(ICON_SIZE.x, ICON_SIZE.y, 1, new PaletteData(new RGB[]{this.rgb, OUTLINE_COLOR}));
            int i = 0;
            while (i < ICON_SIZE.y) {
                data.setPixel(0, i, 1);
                ++i;
            }
            i = 0;
            while (i < ICON_SIZE.y) {
                data.setPixel(ICON_SIZE.x - 1, i, 1);
                ++i;
            }
            i = 0;
            while (i < ICON_SIZE.x) {
                data.setPixel(i, 0, 1);
                ++i;
            }
            i = 0;
            while (i < ICON_SIZE.x) {
                data.setPixel(i, ICON_SIZE.y - 1, 1);
                ++i;
            }
            return data;
        }
    }

    private static class ColorMenuImageDescriptor
    extends CompositeImageDescriptor {
        private ImageData basicImgData;
        private RGB rgb;

        ColorMenuImageDescriptor(ImageData basicImgData, RGB rgb) {
            this.basicImgData = basicImgData;
            this.rgb = rgb;
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.basicImgData, 0, 0);
            if (this.rgb != null) {
                ImageData colorBar = new ImageData(14, 4, 1, new PaletteData(new RGB[]{this.rgb}));
                this.drawImage(colorBar, 1, height - 4);
            }
        }

        protected Point getSize() {
            return ICON_SIZE;
        }
    }

    private static final class InventoryColorDescriptor {
        private RGB colorValue;
        private String colorName;

        private InventoryColorDescriptor(RGB colorValue, String colorName) {
            this.colorValue = colorValue;
            this.colorName = colorName;
        }
    }
}

