/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.wizard.project;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.IMavenDiscoveryProposal;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.LifecycleMappingDiscoveryRequest;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.MojoExecutionMappingConfiguration;
import org.eclipse.m2e.core.ui.internal.wizards.MappingDiscoveryJob;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.job.ResourceBlockingOperationJob;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.project.ScoutProjectNewOperation;
import org.eclipse.scout.sdk.s2e.ui.internal.S2ESdkUiActivator;
import org.eclipse.scout.sdk.s2e.ui.internal.wizard.project.ScoutProjectNewWizardPage;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractWizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.osgi.framework.Version;

public class ScoutProjectNewWizard
extends AbstractWizard
implements INewWizard {
    private static final String EXEC_ENV_PREFIX = "JavaSE-";
    private static final String MIN_JVM_VERSION = "1.8";
    private ScoutProjectNewWizardPage m_page1;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("New Scout Project");
        this.setHelpAvailable(true);
        this.setDefaultPageImageDescriptor(S2ESdkUiActivator.getImageDescriptor("newscoutprj_wiz.png"));
        this.m_page1 = new ScoutProjectNewWizardPage();
        this.addPage((IWizardPage)this.m_page1);
    }

    @Override
    public boolean performFinish() {
        if (!super.performFinish()) {
            return false;
        }
        final ScoutProjectNewOperation op = new ScoutProjectNewOperation();
        op.setDisplayName(this.m_page1.getDisplayName());
        op.setGroupId(this.m_page1.getGroupId());
        op.setArtifactId(this.m_page1.getArtifactId());
        op.setJavaVersion(ScoutProjectNewWizard.getDefaultWorkspaceJavaVersion());
        if (this.m_page1.isUseWorkspaceLocation()) {
            op.setTargetDirectory(ScoutProjectNewWizardPage.getWorkspaceLocation());
        } else {
            op.setTargetDirectory(this.m_page1.getTargetDirectory());
        }
        String path = null;
        if (this.m_page1.getTargetDirectory() != null) {
            path = this.m_page1.getTargetDirectory().getAbsolutePath();
        }
        this.getDialogSettings().put("targetDirSetting", path);
        final ResourceBlockingOperationJob projectCreationJob = new ResourceBlockingOperationJob((IOperation)op);
        projectCreationJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                List createdProjects;
                if (projectCreationJob.getResult().isOK() && (createdProjects = op.getCreatedProjects()) != null && !createdProjects.isEmpty()) {
                    ScoutProjectNewWizard.this.discoverMapping(createdProjects);
                }
            }
        });
        projectCreationJob.schedule();
        return true;
    }

    protected void discoverMapping(List<IProject> projects) {
        P_MappingDiscoveryJob discoveryJob = new P_MappingDiscoveryJob(projects);
        discoveryJob.schedule();
    }

    protected static String getDefaultWorkspaceJavaVersion() {
        return ScoutProjectNewWizard.versionToString(ScoutProjectNewWizard.computeDefaultWorkspaceJavaVersion());
    }

    protected static String versionToString(Version version) {
        StringBuilder b = new StringBuilder(4);
        b.append(version.getMajor());
        if (version.getMinor() != 0) {
            b.append('.').append(version.getMinor());
        }
        return b.toString();
    }

    protected static Version computeDefaultWorkspaceJavaVersion() {
        Version result = Version.parseVersion((String)MIN_JVM_VERSION);
        IVMInstall defaultVm = JavaRuntime.getDefaultVMInstall();
        if (defaultVm == null) {
            return result;
        }
        IExecutionEnvironment[] iExecutionEnvironmentArray = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        int n = iExecutionEnvironmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Version cur;
            IExecutionEnvironment env = iExecutionEnvironmentArray[n2];
            if (env.isStrictlyCompatible(defaultVm) && (cur = ScoutProjectNewWizard.execEnvironmentToVersion(env.getId())).compareTo(result) > 0) {
                result = cur;
            }
            ++n2;
        }
        return result;
    }

    protected static Version execEnvironmentToVersion(String executionEnvId) {
        String numPart;
        if (executionEnvId != null && executionEnvId.startsWith(EXEC_ENV_PREFIX) && StringUtils.isNotBlank((CharSequence)(numPart = executionEnvId.substring(EXEC_ENV_PREFIX.length())))) {
            try {
                return Version.parseVersion((String)numPart);
            }
            catch (IllegalArgumentException e) {
                SdkLog.warning((String)"Invalid number part ({}) in execution environment {}.", (Object[])new Object[]{numPart, executionEnvId, e});
            }
        }
        return Version.parseVersion((String)MIN_JVM_VERSION);
    }

    protected static final class P_MappingDiscoveryJob
    extends MappingDiscoveryJob {
        public P_MappingDiscoveryJob(Collection<IProject> projects) {
            super(projects);
        }

        protected void discoverProposals(LifecycleMappingDiscoveryRequest discoveryRequest, IProgressMonitor monitor) throws CoreException {
            super.discoverProposals(discoveryRequest, monitor);
            for (Map.Entry entry : discoveryRequest.getAllProposals().entrySet()) {
                List proposals;
                MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement req;
                if (!(entry.getKey() instanceof MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement) || !"default-compile".equals((req = (MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement)entry.getKey()).getExecutionId()) && !"default-testCompile".equals(req.getExecutionId()) || (proposals = (List)entry.getValue()) == null || proposals.size() <= 1) continue;
                Iterator iterator = proposals.iterator();
                while (iterator.hasNext()) {
                    IMavenDiscoveryProposal proposal = (IMavenDiscoveryProposal)iterator.next();
                    if (proposal != null && proposal.toString().endsWith("Eclipse JDT Compiler")) continue;
                    iterator.remove();
                }
            }
        }
    }
}

