/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt.internal;

import org.eclipse.sapphire.Color;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.forms.BrowseActionHandler;
import org.eclipse.sapphire.ui.forms.PropertyEditorCondition;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Shell;

public final class ColorBrowseActionHandler
extends BrowseActionHandler {
    @Override
    protected String browse(Presentation context) {
        Value<?> property = this.property();
        Shell parent = ((FormComponentPresentation)context).shell();
        Rectangle bounds = parent.getBounds();
        int x = bounds.x + bounds.width / 2 - 120;
        int y = bounds.y + bounds.height / 2 - 170;
        Shell shell = new Shell(parent);
        try {
            shell.setBounds(x, y, 0, 0);
            ColorDialog dialog = new ColorDialog(shell);
            dialog.setText(property.definition().getLabel(false, CapitalizationType.TITLE_STYLE, false));
            dialog.setRGB(ColorBrowseActionHandler.convert((Color)property.content()));
            RGB pickedColor = dialog.open();
            if (pickedColor != null) {
                String string = ColorBrowseActionHandler.convert(pickedColor).toString();
                return string;
            }
        }
        finally {
            shell.dispose();
        }
        return null;
    }

    private static Color convert(RGB rgb) {
        return rgb == null ? null : new Color(rgb.red, rgb.green, rgb.blue);
    }

    private static RGB convert(Color color) {
        return color == null ? null : new RGB(color.red(), color.green(), color.blue());
    }

    public static final class Condition
    extends PropertyEditorCondition {
        @Override
        protected boolean evaluate(PropertyEditorPart part) {
            return part.property().definition().getTypeClass() == Color.class;
        }
    }
}

