/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.editor;

import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.ui.PartValidationEvent;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapeUpdateEvent;
import org.eclipse.sapphire.ui.diagram.editor.ValidationMarkerContentEvent;
import org.eclipse.sapphire.ui.diagram.shape.def.ValidationMarkerDef;
import org.eclipse.sapphire.ui.diagram.shape.def.ValidationMarkerSize;

public class ValidationMarkerPart
extends ShapePart {
    private ValidationMarkerDef markerDef;
    private Listener validationListener;
    private SapphirePart containerParent;

    @Override
    protected void init() {
        super.init();
        this.markerDef = (ValidationMarkerDef)this.definition;
        this.containerParent = this.getContainerParent();
        this.validationListener = new FilteredListener<PartValidationEvent>(){

            protected void handleTypedEvent(PartValidationEvent event) {
                ValidationMarkerPart.this.broadcast(new ValidationMarkerContentEvent(ValidationMarkerPart.this));
                ValidationMarkerPart.this.broadcast(new ShapeUpdateEvent(ValidationMarkerPart.this));
            }
        };
        this.containerParent.attach(this.validationListener);
    }

    public ValidationMarkerSize getSize() {
        return (ValidationMarkerSize)((Object)this.markerDef.getSize().content());
    }

    public Status content() {
        return this.containerParent.validation();
    }

    public SapphirePart getContainerParent() {
        if (this.containerParent == null) {
            DiagramNodePart nodePart = this.nearest(DiagramNodePart.class);
            if (nodePart.getLocalModelElement() == this.getLocalModelElement()) {
                this.containerParent = nodePart;
            } else {
                SapphirePart part = this;
                SapphirePart parentPart = (SapphirePart)this.parent();
                while (!(parentPart instanceof DiagramNodePart) && parentPart.getLocalModelElement() == this.getLocalModelElement()) {
                    part = parentPart;
                    parentPart = (SapphirePart)parentPart.parent();
                }
                this.containerParent = part;
            }
        }
        return this.containerParent;
    }

    @Override
    public void dispose() {
        if (this.validationListener != null) {
            this.containerParent.detach(this.validationListener);
            this.validationListener = null;
        }
        super.dispose();
    }

    @Override
    protected Function initVisibleWhenFunction() {
        Function function = new Function(){

            public String name() {
                return "ValidationMarkerVisibleWhen";
            }

            public FunctionResult evaluate(FunctionContext context) {
                return new FunctionResult(this, context){
                    private Listener validationListener;

                    protected void init() {
                        this.validationListener = new FilteredListener<ValidationMarkerContentEvent>(){

                            protected void handleTypedEvent(ValidationMarkerContentEvent event) {
                                this.refresh();
                            }
                        };
                        ValidationMarkerPart.this.attach(this.validationListener);
                    }

                    protected Object evaluate() {
                        Status status = ValidationMarkerPart.this.content();
                        return !status.ok();
                    }

                    public void dispose() {
                        super.dispose();
                        ValidationMarkerPart.this.detach(this.validationListener);
                    }
                };
            }
        };
        function.init(new Function[0]);
        return function;
    }
}

