/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.actions;

import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;

public class DiagramNodeAddActionHandler
extends SapphireActionHandler {
    public static final String ID_BASE = "Sapphire.Add.";
    private DiagramNodeTemplate nodeTemplate;

    public DiagramNodeAddActionHandler(DiagramNodeTemplate nodeTemplate) {
        this.nodeTemplate = nodeTemplate;
    }

    @Override
    public void init(SapphireAction action, ActionHandlerDef def) {
        ImageData typeSpecificAddImage;
        super.init(action, def);
        this.setId(ID_BASE + this.nodeTemplate.getNodeTypeId());
        if (this.nodeTemplate.getToolPaletteLabel() != null) {
            this.setLabel(this.nodeTemplate.getToolPaletteLabel());
        }
        if ((typeSpecificAddImage = this.nodeTemplate.getNodeType().image()) != null) {
            this.addImage(typeSpecificAddImage);
        }
    }

    @Override
    protected Object run(Presentation context) {
        SapphireDiagramEditorPagePart diagramPart = (SapphireDiagramEditorPagePart)this.nodeTemplate.parent();
        DiagramNodePart nodePart = this.nodeTemplate.createNewDiagramNode();
        Point pt = diagramPart.getMouseLocation();
        nodePart.setNodeBounds(pt.getX(), pt.getY());
        diagramPart.selectAndDirectEdit(nodePart);
        return nodePart;
    }

    public DiagramNodeTemplate getNodeTemplate() {
        return this.nodeTemplate;
    }
}

