/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;
import org.eclipse.swt.widgets.Shell;

public final class PropertyEditorAssistContext {
    private final SapphirePart part;
    private final Shell shell;
    private final LinkedHashMap<String, PropertyEditorAssistSection> sections;
    private final Map<String, PropertyEditorAssistSection> sectionsReadOnly;

    public PropertyEditorAssistContext(SapphirePart part, Shell shell) {
        this.part = part;
        this.shell = shell;
        this.sections = new LinkedHashMap();
        this.sectionsReadOnly = Collections.unmodifiableMap(this.sections);
    }

    public SapphirePart getPart() {
        return this.part;
    }

    public Shell getShell() {
        return this.shell;
    }

    public boolean isEmpty() {
        for (PropertyEditorAssistSection section : this.sections.values()) {
            if (section.getContributions().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Map<String, PropertyEditorAssistSection> getSections() {
        return this.sectionsReadOnly;
    }

    public PropertyEditorAssistSection getSection(String id) {
        PropertyEditorAssistSection section = this.sections.get(id);
        if (section == null) {
            section = new PropertyEditorAssistSection(id);
            this.sections.put(id, section);
        }
        return section;
    }
}

