/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.core;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.internal.core.RemoteCorePlugin;
import org.eclipse.remote.internal.core.RemotePath;
import org.eclipse.remote.internal.core.preferences.Preferences;

public class RemoteServicesUtils {
    public static IPath posixPath(String path) {
        try {
            return Path.forPosix((String)path);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return RemotePath.forPosix(path);
        }
    }

    public static URI toURI(IPath path) {
        if (path.isUNC()) {
            IRemoteServicesManager manager = RemoteCorePlugin.getService(IRemoteServicesManager.class);
            String[] parts = path.segment(0).split(":");
            IRemoteConnectionType services = null;
            String connName = null;
            if (parts.length == 2) {
                services = manager.getConnectionType(parts[0]);
                connName = parts[1];
            } else if (parts.length == 1) {
                String id = Preferences.getString("connectionTypeId");
                if (id != null) {
                    services = manager.getConnectionType(id);
                }
                connName = parts[0];
            }
            IRemoteConnection conn = null;
            if (services != null) {
                conn = services.getConnection(connName);
            } else if (connName != null) {
                for (IRemoteConnectionType s : manager.getAllConnectionTypes()) {
                    if (s != null && (conn = s.getConnection(connName)) != null) break;
                }
            }
            if (conn != null) {
                String scheme = conn.getConnectionType().getScheme();
                String filePath = path.removeFirstSegments(1).makeAbsolute().toString();
                try {
                    return new URI(scheme, connName, filePath, null, null);
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        }
        return null;
    }
}

