/**
 */
package org.eclipse.recommenders.snipmatch.rcp.model.impl;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.recommenders.snipmatch.ISnippetRepository;

import org.eclipse.recommenders.snipmatch.model.impl.SnippetRepositoryConfigurationImpl;

import org.eclipse.recommenders.snipmatch.rcp.model.EclipseGitSnippetRepositoryConfiguration;
import org.eclipse.recommenders.snipmatch.rcp.model.SnipmatchRcpModelPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Eclipse Git Snippet Repository Configuration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.recommenders.snipmatch.rcp.model.impl.EclipseGitSnippetRepositoryConfigurationImpl#getUrl <em>Url</em>}</li>
 *   <li>{@link org.eclipse.recommenders.snipmatch.rcp.model.impl.EclipseGitSnippetRepositoryConfigurationImpl#getPushUrl <em>Push Url</em>}</li>
 *   <li>{@link org.eclipse.recommenders.snipmatch.rcp.model.impl.EclipseGitSnippetRepositoryConfigurationImpl#getPushBranchPrefix <em>Push Branch Prefix</em>}</li>
 * </ul>
 *
 * @generated
 */
public class EclipseGitSnippetRepositoryConfigurationImpl extends SnippetRepositoryConfigurationImpl implements EclipseGitSnippetRepositoryConfiguration {
	/**
	 * The default value of the '{@link #getUrl() <em>Url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUrl()
	 * @generated
	 * @ordered
	 */
	protected static final String URL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getUrl() <em>Url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUrl()
	 * @generated
	 * @ordered
	 */
	protected String url = URL_EDEFAULT;

	/**
	 * The default value of the '{@link #getPushUrl() <em>Push Url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPushUrl()
	 * @generated
	 * @ordered
	 */
	protected static final String PUSH_URL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getPushUrl() <em>Push Url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPushUrl()
	 * @generated
	 * @ordered
	 */
	protected String pushUrl = PUSH_URL_EDEFAULT;

	/**
	 * The default value of the '{@link #getPushBranchPrefix() <em>Push Branch Prefix</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPushBranchPrefix()
	 * @generated
	 * @ordered
	 */
	protected static final String PUSH_BRANCH_PREFIX_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getPushBranchPrefix() <em>Push Branch Prefix</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPushBranchPrefix()
	 * @generated
	 * @ordered
	 */
	protected String pushBranchPrefix = PUSH_BRANCH_PREFIX_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EclipseGitSnippetRepositoryConfigurationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SnipmatchRcpModelPackage.Literals.ECLIPSE_GIT_SNIPPET_REPOSITORY_CONFIGURATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getUrl() {
		return url;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUrl(String newUrl) {
		String oldUrl = url;
		url = newUrl;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SnipmatchRcpModelPackage.ECLIPSE_GIT_SNIPPET_REPOSITORY_CONFIGURATION__URL, oldUrl, url));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getPushUrl() {
		return pushUrl;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPushUrl(String newPushUrl) {
		String oldPushUrl = pushUrl;
		pushUrl = newPushUrl;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SnipmatchRcpModelPackage.ECLIPSE_GIT_SNIPPET_REPOSITORY_CONFIGURATION__PUSH_URL, oldPushUrl, pushUrl));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getPushBranchPrefix() {
		return pushBranchPrefix;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPushBranchPrefix(String newPushBranchPrefix) {
		String oldPushBranchPrefix = pushBranchPrefix;
		pushBranchPrefix = newPushBranchPrefix;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SnipmatchRcpModelPackage.ECLIPSE_GIT_SNIPPET_REPOSITORY_CONFIGURATION__PUSH_BRANCH_PREFIX, oldPushBranchPrefix, pushBranchPrefix));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ISnippetRepository createRepositoryInstance() {
		return org.eclipse.recommenders.internal.snipmatch.rcp.EclipseGitSnippetRepository.createRepositoryInstance(this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SnipmatchRcpModelPackage.ECLIPSE_GIT_SNIPPET_REPOSITORY_CONFIGURATION__URL:
				return getUrl();
			case SnipmatchRcpModelPackage.ECLIPSE_GIT_SNIPPET_REPOSITORY_CONFIGURATION__PUSH_URL:
				return getPushUrl();
			case SnipmatchRcpModelPackage.ECLIPSE_GIT_SNIPPET_REPOSITORY_CONFIGURATION__PUSH_BRANCH_PREFIX:
				return getPushBranchPrefix();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SnipmatchRcpModelPackage.ECLIPSE_GIT_SNIPPET_REPOSITORY_CONFIGURATION__URL:
				setUrl((String)newValue);
				return;
			case SnipmatchRcpModelPackage.ECLIPSE_GIT_SNIPPET_REPOSITORY_CONFIGURATION__PUSH_URL:
				setPushUrl((String)newValue);
				return;
			case SnipmatchRcpModelPackage.ECLIPSE_GIT_SNIPPET_REPOSITORY_CONFIGURATION__PUSH_BRANCH_PREFIX:
				setPushBranchPrefix((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SnipmatchRcpModelPackage.ECLIPSE_GIT_SNIPPET_REPOSITORY_CONFIGURATION__URL:
				setUrl(URL_EDEFAULT);
				return;
			case SnipmatchRcpModelPackage.ECLIPSE_GIT_SNIPPET_REPOSITORY_CONFIGURATION__PUSH_URL:
				setPushUrl(PUSH_URL_EDEFAULT);
				return;
			case SnipmatchRcpModelPackage.ECLIPSE_GIT_SNIPPET_REPOSITORY_CONFIGURATION__PUSH_BRANCH_PREFIX:
				setPushBranchPrefix(PUSH_BRANCH_PREFIX_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SnipmatchRcpModelPackage.ECLIPSE_GIT_SNIPPET_REPOSITORY_CONFIGURATION__URL:
				return URL_EDEFAULT == null ? url != null : !URL_EDEFAULT.equals(url);
			case SnipmatchRcpModelPackage.ECLIPSE_GIT_SNIPPET_REPOSITORY_CONFIGURATION__PUSH_URL:
				return PUSH_URL_EDEFAULT == null ? pushUrl != null : !PUSH_URL_EDEFAULT.equals(pushUrl);
			case SnipmatchRcpModelPackage.ECLIPSE_GIT_SNIPPET_REPOSITORY_CONFIGURATION__PUSH_BRANCH_PREFIX:
				return PUSH_BRANCH_PREFIX_EDEFAULT == null ? pushBranchPrefix != null : !PUSH_BRANCH_PREFIX_EDEFAULT.equals(pushBranchPrefix);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
		switch (operationID) {
			case SnipmatchRcpModelPackage.ECLIPSE_GIT_SNIPPET_REPOSITORY_CONFIGURATION___CREATE_REPOSITORY_INSTANCE:
				return createRepositoryInstance();
		}
		return super.eInvoke(operationID, arguments);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (url: ");
		result.append(url);
		result.append(", pushUrl: ");
		result.append(pushUrl);
		result.append(", pushBranchPrefix: ");
		result.append(pushBranchPrefix);
		result.append(')');
		return result.toString();
	}

} //EclipseGitSnippetRepositoryConfigurationImpl
