/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.handler;

import java.util.List;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.papyrus.infra.core.clipboard.PapyrusClipboard;
import org.eclipse.papyrus.infra.ui.command.AbstractCommandHandler;
import org.eclipse.papyrus.views.modelexplorer.handler.CopyHandler;
import org.eclipse.papyrus.views.modelexplorer.handler.DeleteCommandHandler;

public class CutHandler
extends AbstractCommandHandler {
    protected Command getCommand(IEvaluationContext context) {
        CompoundCommand cutInModelExplorerCommand = new CompoundCommand("Cut in Model Explorer Command");
        Command copyCommand = CopyHandler.buildCopyCommand(this.getEditingDomain(context), this.getSelectedElements());
        cutInModelExplorerCommand.append(copyCommand);
        Command deleteCommand = DeleteCommandHandler.buildDeleteCommand(this.getSelectedElements());
        cutInModelExplorerCommand.append(deleteCommand);
        return cutInModelExplorerCommand;
    }

    protected boolean computeEnabled(IEvaluationContext context) {
        List selectedElements = this.getSelectedElements();
        return CopyHandler.isCopyEnabled(selectedElements) && DeleteCommandHandler.isDeleteEnabled(selectedElements);
    }

    public void setEnabled(Object evaluationContext) {
        PapyrusClipboard instance = PapyrusClipboard.getInstance();
        super.setEnabled(evaluationContext);
        PapyrusClipboard.setInstance((PapyrusClipboard)instance);
    }
}

