/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.parsers;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.uml.diagram.clazz.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;

public class TemplateBindingParser
implements IParser {
    private static final String EMPTY_STR = "";
    final ILabelProvider labelProvider = new AdapterFactoryLabelProvider(UMLDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory());

    public String getEditString(IAdaptable element, int flags) {
        return this.getPrintString(element, flags);
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return new ParserEditStatus("org.eclipse.papyrus.uml.diagram.clazz", 0, EMPTY_STR);
    }

    public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
        return UnexecutableCommand.INSTANCE;
    }

    public String getPrintString(IAdaptable element, int flags) {
        String out = EMPTY_STR;
        EObject e = (EObject)element.getAdapter(EObject.class);
        if (e != null) {
            TemplateBinding binding = (TemplateBinding)e;
            for (TemplateParameterSubstitution substitution : binding.getParameterSubstitutions()) {
                if (!EMPTY_STR.equals(out)) {
                    out = String.valueOf(out) + ", ";
                }
                if (substitution.getFormal() != null && substitution.getFormal().getParameteredElement() instanceof NamedElement) {
                    out = String.valueOf(out) + UMLLabelInternationalization.getInstance().getLabel((NamedElement)substitution.getFormal().getParameteredElement());
                }
                if (!(substitution.getActual() instanceof NamedElement)) continue;
                out = String.valueOf(out) + " -> " + UMLLabelInternationalization.getInstance().getLabel((NamedElement)substitution.getActual());
            }
        }
        out = EMPTY_STR.equals(out) ? String.format("\ufffdbind\ufffd\n<No Binding Substitution>", out) : String.format("\ufffdbind\ufffd\n<%s>", out);
        return out;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        return true;
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }
}

