/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.transformer.jplis;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.objectteams.otredyn.bytecode.AbstractBoundClass;
import org.eclipse.objectteams.otredyn.bytecode.ClassRepository;
import org.eclipse.objectteams.otredyn.bytecode.asm.WeavableRegionReader;
import org.eclipse.objectteams.otredyn.transformer.IWeavingContext;
import org.eclipse.objectteams.runtime.IReweavingTask;

public class ObjectTeamsTransformer
implements ClassFileTransformer {
    private IWeavingContext weavingContext;
    private Set<String> boundBaseClassNames = new HashSet<String>();

    public ObjectTeamsTransformer() {
        this.weavingContext = new IWeavingContext(){

            @Override
            public boolean isWeavable(String className) {
                return ObjectTeamsTransformer.isWeavable(className.replace('.', '/')) && WeavableRegionReader.isWeavable(className);
            }

            @Override
            public boolean scheduleReweaving(String className, IReweavingTask task) {
                return false;
            }
        };
    }

    public ObjectTeamsTransformer(IWeavingContext weavingContext) {
        this.weavingContext = weavingContext;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        try {
            return this.transform(loader, className, className, classBeingRedefined, classfileBuffer);
        }
        catch (IllegalClassFormatException e) {
            e.printStackTrace();
            return classfileBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] transform(ClassLoader loader, String className, String classId, Class<?> classBeingRedefined, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (className == null) {
            return null;
        }
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        ClassRepository classRepo = ClassRepository.getInstance();
        AbstractBoundClass clazz = classRepo.peekBoundClass(classId);
        String sourceClassName = className.replace('/', '.');
        if (!this.weavingContext.isWeavable(sourceClassName) || loader == null) {
            if (clazz == null) return null;
            if (ObjectTeamsTransformer.isWeavable(className) && clazz.needsWeaving()) {
                new LinkageError("Classs " + className + " requires weaving, but is not weavable!").printStackTrace();
                return null;
            }
            clazz.markAsUnweavable();
            return null;
        }
        if (clazz == null) {
            clazz = classRepo.getBoundClass(sourceClassName, classId, loader);
        }
        AbstractBoundClass abstractBoundClass = clazz;
        synchronized (abstractBoundClass) {
            if (classBeingRedefined == null && !clazz.isFirstTransformation()) {
                return clazz.getBytecode();
            }
            try {
                if (clazz.isTransformationActive()) {
                    return null;
                }
                clazz = classRepo.getBoundClass(className, classId, classfileBuffer, loader);
                clazz.setWeavingContext(this.weavingContext);
                if (!clazz.isInterface()) {
                    classRepo.linkClassWithSuperclass(clazz);
                }
                if (!clazz.isInterface() || clazz.isRole()) {
                    clazz.transformAtLoadTime();
                }
                classfileBuffer = clazz.getBytecode();
            }
            catch (IllegalClassFormatException e) {
                throw e;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        clazz.dump(classfileBuffer, "initial");
        Collection<String> boundBaseClasses = clazz.getBoundBaseClasses();
        if (boundBaseClasses == null) return classfileBuffer;
        this.boundBaseClassNames.addAll(boundBaseClasses);
        return classfileBuffer;
    }

    public static boolean isWeavable(String className) {
        switch (className.charAt(0)) {
            case 'o': {
                if (!className.startsWith("org/eclipse/objectteams/otre") && !className.startsWith("org/objectteams/") && !className.startsWith("org/objectweb/asm")) break;
                return false;
            }
            case 's': {
                if (!className.startsWith("sun/misc")) break;
                return false;
            }
            case 'j': {
                if (!className.equals("java/util/LinkedHashMap$KeyIterator") && !className.startsWith("java/lang") && !className.startsWith("java/util") && !className.startsWith("java/io")) break;
                return false;
            }
            case '$': {
                return false;
            }
        }
        return true;
    }

    public void readOTAttributes(String className, String classId, InputStream inputStream, ClassLoader loader) throws ClassFormatError, IOException {
        Collection<String> boundBaseClasses;
        AbstractBoundClass clazz = ClassRepository.getInstance().getBoundClass(className.replace('/', '.'), classId, loader);
        if (!clazz.isFirstTransformation()) {
            return;
        }
        try {
            if (clazz.isTransformationActive()) {
                return;
            }
            int available = inputStream.available();
            byte[] bytes = new byte[available];
            new DataInputStream(inputStream).readFully(bytes);
            clazz = ClassRepository.getInstance().getBoundClass(className, classId, bytes, loader);
            if (!clazz.isInterface()) {
                ClassRepository.getInstance().linkClassWithSuperclass(clazz);
            }
            if (!clazz.isInterface() || clazz.isRole()) {
                clazz.parseBytecode();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if ((boundBaseClasses = clazz.getBoundBaseClasses()) != null) {
            this.boundBaseClassNames.addAll(boundBaseClasses);
        }
    }

    public Collection<String> fetchAdaptedBases() {
        try {
            Set<String> set = this.boundBaseClassNames;
            return set;
        }
        finally {
            this.boundBaseClassNames = new HashSet<String>();
        }
    }
}

