/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.team.ui;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.team.ui.FocusedTeamExtensionPointReader;
import org.eclipse.mylyn.internal.team.ui.templates.CommitTemplateManager;
import org.eclipse.mylyn.team.ui.AbstractActiveChangeSetProvider;
import org.eclipse.mylyn.team.ui.AbstractContextChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class FocusedTeamUiPlugin
extends AbstractUIPlugin {
    public static final String ID_PLUGIN = "org.eclipse.mylyn.team.ui";
    private static FocusedTeamUiPlugin INSTANCE;
    private final Set<AbstractContextChangeSetManager> changeSetManagers = new HashSet<AbstractContextChangeSetManager>();
    private final Map<ActiveChangeSetManager, AbstractActiveChangeSetProvider> activeChangeSetProviders = new HashMap<ActiveChangeSetManager, AbstractActiveChangeSetProvider>();
    private CommitTemplateManager commitTemplateManager;
    public static final String CHANGE_SET_MANAGE = "org.eclipse.mylyn.team.changesets.manage";
    public static final String COMMIT_TEMPLATE = "org.eclipse.mylyn.team.commit.template";
    public static final String DEFAULT_COMMIT_TEMPLATE = "${task.key}: ${task.description} \n\nTask-Url: ${task.url}";

    public FocusedTeamUiPlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initPreferenceDefaults();
        this.commitTemplateManager = new CommitTemplateManager();
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    FocusedTeamExtensionPointReader extensionPointReader = new FocusedTeamExtensionPointReader();
                    extensionPointReader.readExtensions();
                    if (FocusedTeamUiPlugin.this.getPreferenceStore().getBoolean(FocusedTeamUiPlugin.CHANGE_SET_MANAGE)) {
                        for (AbstractContextChangeSetManager changeSetManager : FocusedTeamUiPlugin.this.changeSetManagers) {
                            changeSetManager.enable();
                        }
                    }
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(4, FocusedTeamUiPlugin.ID_PLUGIN, "Mylyn Team start failed", (Throwable)e));
                }
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        INSTANCE = null;
        super.stop(context);
        for (AbstractContextChangeSetManager changeSetManager : this.changeSetManagers) {
            changeSetManager.disable();
        }
    }

    private void initPreferenceDefaults() {
        this.getPreferenceStore().setDefault(CHANGE_SET_MANAGE, true);
        this.getPreferenceStore().setDefault(COMMIT_TEMPLATE, DEFAULT_COMMIT_TEMPLATE);
    }

    public static FocusedTeamUiPlugin getDefault() {
        return INSTANCE;
    }

    public void addContextChangeSetManager(AbstractContextChangeSetManager changeSetManager) {
        this.changeSetManagers.add(changeSetManager);
    }

    public boolean removeContextChangeSetManager(AbstractContextChangeSetManager changeSetManager) {
        return this.changeSetManagers.remove((Object)changeSetManager);
    }

    public void addActiveChangeSetProvider(AbstractActiveChangeSetProvider provider) {
        ActiveChangeSetManager manager = provider.getActiveChangeSetManager();
        if (manager != null) {
            this.activeChangeSetProviders.put(manager, provider);
        }
    }

    public Collection<AbstractActiveChangeSetProvider> getActiveChangeSetProviders() {
        return this.activeChangeSetProviders.values();
    }

    public AbstractActiveChangeSetProvider getActiveChangeSetProvider(ActiveChangeSetManager manager) {
        return this.activeChangeSetProviders.get(manager);
    }

    public Set<AbstractContextChangeSetManager> getContextChangeSetManagers() {
        return Collections.unmodifiableSet(this.changeSetManagers);
    }

    public CommitTemplateManager getCommitTemplateManager() {
        return this.commitTemplateManager;
    }

    public static class FocusedTeamUiStartup
    implements IStartup {
        public void earlyStartup() {
        }
    }
}

