/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.mat.ui.editor.AbstractEditorPane;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.editor.MultiPaneEditorSite;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.PaneState;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.PageBook;

public abstract class CompositeHeapEditorPane
extends AbstractEditorPane
implements ISelectionProvider,
ISelectionChangedListener {
    private PageBook container;
    private AbstractEditorPane embeddedPane;
    List<ISelectionChangedListener> selectionListeners = Collections.synchronizedList(new ArrayList());

    protected void createContainer(Composite parent) {
        this.container = new PageBook(parent, 0);
    }

    protected void createResultPane(AbstractEditorPane pane, Object arguments) {
        this.disposeEmbeddedPane();
        try {
            this.embeddedPane = pane;
            this.embeddedPane.parentPane = this;
            this.setPane(this.embeddedPane, this.getEditorInput());
            this.embeddedPane.initWithArgument(arguments);
            MultiPaneEditor multiPaneEditor = ((MultiPaneEditorSite)this.getEditorSite()).getMultiPageEditor();
            multiPaneEditor.updateToolbar();
            if (this.embeddedPane instanceof ISelectionProvider) {
                ISelectionProvider embeddedProvider = (ISelectionProvider)this.embeddedPane;
                embeddedProvider.addSelectionChangedListener((ISelectionChangedListener)this);
                this.selectionChanged(new SelectionChangedEvent(embeddedProvider, embeddedProvider.getSelection()));
            }
            multiPaneEditor.getNavigatorState().paneAdded(this.embeddedPane.getPaneState());
        }
        catch (PartInitException e) {
            ErrorHelper.logThrowableAndShowMessage(e);
        }
    }

    private void disposeEmbeddedPane() {
        if (this.embeddedPane != null) {
            MultiPaneEditor multiPaneEditor = ((MultiPaneEditorSite)this.getEditorSite()).getMultiPageEditor();
            multiPaneEditor.getNavigatorState().paneRemoved(this.embeddedPane.getPaneState());
            if (this.embeddedPane instanceof ISelectionProvider) {
                ((ISelectionProvider)this.embeddedPane).removeSelectionChangedListener((ISelectionChangedListener)this);
            }
            Control[] controlArray = this.container.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.setVisible(false);
                control.dispose();
                ++n2;
            }
            this.embeddedPane.dispose();
            this.embeddedPane = null;
        }
    }

    public void closePage(PaneState state) {
        if (this.embeddedPane != null && this.embeddedPane.getPaneState() == state) {
            this.disposeEmbeddedPane();
        }
    }

    protected AbstractEditorPane getEmbeddedPane() {
        return this.embeddedPane;
    }

    private void setPane(AbstractEditorPane editor, IEditorInput input) throws PartInitException {
        editor.init(this.site, input);
        Composite parent2 = new Composite((Composite)this.container, Window.getDefaultOrientation());
        parent2.setLayout((Layout)new FillLayout());
        editor.createPartControl(parent2);
        this.container.showPage((Control)parent2);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        if (this.embeddedPane != null && this.embeddedPane instanceof ISelectionProvider) {
            return ((ISelectionProvider)this.embeddedPane).getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        if (this.embeddedPane != null && this.embeddedPane instanceof ISelectionProvider) {
            ((ISelectionProvider)this.embeddedPane).setSelection(selection);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ArrayList<ISelectionChangedListener> l = new ArrayList<ISelectionChangedListener>(this.selectionListeners);
        for (ISelectionChangedListener listener : l) {
            listener.selectionChanged(event);
        }
    }

    public void contributeToToolBar(IToolBarManager manager) {
        if (this.embeddedPane != null) {
            manager.add((IContributionItem)new Separator());
            this.embeddedPane.contributeToToolBar(manager);
        }
    }
}

