/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.osgi.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mat.inspections.osgi.model.BundleDescriptor;
import org.eclipse.mat.internal.MATPlugin;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Service {
    private String name;
    private int objectId;
    private BundleDescriptor bundleDescriptor;
    private List<BundleDescriptor> bundlesUsing;
    private String[] keys;
    private String[] values;

    public Service(String name, int objectId, BundleDescriptor bundleDescriptor, List<BundleDescriptor> bundlesUsing, String[] keys, String[] values) {
        this.name = name;
        this.objectId = objectId;
        this.bundleDescriptor = bundleDescriptor;
        this.bundlesUsing = bundlesUsing;
        this.keys = keys;
        this.values = values;
    }

    public BundleDescriptor getBundleDescriptor() {
        return this.bundleDescriptor;
    }

    public List<BundleDescriptor> getBundlesUsing() {
        return this.bundlesUsing;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public String getName() {
        return this.name;
    }

    public List<ServiceProperty> getProperties() {
        if (this.keys == null || this.values == null) {
            return null;
        }
        if (this.keys.length != this.values.length) {
            MATPlugin.log(MessageUtil.format((String)Messages.Service_ErrorMsg_MismatchKeysServices, (Object[])new Object[]{Long.toHexString(this.objectId)}));
            return null;
        }
        ArrayList<ServiceProperty> properties = new ArrayList<ServiceProperty>(this.keys.length);
        int i = 0;
        while (i < this.keys.length) {
            properties.add(new ServiceProperty(this.keys[i], this.values[i]));
            ++i;
        }
        return properties;
    }

    public class ServiceProperty {
        public String property;
        public String value;

        public ServiceProperty(String property, String value) {
            this.property = property;
            this.value = value;
        }
    }
}

